/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sun.rmi.runtime.Log;
import sun.rmi.server.DeserializationChecker;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final boolean logCalls = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
    public static final Log callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
    private transient Skeleton skel;
    private transient Map<Long, Method> hashToMethod_Map = null;
    private static final WeakClassHashMap<Map<Long, Method>> hashToMethod_Maps = new HashToMethod_Maps();
    private static final Map<Class<?>, ?> withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicInteger methodCallIDCount = new AtomicInteger(0);

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    public UnicastServerRef(int n) {
        super(new LiveRef(n));
    }

    public UnicastServerRef(boolean bl) {
        this(0);
        this.forceStubUse = bl;
    }

    @Override
    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        this.forceStubUse = true;
        return (RemoteStub)this.exportObject(remote, object, false);
    }

    public Remote exportObject(Remote remote, Object object, boolean bl) throws RemoteException {
        Remote remote2;
        Class<?> clazz = remote.getClass();
        try {
            remote2 = Util.createProxy(clazz, this.getClientRef(), this.forceStubUse);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExportException("remote object implements illegal remote interface", illegalArgumentException);
        }
        if (remote2 instanceof RemoteStub) {
            this.setSkeleton(remote);
        }
        Target target = new Target(remote, this, remote2, this.ref.getObjID(), bl);
        this.ref.exportObject(target);
        this.hashToMethod_Map = hashToMethod_Maps.get(clazz);
        return remote2;
    }

    @Override
    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote remote) throws RemoteException {
        if (!withoutSkeletons.containsKey(remote.getClass())) {
            try {
                this.skel = Util.createSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void dispatch(Remote var1_1, RemoteCall var2_2) throws IOException {
        try {
            var6_3 = var2_2.getInputStream();
            var3_6 = var6_3.readInt();
            if (var3_6 < 0) ** GOTO lbl10
            if (this.skel != null) {
                this.oldDispatch(var1_1, var2_2, var3_6);
                return;
            }
            try {
                throw new UnmarshalException("skeleton class not found but required for client version");
lbl10:
                // 1 sources

                var4_7 = var6_3.readLong();
            }
            catch (Exception var7_8) {
                throw new UnmarshalException("error unmarshalling call header", var7_8);
            }
            var7_9 = (MarshalInputStream)var6_3;
            var7_9.skipDefaultResolveClass();
            var8_11 = this.hashToMethod_Map.get(var4_7);
            if (var8_11 == null) {
                throw new UnmarshalException("unrecognized method hash: method not supported by remote object");
            }
            this.logCall(var1_1, var8_11);
            var9_12 = null;
            try {
                this.unmarshalCustomCallData(var6_3);
                var9_12 = this.unmarshalParameters(var1_1, var8_11, var7_9);
            }
            catch (IOException var10_13) {
                throw new UnmarshalException("error unmarshalling arguments", var10_13);
            }
            catch (ClassNotFoundException var10_14) {
                throw new UnmarshalException("error unmarshalling arguments", var10_14);
            }
            finally {
                var2_2.releaseInputStream();
            }
            try {
                var10_15 = var8_11.invoke((Object)var1_1, var9_12);
            }
            catch (InvocationTargetException var11_17) {
                throw var11_17.getTargetException();
            }
            try {
                var11_18 = var2_2.getResultStream(true);
                var12_20 = var8_11.getReturnType();
                if (var12_20 != Void.TYPE) {
                    UnicastServerRef.marshalValue(var12_20, var10_15, var11_18);
                }
            }
            catch (IOException var11_19) {
                throw new MarshalException("error marshalling return", var11_19);
            }
        }
        catch (Throwable var6_4) {
            this.logCallException(var6_4);
            var7_10 = var2_2.getResultStream(false);
            if (var6_4 instanceof Error) {
                var6_5 /* !! */  = new ServerError("Error occurred in server thread", (Error)var6_4);
            } else if (var6_4 instanceof RemoteException) {
                var6_5 /* !! */  = new ServerException("RemoteException occurred in server thread", (Exception)var6_4);
            }
            if (UnicastServerRef.suppressStackTraces) {
                UnicastServerRef.clearStackTraces(var6_5 /* !! */ );
            }
            var7_10.writeObject(var6_5 /* !! */ );
        }
        finally {
            var2_2.releaseInputStream();
            var2_2.releaseOutputStream();
        }
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldDispatch(Remote remote, RemoteCall remoteCall, int n) throws IOException {
        try {
            long l;
            ObjectInput objectInput;
            try {
                objectInput = remoteCall.getInputStream();
                try {
                    Class<?> clazz = Class.forName("sun.rmi.transport.DGCImpl_Skel");
                    if (clazz.isAssignableFrom(this.skel.getClass())) {
                        ((MarshalInputStream)objectInput).useCodebaseOnly();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                l = objectInput.readLong();
            }
            catch (Exception exception) {
                throw new UnmarshalException("error unmarshalling call header", exception);
            }
            this.logCall(remote, this.skel.getOperations()[n]);
            this.unmarshalCustomCallData(objectInput);
            this.skel.dispatch(remote, remoteCall, n, l);
        }
        catch (Throwable throwable) {
            RemoteException remoteException;
            this.logCallException(throwable);
            ObjectOutput objectOutput = remoteCall.getResultStream(false);
            if (throwable instanceof Error) {
                remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
            } else if (throwable instanceof RemoteException) {
                remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(remoteException);
            }
            objectOutput.writeObject(remoteException);
        }
        finally {
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
        }
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    private void logCall(Remote remote, Object object) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String string;
            try {
                string = this.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                string = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable throwable) {
        Object object;
        if (callLog.isLoggable(Log.BRIEF)) {
            object = "";
            try {
                object = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, (String)object + "exception: ", throwable);
        }
        if (wantExceptionLog) {
            Object object2 = object = System.err;
            synchronized (object2) {
                ((PrintStream)object).println();
                ((PrintStream)object).println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace((PrintStream)object);
            }
        }
    }

    @Override
    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    private Object[] unmarshalParameters(Object object, Method method, MarshalInputStream marshalInputStream) throws IOException, ClassNotFoundException {
        return object instanceof DeserializationChecker ? this.unmarshalParametersChecked((DeserializationChecker)object, method, marshalInputStream) : this.unmarshalParametersUnchecked(method, marshalInputStream);
    }

    private Object[] unmarshalParametersUnchecked(Method method, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = UnicastServerRef.unmarshalValue(classArray[i], objectInput);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] unmarshalParametersChecked(DeserializationChecker deserializationChecker, Method method, MarshalInputStream marshalInputStream) throws IOException, ClassNotFoundException {
        int n = this.methodCallIDCount.getAndIncrement();
        MyChecker myChecker = new MyChecker(deserializationChecker, method, n);
        marshalInputStream.setStreamChecker(myChecker);
        try {
            Class<?>[] classArray = method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                myChecker.setIndex(i);
                objectArray[i] = UnicastServerRef.unmarshalValue(classArray[i], marshalInputStream);
            }
            myChecker.end(n);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            marshalInputStream.setStreamChecker(null);
        }
    }

    private static class MyChecker
    implements MarshalInputStream.StreamChecker {
        private final DeserializationChecker descriptorCheck;
        private final Method method;
        private final int callID;
        private int parameterIndex;

        MyChecker(DeserializationChecker deserializationChecker, Method method, int n) {
            this.descriptorCheck = deserializationChecker;
            this.method = method;
            this.callID = n;
        }

        public void validateDescriptor(ObjectStreamClass objectStreamClass) {
            this.descriptorCheck.check(this.method, objectStreamClass, this.parameterIndex, this.callID);
        }

        @Override
        public void checkProxyInterfaceNames(String[] stringArray) {
            this.descriptorCheck.checkProxyClass(this.method, stringArray, this.parameterIndex, this.callID);
        }

        void setIndex(int n) {
            this.parameterIndex = n;
        }

        void end(int n) {
            this.descriptorCheck.end(n);
        }
    }

    private static class HashToMethod_Maps
    extends WeakClassHashMap<Map<Long, Method>> {
        HashToMethod_Maps() {
        }

        @Override
        protected Map<Long, Method> computeValue(Class<?> clazz) {
            HashMap<Long, Method> hashMap = new HashMap<Long, Method>();
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    if (!Remote.class.isAssignableFrom(clazz3)) continue;
                    Method[] methodArray = clazz3.getMethods();
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method method;
                        final Method method2 = method = methodArray[i];
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                method2.setAccessible(true);
                                return null;
                            }
                        });
                        hashMap.put(Util.computeMethodHash(method2), method2);
                    }
                }
            }
            return hashMap;
        }
    }
}

