/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessControlContext;
import java.security.ProtectionDomain;
import sun.misc.Unsafe;

public final class InnocuousThread
extends Thread {
    private static final Unsafe UNSAFE;
    private static final ThreadGroup THREADGROUP;
    private static final AccessControlContext ACC;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private volatile boolean hasRun;

    public InnocuousThread(Runnable runnable) {
        super(THREADGROUP, runnable, "anInnocuousThread");
        UNSAFE.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        this.eraseThreadLocals();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
    }

    @Override
    public void setContextClassLoader(ClassLoader classLoader) {
        throw new SecurityException("setContextClassLoader");
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this && !this.hasRun) {
            this.hasRun = true;
            super.run();
        }
    }

    public void eraseThreadLocals() {
        UNSAFE.putObject(this, THREADLOCALS, null);
        UNSAFE.putObject(this, INHERITABLETHREADLOCALS, null);
    }

    static {
        try {
            ThreadGroup threadGroup;
            ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            Class<ThreadGroup> clazz2 = ThreadGroup.class;
            THREADLOCALS = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocals"));
            INHERITABLETHREADLOCALS = UNSAFE.objectFieldOffset(clazz.getDeclaredField("inheritableThreadLocals"));
            INHERITEDACCESSCONTROLCONTEXT = UNSAFE.objectFieldOffset(clazz.getDeclaredField("inheritedAccessControlContext"));
            long l = UNSAFE.objectFieldOffset(clazz.getDeclaredField("group"));
            long l2 = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("parent"));
            ThreadGroup threadGroup2 = (ThreadGroup)UNSAFE.getObject(Thread.currentThread(), l);
            while (threadGroup2 != null && (threadGroup = (ThreadGroup)UNSAFE.getObject(threadGroup2, l2)) != null) {
                threadGroup2 = threadGroup;
            }
            THREADGROUP = new ThreadGroup(threadGroup2, "InnocuousThreadGroup");
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

