/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JToggleButton
extends AbstractButton
implements Accessible {
    private static final String uiClassID = "ToggleButtonUI";

    public JToggleButton() {
        this(null, null, false);
    }

    public JToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JToggleButton(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JToggleButton(String string) {
        this(string, null, false);
    }

    public JToggleButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public JToggleButton(Action action) {
        this();
        this.setAction(action);
    }

    public JToggleButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public JToggleButton(String string, Icon icon, boolean bl) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(bl);
        this.init(string, icon);
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    boolean shouldUpdateSelectedStateFromAction() {
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JToggleButton.this);
            JToggleButton.this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JToggleButton jToggleButton = (JToggleButton)itemEvent.getSource();
            if (JToggleButton.this.accessibleContext != null) {
                if (jToggleButton.isSelected()) {
                    JToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        @Override
        public boolean isSelected() {
            return (this.stateMask & 2) != 0;
        }

        @Override
        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }
    }
}

