/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;

public class JScrollPane
extends JComponent
implements ScrollPaneConstants,
Accessible {
    private Border viewportBorder;
    private static final String uiClassID = "ScrollPaneUI";
    protected int verticalScrollBarPolicy = 20;
    protected int horizontalScrollBarPolicy = 30;
    protected JViewport viewport;
    protected JScrollBar verticalScrollBar;
    protected JScrollBar horizontalScrollBar;
    protected JViewport rowHeader;
    protected JViewport columnHeader;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    private boolean wheelScrollState = true;

    public JScrollPane(Component component, int n, int n2) {
        this.setLayout(new ScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewport(this.createViewport());
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        if (component != null) {
            this.setViewportView(component);
        }
        this.setUIProperty("opaque", true);
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
    }

    public JScrollPane(Component component) {
        this(component, 20, 30);
    }

    public JScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public JScrollPane() {
        this(null, 20, 30);
    }

    @Override
    public ScrollPaneUI getUI() {
        return (ScrollPaneUI)this.ui;
    }

    public void setUI(ScrollPaneUI scrollPaneUI) {
        super.setUI(scrollPaneUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ScrollPaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof ScrollPaneLayout) {
            super.setLayout(layoutManager);
            ((ScrollPaneLayout)layoutManager).syncWithScrollPane(this);
        } else if (layoutManager == null) {
            super.setLayout(layoutManager);
        } else {
            String string = "layout of JScrollPane must be a ScrollPaneLayout";
            throw new ClassCastException(string);
        }
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    public int getVerticalScrollBarPolicy() {
        return this.verticalScrollBarPolicy;
    }

    public void setVerticalScrollBarPolicy(int n) {
        switch (n) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid verticalScrollBarPolicy");
            }
        }
        int n2 = this.verticalScrollBarPolicy;
        this.verticalScrollBarPolicy = n;
        this.firePropertyChange("verticalScrollBarPolicy", n2, n);
        this.revalidate();
        this.repaint();
    }

    public int getHorizontalScrollBarPolicy() {
        return this.horizontalScrollBarPolicy;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        switch (n) {
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid horizontalScrollBarPolicy");
            }
        }
        int n2 = this.horizontalScrollBarPolicy;
        this.horizontalScrollBarPolicy = n;
        this.firePropertyChange("horizontalScrollBarPolicy", n2, n);
        this.revalidate();
        this.repaint();
    }

    public Border getViewportBorder() {
        return this.viewportBorder;
    }

    public void setViewportBorder(Border border) {
        Border border2 = this.viewportBorder;
        this.viewportBorder = border;
        this.firePropertyChange("viewportBorder", border2, border);
    }

    public Rectangle getViewportBorderBounds() {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2;
        JViewport jViewport;
        Rectangle rectangle = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        boolean bl = SwingUtilities.isLeftToRight(this);
        JViewport jViewport2 = this.getColumnHeader();
        if (jViewport2 != null && jViewport2.isVisible()) {
            int n = jViewport2.getHeight();
            rectangle.y += n;
            rectangle.height -= n;
        }
        if ((jViewport = this.getRowHeader()) != null && jViewport.isVisible()) {
            int n = jViewport.getWidth();
            if (bl) {
                rectangle.x += n;
            }
            rectangle.width -= n;
        }
        if ((jScrollBar2 = this.getVerticalScrollBar()) != null && jScrollBar2.isVisible()) {
            int n = jScrollBar2.getWidth();
            if (!bl) {
                rectangle.x += n;
            }
            rectangle.width -= n;
        }
        if ((jScrollBar = this.getHorizontalScrollBar()) != null && jScrollBar.isVisible()) {
            rectangle.height -= jScrollBar.getHeight();
        }
        return rectangle;
    }

    public JScrollBar createHorizontalScrollBar() {
        return new ScrollBar(0);
    }

    @Transient
    public JScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public void setHorizontalScrollBar(JScrollBar jScrollBar) {
        JScrollBar jScrollBar2 = this.getHorizontalScrollBar();
        this.horizontalScrollBar = jScrollBar;
        if (jScrollBar != null) {
            this.add((Component)jScrollBar, "HORIZONTAL_SCROLLBAR");
        } else if (jScrollBar2 != null) {
            this.remove(jScrollBar2);
        }
        this.firePropertyChange("horizontalScrollBar", jScrollBar2, jScrollBar);
        this.revalidate();
        this.repaint();
    }

    public JScrollBar createVerticalScrollBar() {
        return new ScrollBar(1);
    }

    @Transient
    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public void setVerticalScrollBar(JScrollBar jScrollBar) {
        JScrollBar jScrollBar2 = this.getVerticalScrollBar();
        this.verticalScrollBar = jScrollBar;
        this.add((Component)jScrollBar, "VERTICAL_SCROLLBAR");
        this.firePropertyChange("verticalScrollBar", jScrollBar2, jScrollBar);
        this.revalidate();
        this.repaint();
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void setViewport(JViewport jViewport) {
        JViewport jViewport2 = this.getViewport();
        this.viewport = jViewport;
        if (jViewport != null) {
            this.add((Component)jViewport, "VIEWPORT");
        } else if (jViewport2 != null) {
            this.remove(jViewport2);
        }
        this.firePropertyChange("viewport", jViewport2, jViewport);
        if (this.accessibleContext != null) {
            ((AccessibleJScrollPane)this.accessibleContext).resetViewPort();
        }
        this.revalidate();
        this.repaint();
    }

    public void setViewportView(Component component) {
        if (this.getViewport() == null) {
            this.setViewport(this.createViewport());
        }
        this.getViewport().setView(component);
    }

    @Transient
    public JViewport getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(JViewport jViewport) {
        JViewport jViewport2 = this.getRowHeader();
        this.rowHeader = jViewport;
        if (jViewport != null) {
            this.add((Component)jViewport, "ROW_HEADER");
        } else if (jViewport2 != null) {
            this.remove(jViewport2);
        }
        this.firePropertyChange("rowHeader", jViewport2, jViewport);
        this.revalidate();
        this.repaint();
    }

    public void setRowHeaderView(Component component) {
        if (this.getRowHeader() == null) {
            this.setRowHeader(this.createViewport());
        }
        this.getRowHeader().setView(component);
    }

    @Transient
    public JViewport getColumnHeader() {
        return this.columnHeader;
    }

    public void setColumnHeader(JViewport jViewport) {
        JViewport jViewport2 = this.getColumnHeader();
        this.columnHeader = jViewport;
        if (jViewport != null) {
            this.add((Component)jViewport, "COLUMN_HEADER");
        } else if (jViewport2 != null) {
            this.remove(jViewport2);
        }
        this.firePropertyChange("columnHeader", jViewport2, jViewport);
        this.revalidate();
        this.repaint();
    }

    public void setColumnHeaderView(Component component) {
        if (this.getColumnHeader() == null) {
            this.setColumnHeader(this.createViewport());
        }
        this.getColumnHeader().setView(component);
    }

    public Component getCorner(String string) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (string.equals("LOWER_LEADING_CORNER")) {
            string = bl ? "LOWER_LEFT_CORNER" : "LOWER_RIGHT_CORNER";
        } else if (string.equals("LOWER_TRAILING_CORNER")) {
            string = bl ? "LOWER_RIGHT_CORNER" : "LOWER_LEFT_CORNER";
        } else if (string.equals("UPPER_LEADING_CORNER")) {
            string = bl ? "UPPER_LEFT_CORNER" : "UPPER_RIGHT_CORNER";
        } else if (string.equals("UPPER_TRAILING_CORNER")) {
            String string2 = string = bl ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        }
        if (string.equals("LOWER_LEFT_CORNER")) {
            return this.lowerLeft;
        }
        if (string.equals("LOWER_RIGHT_CORNER")) {
            return this.lowerRight;
        }
        if (string.equals("UPPER_LEFT_CORNER")) {
            return this.upperLeft;
        }
        if (string.equals("UPPER_RIGHT_CORNER")) {
            return this.upperRight;
        }
        return null;
    }

    public void setCorner(String string, Component component) {
        Component component2;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (string.equals("LOWER_LEADING_CORNER")) {
            string = bl ? "LOWER_LEFT_CORNER" : "LOWER_RIGHT_CORNER";
        } else if (string.equals("LOWER_TRAILING_CORNER")) {
            string = bl ? "LOWER_RIGHT_CORNER" : "LOWER_LEFT_CORNER";
        } else if (string.equals("UPPER_LEADING_CORNER")) {
            string = bl ? "UPPER_LEFT_CORNER" : "UPPER_RIGHT_CORNER";
        } else if (string.equals("UPPER_TRAILING_CORNER")) {
            String string2 = string = bl ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        }
        if (string.equals("LOWER_LEFT_CORNER")) {
            component2 = this.lowerLeft;
            this.lowerLeft = component;
        } else if (string.equals("LOWER_RIGHT_CORNER")) {
            component2 = this.lowerRight;
            this.lowerRight = component;
        } else if (string.equals("UPPER_LEFT_CORNER")) {
            component2 = this.upperLeft;
            this.upperLeft = component;
        } else if (string.equals("UPPER_RIGHT_CORNER")) {
            component2 = this.upperRight;
            this.upperRight = component;
        } else {
            throw new IllegalArgumentException("invalid corner key");
        }
        if (component2 != null) {
            this.remove(component2);
        }
        if (component != null) {
            this.add(component, string);
        }
        this.firePropertyChange(string, component2, component);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setComponentOrientation(componentOrientation);
        }
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setComponentOrientation(componentOrientation);
        }
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollState;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        boolean bl2 = this.wheelScrollState;
        this.wheelScrollState = bl;
        this.firePropertyChange("wheelScrollingEnabled", bl2, bl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string;
        String string2 = this.viewportBorder != null ? this.viewportBorder.toString() : "";
        String string3 = string = this.viewport != null ? this.viewport.toString() : "";
        String string4 = this.verticalScrollBarPolicy == 20 ? "VERTICAL_SCROLLBAR_AS_NEEDED" : (this.verticalScrollBarPolicy == 21 ? "VERTICAL_SCROLLBAR_NEVER" : (this.verticalScrollBarPolicy == 22 ? "VERTICAL_SCROLLBAR_ALWAYS" : ""));
        String string5 = this.horizontalScrollBarPolicy == 30 ? "HORIZONTAL_SCROLLBAR_AS_NEEDED" : (this.horizontalScrollBarPolicy == 31 ? "HORIZONTAL_SCROLLBAR_NEVER" : (this.horizontalScrollBarPolicy == 32 ? "HORIZONTAL_SCROLLBAR_ALWAYS" : ""));
        String string6 = this.horizontalScrollBar != null ? this.horizontalScrollBar.toString() : "";
        String string7 = this.verticalScrollBar != null ? this.verticalScrollBar.toString() : "";
        String string8 = this.columnHeader != null ? this.columnHeader.toString() : "";
        String string9 = this.rowHeader != null ? this.rowHeader.toString() : "";
        String string10 = this.lowerLeft != null ? this.lowerLeft.toString() : "";
        String string11 = this.lowerRight != null ? this.lowerRight.toString() : "";
        String string12 = this.upperLeft != null ? this.upperLeft.toString() : "";
        String string13 = this.upperRight != null ? this.upperRight.toString() : "";
        return super.paramString() + ",columnHeader=" + string8 + ",horizontalScrollBar=" + string6 + ",horizontalScrollBarPolicy=" + string5 + ",lowerLeft=" + string10 + ",lowerRight=" + string11 + ",rowHeader=" + string9 + ",upperLeft=" + string12 + ",upperRight=" + string13 + ",verticalScrollBar=" + string7 + ",verticalScrollBarPolicy=" + string4 + ",viewport=" + string + ",viewportBorder=" + string2;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJScrollPane
    extends JComponent.AccessibleJComponent
    implements ChangeListener,
    PropertyChangeListener {
        protected JViewport viewPort;

        public void resetViewPort() {
            if (this.viewPort != null) {
                this.viewPort.removeChangeListener(this);
                this.viewPort.removePropertyChangeListener(this);
            }
            this.viewPort = JScrollPane.this.getViewport();
            if (this.viewPort != null) {
                this.viewPort.addChangeListener(this);
                this.viewPort.addPropertyChangeListener(this);
            }
        }

        public AccessibleJScrollPane() {
            super(JScrollPane.this);
            this.viewPort = null;
            this.resetViewPort();
            JScrollBar jScrollBar = JScrollPane.this.getHorizontalScrollBar();
            if (jScrollBar != null) {
                this.setScrollBarRelations(jScrollBar);
            }
            if ((jScrollBar = JScrollPane.this.getVerticalScrollBar()) != null) {
                this.setScrollBarRelations(jScrollBar);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent == null) {
                throw new NullPointerException();
            }
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ((string == "horizontalScrollBar" || string == "verticalScrollBar") && propertyChangeEvent.getNewValue() instanceof JScrollBar) {
                this.setScrollBarRelations((JScrollBar)propertyChangeEvent.getNewValue());
            }
        }

        void setScrollBarRelations(JScrollBar jScrollBar) {
            AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, jScrollBar);
            AccessibleRelation accessibleRelation2 = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, JScrollPane.this);
            AccessibleContext accessibleContext = jScrollBar.getAccessibleContext();
            accessibleContext.getAccessibleRelationSet().add(accessibleRelation2);
            this.getAccessibleRelationSet().add(accessibleRelation);
        }
    }

    protected class ScrollBar
    extends JScrollBar
    implements UIResource {
        private boolean unitIncrementSet;
        private boolean blockIncrementSet;

        public ScrollBar(int n) {
            super(n);
            this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        }

        @Override
        public void setUnitIncrement(int n) {
            this.unitIncrementSet = true;
            this.putClientProperty("JScrollBar.fastWheelScrolling", null);
            super.setUnitIncrement(n);
        }

        @Override
        public int getUnitIncrement(int n) {
            JViewport jViewport = JScrollPane.this.getViewport();
            if (!this.unitIncrementSet && jViewport != null && jViewport.getView() instanceof Scrollable) {
                Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
                Rectangle rectangle = jViewport.getViewRect();
                return scrollable.getScrollableUnitIncrement(rectangle, this.getOrientation(), n);
            }
            return super.getUnitIncrement(n);
        }

        @Override
        public void setBlockIncrement(int n) {
            this.blockIncrementSet = true;
            this.putClientProperty("JScrollBar.fastWheelScrolling", null);
            super.setBlockIncrement(n);
        }

        @Override
        public int getBlockIncrement(int n) {
            JViewport jViewport = JScrollPane.this.getViewport();
            if (this.blockIncrementSet || jViewport == null) {
                return super.getBlockIncrement(n);
            }
            if (jViewport.getView() instanceof Scrollable) {
                Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
                Rectangle rectangle = jViewport.getViewRect();
                return scrollable.getScrollableBlockIncrement(rectangle, this.getOrientation(), n);
            }
            if (this.getOrientation() == 1) {
                return jViewport.getExtentSize().height;
            }
            return jViewport.getExtentSize().width;
        }
    }
}

