/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.LongBinaryOperator;
import sun.misc.Contended;
import sun.misc.Unsafe;

abstract class Striped64
extends Number {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell[] cells;
    volatile transient long base;
    volatile transient int cellsBusy;
    private static final Unsafe UNSAFE;
    private static final long BASE;
    private static final long CELLSBUSY;
    private static final long PROBE;

    Striped64() {
    }

    final boolean casBase(long l, long l2) {
        return UNSAFE.compareAndSwapLong(this, BASE, l, l2);
    }

    final boolean casCellsBusy() {
        return UNSAFE.compareAndSwapInt(this, CELLSBUSY, 0, 1);
    }

    static final int getProbe() {
        return UNSAFE.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        UNSAFE.putInt(Thread.currentThread(), PROBE, n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void longAccumulate(long l, LongBinaryOperator longBinaryOperator, boolean bl) {
        int n = Striped64.getProbe();
        if (n == 0) {
            ThreadLocalRandom.current();
            n = Striped64.getProbe();
            bl = true;
        }
        boolean bl2 = false;
        while (true) {
            long l2;
            int n2;
            Cell[] cellArray = this.cells;
            if (this.cells != null && (n2 = cellArray.length) > 0) {
                Cell[] cellArray2;
                Cell cell = cellArray[n2 - 1 & n];
                if (cell == null) {
                    if (this.cellsBusy == 0) {
                        cellArray2 = new Cell(l);
                        if (this.cellsBusy == 0 && this.casCellsBusy()) {
                            boolean bl3 = false;
                            try {
                                int n3;
                                int n4;
                                Cell[] cellArray3 = this.cells;
                                if (this.cells != null && (n4 = cellArray3.length) > 0 && cellArray3[n3 = n4 - 1 & n] == null) {
                                    cellArray3[n3] = cellArray2;
                                    bl3 = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!bl3) continue;
                            return;
                        }
                    }
                    bl2 = false;
                } else if (!bl) {
                    bl = true;
                } else {
                    l2 = cell.value;
                    if (cell.cas(l2, longBinaryOperator == null ? l2 + l : longBinaryOperator.applyAsLong(l2, l))) return;
                    if (n2 >= NCPU || this.cells != cellArray) {
                        bl2 = false;
                    } else if (!bl2) {
                        bl2 = true;
                    } else if (this.cellsBusy == 0 && this.casCellsBusy()) {
                        try {
                            if (this.cells == cellArray) {
                                cellArray2 = new Cell[n2 << 1];
                                for (int i = 0; i < n2; ++i) {
                                    cellArray2[i] = cellArray[i];
                                }
                                this.cells = cellArray2;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        bl2 = false;
                        continue;
                    }
                }
                n = Striped64.advanceProbe(n);
                continue;
            }
            if (this.cellsBusy == 0 && this.cells == cellArray && this.casCellsBusy()) {
                boolean bl4 = false;
                try {
                    if (this.cells == cellArray) {
                        Cell[] cellArray4 = new Cell[2];
                        cellArray4[n & 1] = new Cell(l);
                        this.cells = cellArray4;
                        bl4 = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!bl4) continue;
                return;
            }
            l2 = this.base;
            if (this.casBase(l2, longBinaryOperator == null ? l2 + l : longBinaryOperator.applyAsLong(l2, l))) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doubleAccumulate(double d, DoubleBinaryOperator doubleBinaryOperator, boolean bl) {
        int n = Striped64.getProbe();
        if (n == 0) {
            ThreadLocalRandom.current();
            n = Striped64.getProbe();
            bl = true;
        }
        boolean bl2 = false;
        while (true) {
            long l;
            int n2;
            Cell[] cellArray = this.cells;
            if (this.cells != null && (n2 = cellArray.length) > 0) {
                Cell[] cellArray2;
                Cell cell = cellArray[n2 - 1 & n];
                if (cell == null) {
                    if (this.cellsBusy == 0) {
                        cellArray2 = new Cell(Double.doubleToRawLongBits(d));
                        if (this.cellsBusy == 0 && this.casCellsBusy()) {
                            boolean bl3 = false;
                            try {
                                int n3;
                                int n4;
                                Cell[] cellArray3 = this.cells;
                                if (this.cells != null && (n4 = cellArray3.length) > 0 && cellArray3[n3 = n4 - 1 & n] == null) {
                                    cellArray3[n3] = cellArray2;
                                    bl3 = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!bl3) continue;
                            return;
                        }
                    }
                    bl2 = false;
                } else if (!bl) {
                    bl = true;
                } else {
                    l = cell.value;
                    if (cell.cas(l, doubleBinaryOperator == null ? Double.doubleToRawLongBits(Double.longBitsToDouble(l) + d) : Double.doubleToRawLongBits(doubleBinaryOperator.applyAsDouble(Double.longBitsToDouble(l), d)))) return;
                    if (n2 >= NCPU || this.cells != cellArray) {
                        bl2 = false;
                    } else if (!bl2) {
                        bl2 = true;
                    } else if (this.cellsBusy == 0 && this.casCellsBusy()) {
                        try {
                            if (this.cells == cellArray) {
                                cellArray2 = new Cell[n2 << 1];
                                for (int i = 0; i < n2; ++i) {
                                    cellArray2[i] = cellArray[i];
                                }
                                this.cells = cellArray2;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        bl2 = false;
                        continue;
                    }
                }
                n = Striped64.advanceProbe(n);
                continue;
            }
            if (this.cellsBusy == 0 && this.cells == cellArray && this.casCellsBusy()) {
                boolean bl4 = false;
                try {
                    if (this.cells == cellArray) {
                        Cell[] cellArray4 = new Cell[2];
                        cellArray4[n & 1] = new Cell(Double.doubleToRawLongBits(d));
                        this.cells = cellArray4;
                        bl4 = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!bl4) continue;
                return;
            }
            l = this.base;
            if (this.casBase(l, doubleBinaryOperator == null ? Double.doubleToRawLongBits(Double.longBitsToDouble(l) + d) : Double.doubleToRawLongBits(doubleBinaryOperator.applyAsDouble(Double.longBitsToDouble(l), d)))) return;
        }
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Striped64> clazz = Striped64.class;
            BASE = UNSAFE.objectFieldOffset(clazz.getDeclaredField("base"));
            CELLSBUSY = UNSAFE.objectFieldOffset(clazz.getDeclaredField("cellsBusy"));
            Class<Thread> clazz2 = Thread.class;
            PROBE = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("threadLocalRandomProbe"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Contended
    static final class Cell {
        volatile long value;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        Cell(long l) {
            this.value = l;
        }

        final boolean cas(long l, long l2) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, l, l2);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Cell> clazz = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("value"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

