/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.AbstractPlainSocketImpl;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class HttpConnectSocketImpl
extends PlainSocketImpl {
    private static final String httpURLClazzStr = "sun.net.www.protocol.http.HttpURLConnection";
    private static final String netClientClazzStr = "sun.net.NetworkClient";
    private static final String doTunnelingStr = "doTunneling";
    private static final Field httpField;
    private static final Field serverSocketField;
    private static final Method doTunneling;
    private final String server;
    private InetSocketAddress external_address;
    private HashMap<Integer, Object> optionsMap = new HashMap();

    HttpConnectSocketImpl(String string, int n) {
        this.server = string;
        this.port = n;
    }

    HttpConnectSocketImpl(Proxy proxy) {
        SocketAddress socketAddress = proxy.address();
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.server = inetSocketAddress.getHostString();
        this.port = inetSocketAddress.getPort();
    }

    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        String string = inetSocketAddress.isUnresolved() ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().getHostAddress();
        int n2 = inetSocketAddress.getPort();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n2);
        }
        String string2 = "http://" + string + ":" + n2;
        Socket socket = this.privilegedDoTunnel(string2, n);
        this.external_address = inetSocketAddress;
        this.close();
        AbstractPlainSocketImpl abstractPlainSocketImpl = (AbstractPlainSocketImpl)socket.impl;
        this.getSocket().impl = abstractPlainSocketImpl;
        Set<Map.Entry<Integer, Object>> set = this.optionsMap.entrySet();
        try {
            for (Map.Entry<Integer, Object> entry : set) {
                abstractPlainSocketImpl.setOption(entry.getKey().intValue(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setOption(int n, Object object) throws SocketException {
        super.setOption(n, object);
        if (this.external_address != null) {
            return;
        }
        this.optionsMap.put(n, object);
    }

    private Socket privilegedDoTunnel(final String string, final int n) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException {
                    return HttpConnectSocketImpl.this.doTunnel(string, n);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private Socket doTunnel(String string, int n) throws IOException {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.server, this.port));
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
        httpURLConnection.setConnectTimeout(n);
        httpURLConnection.setReadTimeout(this.timeout);
        httpURLConnection.connect();
        this.doTunneling(httpURLConnection);
        try {
            Object object = httpField.get(httpURLConnection);
            return (Socket)serverSocketField.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("Should not reach here", illegalAccessException);
        }
    }

    private void doTunneling(HttpURLConnection httpURLConnection) {
        try {
            doTunneling.invoke((Object)httpURLConnection, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError("Should not reach here", reflectiveOperationException);
        }
    }

    protected InetAddress getInetAddress() {
        if (this.external_address != null) {
            return this.external_address.getAddress();
        }
        return super.getInetAddress();
    }

    protected int getPort() {
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getPort();
    }

    protected int getLocalPort() {
        if (this.socket != null) {
            return super.getLocalPort();
        }
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getLocalPort();
    }

    static {
        try {
            Class<?> clazz = Class.forName(httpURLClazzStr, true, null);
            httpField = clazz.getDeclaredField("http");
            doTunneling = clazz.getDeclaredMethod(doTunnelingStr, new Class[0]);
            Class<?> clazz2 = Class.forName(netClientClazzStr, true, null);
            serverSocketField = clazz2.getDeclaredField("serverSocket");
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    httpField.setAccessible(true);
                    serverSocketField.setAccessible(true);
                    return null;
                }
            });
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError("Should not reach here", reflectiveOperationException);
        }
    }
}

