/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.MBeanServerAccessController;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MBeanServerFileAccessController
extends MBeanServerAccessController {
    static final String READONLY = "readonly";
    static final String READWRITE = "readwrite";
    static final String CREATE = "create";
    static final String UNREGISTER = "unregister";
    private Map<String, Access> accessMap;
    private Properties originalProps;
    private String accessFileName;

    public MBeanServerFileAccessController(String string) throws IOException {
        this.accessFileName = string;
        Properties properties = MBeanServerFileAccessController.propertiesFromFile(string);
        this.parseProperties(properties);
    }

    public MBeanServerFileAccessController(String string, MBeanServer mBeanServer) throws IOException {
        this(string);
        this.setMBeanServer(mBeanServer);
    }

    public MBeanServerFileAccessController(Properties properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.originalProps = properties;
        this.parseProperties(properties);
    }

    public MBeanServerFileAccessController(Properties properties, MBeanServer mBeanServer) throws IOException {
        this(properties);
        this.setMBeanServer(mBeanServer);
    }

    @Override
    public void checkRead() {
        this.checkAccess(AccessType.READ, null);
    }

    @Override
    public void checkWrite() {
        this.checkAccess(AccessType.WRITE, null);
    }

    @Override
    public void checkCreate(String string) {
        this.checkAccess(AccessType.CREATE, string);
    }

    @Override
    public void checkUnregister(ObjectName objectName) {
        this.checkAccess(AccessType.UNREGISTER, null);
    }

    public synchronized void refresh() throws IOException {
        Properties properties = this.accessFileName == null ? this.originalProps : MBeanServerFileAccessController.propertiesFromFile(this.accessFileName);
        this.parseProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties propertiesFromFile(String string) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private synchronized void checkAccess(AccessType accessType, String string) {
        final AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(accessControlContext);
            }
        });
        if (subject == null) {
            return;
        }
        Set<Principal> set = subject.getPrincipals();
        String string2 = null;
        for (Principal object : set) {
            boolean bl;
            Access access = this.accessMap.get(object.getName());
            if (access == null) continue;
            switch (accessType) {
                case READ: {
                    bl = true;
                    break;
                }
                case WRITE: {
                    bl = access.write;
                    break;
                }
                case UNREGISTER: {
                    bl = access.unregister;
                    if (bl || !access.write) break;
                    string2 = UNREGISTER;
                    break;
                }
                case CREATE: {
                    bl = MBeanServerFileAccessController.checkCreateAccess(access, string);
                    if (bl || !access.write) break;
                    string2 = "create " + string;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (!bl) continue;
            return;
        }
        SecurityException securityException = new SecurityException("Access denied! Invalid access level for requested MBeanServer operation.");
        if (string2 != null) {
            SecurityException securityException2 = new SecurityException("Access property for this identity should be similar to: readwrite " + string2);
            securityException.initCause(securityException2);
        }
        throw securityException;
    }

    private static boolean checkCreateAccess(Access access, String string) {
        for (String string2 : access.createPatterns) {
            if (!MBeanServerFileAccessController.classNameMatch(string2, string)) continue;
            return true;
        }
        return false;
    }

    private static boolean classNameMatch(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("*")) {
                stringBuilder.append("[^.]*");
                continue;
            }
            stringBuilder.append(Pattern.quote(string3));
        }
        return string2.matches(stringBuilder.toString());
    }

    private void parseProperties(Properties properties) {
        this.accessMap = new HashMap<String, Access>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            Access access = Parser.parseAccess(string, string2);
            this.accessMap.put(string, access);
        }
    }

    private static class Parser {
        private static final int EOS = -1;
        private final String identity;
        private final String s;
        private final int len;
        private int i;
        private int c;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Parser(String string, String string2) {
            this.identity = string;
            this.s = string2;
            this.len = string2.length();
            this.i = 0;
            this.c = this.i < this.len ? string2.codePointAt(this.i) : -1;
        }

        static Access parseAccess(String string, String string2) {
            return new Parser(string, string2).parseAccess();
        }

        private Access parseAccess() {
            Access access;
            this.skipSpace();
            String string = this.parseWord();
            if (string.equals(MBeanServerFileAccessController.READONLY)) {
                access = new Access(false, false, null);
            } else if (string.equals(MBeanServerFileAccessController.READWRITE)) {
                access = this.parseReadWrite();
            } else {
                throw this.syntax("Expected readonly or readwrite: " + string);
            }
            if (this.c != -1) {
                throw this.syntax("Extra text at end of line");
            }
            return access;
        }

        private Access parseReadWrite() {
            boolean bl;
            ArrayList<String> arrayList;
            block2: {
                String string;
                arrayList = new ArrayList<String>();
                bl = false;
                while (true) {
                    this.skipSpace();
                    if (this.c == -1) break block2;
                    string = this.parseWord();
                    if (string.equals(MBeanServerFileAccessController.UNREGISTER)) {
                        bl = true;
                        continue;
                    }
                    if (!string.equals(MBeanServerFileAccessController.CREATE)) break;
                    this.parseCreate(arrayList);
                }
                throw this.syntax("Unrecognized keyword " + string);
            }
            return new Access(true, bl, arrayList);
        }

        private void parseCreate(List<String> list) {
            while (true) {
                this.skipSpace();
                list.add(this.parseClassName());
                this.skipSpace();
                if (this.c != 44) break;
                this.next();
            }
        }

        private String parseClassName() {
            int n = this.i;
            boolean bl = false;
            while (true) {
                if (this.c == 46) {
                    if (!bl) {
                        throw this.syntax("Bad . in class name");
                    }
                    bl = false;
                } else {
                    if (this.c != 42 && !Character.isJavaIdentifierPart(this.c)) break;
                    bl = true;
                }
                this.next();
            }
            String string = this.s.substring(n, this.i);
            if (!bl) {
                throw this.syntax("Bad class name " + string);
            }
            return string;
        }

        private void next() {
            if (this.c != -1) {
                this.i += Character.charCount(this.c);
                this.c = this.i < this.len ? this.s.codePointAt(this.i) : -1;
            }
        }

        private void skipSpace() {
            while (Character.isWhitespace(this.c)) {
                this.next();
            }
        }

        private String parseWord() {
            this.skipSpace();
            if (this.c == -1) {
                throw this.syntax("Expected word at end of line");
            }
            int n = this.i;
            while (this.c != -1 && !Character.isWhitespace(this.c)) {
                this.next();
            }
            String string = this.s.substring(n, this.i);
            this.skipSpace();
            return string;
        }

        private IllegalArgumentException syntax(String string) {
            return new IllegalArgumentException(string + " [" + this.identity + " " + this.s + "]");
        }

        static {
            boolean bl = $assertionsDisabled = !MBeanServerFileAccessController.class.desiredAssertionStatus();
            if (!$assertionsDisabled && Character.isWhitespace(-1)) {
                throw new AssertionError();
            }
        }
    }

    private static class Access {
        final boolean write;
        final String[] createPatterns;
        private boolean unregister;
        private final String[] NO_STRINGS = new String[0];

        Access(boolean bl, boolean bl2, List<String> list) {
            this.write = bl;
            int n = list == null ? 0 : list.size();
            this.createPatterns = n == 0 ? this.NO_STRINGS : list.toArray(new String[n]);
            this.unregister = bl2;
        }
    }

    private static enum AccessType {
        READ,
        WRITE,
        CREATE,
        UNREGISTER;

    }
}

