/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class ExtendedKeyUsage
implements DEREncodable {
    Hashtable usageTable;
    DERConstructedSequence seq;

    public ExtendedKeyUsage(DERConstructedSequence dERConstructedSequence) {
        this.seq = dERConstructedSequence;
        Enumeration enumeration = dERConstructedSequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.usageTable.put(e, e);
        }
    }

    public ExtendedKeyUsage(Vector vector) {
        this.seq = new DERConstructedSequence();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            this.seq.addObject(dERObject);
            this.usageTable.put(dERObject, dERObject);
        }
    }

    public boolean hasKeyPurposeId(KeyPurposeId keyPurposeId) {
        return this.usageTable.get(keyPurposeId) != null;
    }

    public DERObject getDERObject() {
        return this.seq;
    }
}

