/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyWrapAlgorithm
implements DEREncodable {
    private AlgorithmIdentifier alg;

    public KeyWrapAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public KeyWrapAlgorithm(BERConstructedSequence bERConstructedSequence) {
        this.alg = new AlgorithmIdentifier(bERConstructedSequence);
    }

    public KeyWrapAlgorithm(KeyWrapAlgorithm keyWrapAlgorithm) {
        this.alg = keyWrapAlgorithm.alg;
    }

    public KeyWrapAlgorithm(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public KeyWrapAlgorithm(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static KeyWrapAlgorithm getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyWrapAlgorithm) {
            return (KeyWrapAlgorithm)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyWrapAlgorithm((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new KeyWrapAlgorithm((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyWrapAlgorithm.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyWrapAlgorithm");
    }

    public static KeyWrapAlgorithm newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyWrapAlgorithm) {
            return new KeyWrapAlgorithm((KeyWrapAlgorithm)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyWrapAlgorithm((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new KeyWrapAlgorithm((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyWrapAlgorithm.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyWrapAlgorithm");
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }
}

