/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CertificateList;

public class CertificateRevocationLists
implements DEREncodable {
    private DERConstructedSet crls;

    public CertificateRevocationLists(Vector vector) {
        this.setCrls(vector);
    }

    public CertificateRevocationLists(DERConstructedSet dERConstructedSet) {
        this.crls = dERConstructedSet;
    }

    public CertificateRevocationLists(CertificateRevocationLists certificateRevocationLists) {
        this.crls = certificateRevocationLists.crls;
    }

    public static CertificateRevocationLists getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CertificateRevocationLists) {
            return (CertificateRevocationLists)object;
        }
        if (object instanceof DERConstructedSet) {
            return new CertificateRevocationLists((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return CertificateRevocationLists.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CertificateRevocationLists");
    }

    public static CertificateRevocationLists newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CertificateRevocationLists) {
            return new CertificateRevocationLists((CertificateRevocationLists)object);
        }
        if (object instanceof DERConstructedSet) {
            return new CertificateRevocationLists((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return CertificateRevocationLists.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CertificateRevocationLists");
    }

    public Vector getCrls() {
        int n = this.crls.getSize();
        Vector<DEREncodable> vector = new Vector<DEREncodable>();
        int n2 = 0;
        while (n2 < n) {
            DEREncodable dEREncodable = this.crls.getObjectAt(n2);
            if (dEREncodable instanceof CertificateList) {
                vector.addElement(dEREncodable);
            } else {
                vector.addElement(new CertificateList((BERConstructedSequence)dEREncodable));
            }
            ++n2;
        }
        return vector;
    }

    private void setCrls(Vector vector) {
        int n = vector.size();
        this.crls = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e instanceof CertificateList) {
                this.crls.addObject((CertificateList)e);
            } else {
                this.crls.addObject(new CertificateList((BERConstructedSequence)e));
            }
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.crls;
    }
}

