/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.alarm;

import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.backup.NewBackUpJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.sync.SyncJob;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.helper.windows.VolumeShadowService;
import com.parablu.epa.service.backup.WindowsBackupJob;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.sync.WindowsSyncJob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlusyncThreadHelper {
    private static NewBackUpJob backUpJob = null;
    private static SyncJob syncJob = null;
    private static Logger logger = LoggerFactory.getLogger(BlusyncThreadHelper.class);
    private static Timer syncTimer = null;
    private static Timer backUpTimer = null;
    private static long timeInMillisecondsConvertionFactorFromMinutes = 60000L;
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static Map<Date, ScheduleTO> scheduledBackupTypeMap = new HashMap<Date, ScheduleTO>();
    private static boolean firstTimeBackup = false;
    private static final String ILLEGAL_THREAD_STATE_EXCEPTION = "IllegalThreadStateException";

    private BlusyncThreadHelper() {
    }

    public static synchronized void startBackUp(boolean isManual) {
        if (backUpJob != null && backUpJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("backup job is not null and is alive");
            return;
        }
        if (!SettingHelper.isEnableAutomaticBackUp() && !isManual) {
            logger.debug("isEnableAutomaticBackUp: " + SettingHelper.isEnableAutomaticBackUp());
            return;
        }
        if (NotificationHelper.isRestoreStarted()) {
            logger.debug("Restore is happening so stop backup");
            return;
        }
        backUpJob = new WindowsBackupJob(isManual);
        backUpJob.setDaemon(true);
        backUpJob.start();
        logger.debug("The boolean manual is:" + isManual);
        Runnable runnable = () -> {
            try {
                backUpJob.join();
                if (BlusyncThreadHelper.backUpJob.jobSucceded) {
                    return;
                }
                BlusyncThreadHelper.inspectError((BaseJob)backUpJob);
            }
            catch (IllegalThreadStateException e) {
                logger.trace("" + e);
                logger.error(ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
                logger.debug(ILLEGAL_THREAD_STATE_EXCEPTION, e);
            }
            catch (InterruptedException e) {
                logger.trace("" + e);
                logger.error("Interrupted exception", (Object)e.getMessage());
                logger.debug("InterruptedException", e);
            }
        };
        new Thread(runnable).start();
    }

    public static synchronized void initiateSyncTimer() {
        syncTimer = new Timer();
        syncTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BlusyncThreadHelper.startSync(false);
            }
        }, 5000L, (long)SettingHelper.getCheckParacloudForUpdateTimerInMins() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static synchronized void initiateBackUpTimer() {
        backUpTimer = new Timer();
        if (SettingHelper.getIsEnableBackupPolicy() == null) {
            logger.debug("Inside group policy null.");
            BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            String isEnableBackupPolicy = backupAdapter.isBackupPolicyEnabled(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getUserName(), SettingHelper.getDeviceUUId());
            if (isEnableBackupPolicy != null) {
                SettingHelper.setIsEnableBackupPolicy((String)isEnableBackupPolicy);
                SettingHelper.applyChangesToSharedPreferences((boolean)true);
            }
        }
        logger.info("IsBackupPolicy enabled:" + SettingHelper.getIsEnableBackupPolicy());
        if (SettingHelper.getLdapEnabled().equals("true")) {
            if (SettingHelper.getIsEnableBackupPolicy().equalsIgnoreCase("true")) {
                logger.debug("Backup timer initiatebackup STARTED");
                Runnable runnable = () -> BlusyncThreadHelper.initiateBackup();
                new Thread(runnable).start();
                logger.debug("Backup timer COMPLETED");
            }
        } else {
            logger.info("Backup Policy not enabled");
            backUpTimer = new Timer();
            backUpTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                        BlusyncThreadHelper.startServerBackup(false);
                    } else {
                        BlusyncThreadHelper.startBackUp(false);
                    }
                }
            }, 8000L, (long)SettingHelper.getBackUpIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
        }
    }

    public static void initiateBackup() {
        block2: while (true) {
            try {
                while (true) {
                    long nextScheduledMinute = BlusyncThreadHelper.getNextScheduledMinute();
                    long nextBackupTimeStamp = nextScheduledMinute * timeInMillisecondsConvertionFactorFromMinutes;
                    SettingHelper.setNextBackupTimeStamp((long)nextBackupTimeStamp);
                    NotificationHelper.setChangeNextBackuplabel((boolean)true);
                    logger.debug("NEXT SCHEDULE TIME IN MINUTES:" + nextScheduledMinute);
                    if (nextScheduledMinute == 0L) break block2;
                    Thread.sleep(nextScheduledMinute * timeInMillisecondsConvertionFactorFromMinutes);
                    logger.debug("After thread sleep GOING TO START BACKUP:" + nextBackupTimeStamp);
                    if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                        BlusyncThreadHelper.startServerBackup(false);
                        continue;
                    }
                    BlusyncThreadHelper.startBackUp(false);
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception" + e.getMessage());
                continue;
            }
            break;
        }
    }

    public static synchronized void initiateSyncTimerAfterDelay() {
        syncTimer = new Timer();
        syncTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BlusyncThreadHelper.startSync(false);
            }
        }, (long)SettingHelper.getCheckParacloudForUpdateTimerInMins() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getCheckParacloudForUpdateTimerInMins() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static void waitForBackupJob() {
        if (backUpJob != null) {
            while (backUpJob.isAlive()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error("InterruptedException while thread sleep" + e);
                }
            }
        }
    }

    public static synchronized void initiateBackUpTimerAfterDelay() {
        backUpTimer = new Timer();
        backUpTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                    BlusyncThreadHelper.startServerBackup(false);
                } else {
                    BlusyncThreadHelper.startBackUp(false);
                }
            }
        }, (long)SettingHelper.getBackUpIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getBackUpIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static synchronized void resetSyncTimer() {
        if (syncTimer != null) {
            syncTimer.cancel();
        }
        BlusyncThreadHelper.initiateSyncTimerAfterDelay();
    }

    public static synchronized void resetBackupTimer() {
        if (backUpTimer != null) {
            backUpTimer.cancel();
        }
        BlusyncThreadHelper.initiateBackUpTimerAfterDelay();
    }

    public static void cancelSyncTimer() {
        syncTimer.cancel();
    }

    public static void cancelBackupTimer() {
        backUpTimer.cancel();
    }

    public static void cancelCurrentSyncProcess() {
        if (syncJob != null && syncJob.isAlive()) {
            BlusyncThreadHelper.syncJob.shouldKillCrawl = true;
            syncJob.interrupt();
        }
    }

    public static void cancelCurrentBackupProcess() {
        if (backUpJob != null && backUpJob.isAlive()) {
            logger.debug("Current Backup Process Cancelled");
            boolean isWakeUp = false;
            backUpJob.pauseBackup(isWakeUp);
        }
    }

    public static synchronized void startSync(boolean manual) {
        if (syncJob != null && syncJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("syncJob: " + syncJob);
            logger.debug("SettingHelper.isLicenseActive(): " + SettingHelper.isLicenseActive());
            logger.debug("SettingHelper.isDeviceBlocked(): " + SettingHelper.isDeviceBlocked());
            logger.debug("sync job is not null and is alive or licenseExpired/deviceBlocked");
            return;
        }
        if (!SettingHelper.isEnableBlusync() && !manual) {
            logger.debug("Sync Enabled: " + SettingHelper.isEnableBlusync());
            return;
        }
        syncJob = new WindowsSyncJob();
        syncJob.setDaemon(true);
        syncJob.start();
        Runnable runnable = () -> {
            try {
                syncJob.join();
                if (BlusyncThreadHelper.syncJob.jobSucceded) {
                    return;
                }
                BlusyncThreadHelper.inspectError((BaseJob)syncJob);
            }
            catch (IllegalThreadStateException e) {
                logger.trace(ILLEGAL_THREAD_STATE_EXCEPTION + e);
                logger.debug(ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                logger.trace("" + e);
                logger.debug("InterruptedException", (Object)e.getMessage());
            }
        };
        new Thread(runnable).start();
    }

    protected static synchronized void inspectError(BaseJob baseJob) {
        if (baseJob.licenseExpired) {
            BlusyncThreadHelper.deactivateAccount();
            NotificationHelper.setCurrentStatus((int)13, (int)100);
            return;
        }
        if (baseJob.deviceBlocked) {
            NotificationHelper.setCurrentStatus((int)11, (int)100);
            BlusyncThreadHelper.blockDevice();
            return;
        }
        if (baseJob.sessionExpired) {
            NotificationHelper.setCurrentStatus((int)14, (int)100);
            BlusyncThreadHelper.disconnectFromParacloud(14);
            return;
        }
    }

    private static void deactivateAccount() {
        UIHelper.deactivateAccount();
    }

    private static void disconnectFromParacloud(int statusBlusyncSessionexpired) {
        UIHelper.disconnectFromParacloud(statusBlusyncSessionexpired);
    }

    private static void blockDevice() {
        UIHelper.blockDevice();
    }

    private static synchronized long getNextScheduledMinute() {
        List list = backupPolicyDAOImpl.getSchedules();
        if (list == null || list.isEmpty()) {
            logger.debug("Schedule List is null or empty ");
            return 0L;
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        BlusyncThreadHelper.getAppropriateDatesForSchedules(list, dates, 0);
        Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
        TreeSet<Date> datesToCheckPreviousSchedule = new TreeSet<Date>();
        BlusyncThreadHelper.getAppropriateDatesForSchedules(list, datesToCheckPreviousSchedule, 1);
        Date previousSchedule = datesToCheckPreviousSchedule.lower(Calendar.getInstance().getTime());
        if (previousSchedule == null) {
            previousSchedule = Collections.max(datesToCheckPreviousSchedule);
        }
        logger.debug("Previous schedule time " + previousSchedule);
        boolean isPreviousBackupOccured = BlusyncThreadHelper.comparePreviousBackupWithSchedule(previousSchedule);
        if (!isPreviousBackupOccured) {
            logger.debug("Previous schedule didnt happen so return one");
            if (SettingHelper.getServerBackupLicensed().equals("true")) {
                NotificationHelper.setServerBackupType((String)"F");
                NotificationHelper.setScheduledContainerNames((String)scheduledBackupTypeMap.get(previousSchedule).getContainerName());
                logger.debug("map ret : " + NotificationHelper.getServerBackupType());
            }
            long nextScheduleMinute = 1L;
            return nextScheduleMinute;
        }
        Date nextScheduleDate = highestDateUpUntilNow == null ? Collections.min(dates) : highestDateUpUntilNow;
        if (SettingHelper.getServerBackupLicensed().equals("true")) {
            NotificationHelper.setScheduledContainerNames((String)scheduledBackupTypeMap.get(nextScheduleDate).getContainerName());
        }
        if (!firstTimeBackup) {
            logger.debug("Backup type set from map : " + scheduledBackupTypeMap.get(nextScheduleDate).getBackupType());
            NotificationHelper.setServerBackupType((String)scheduledBackupTypeMap.get(nextScheduleDate).getBackupType());
        }
        Calendar currentTime = Calendar.getInstance();
        currentTime.set(13, 0);
        long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
        long nextScheduleMinute = timeDiff <= 0L ? 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff)) : TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        if (nextScheduleMinute == 0L) {
            logger.debug("Next schedue minute is zero");
            nextScheduleMinute = BlusyncThreadHelper.getNextScheduledMinute();
        }
        return nextScheduleMinute;
    }

    private static void getAppropriateDatesForSchedules(List<ScheduleTO> list, NavigableSet<Date> dates, int checkPrevSchedule) {
        for (ScheduleTO scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getStartTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                int[] daysArray = BlusyncThreadHelper.toIntArray(scheduleTO.getDayArray());
                for (int i = 0; i < daysArray.length; ++i) {
                    Calendar calendar1 = Calendar.getInstance();
                    if (daysArray[i] > dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, daysArray[i] - dayOfWeek);
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            dates.add(calendar1.getTime());
                            scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, daysArray[i] - dayOfWeek - 7);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        dates.add(calendar1.getTime());
                        scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                        continue;
                    }
                    if (daysArray[i] < dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, 7 - (dayOfWeek - daysArray[i]));
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            dates.add(calendar1.getTime());
                            scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, daysArray[i] - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        dates.add(calendar1.getTime());
                        scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                        continue;
                    }
                    if (daysArray[i] != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    dates.add(calendar1.getTime());
                    scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                }
            }
            catch (ParseException e) {
                logger.trace("" + e);
                logger.error("Exception getting schedules " + e.getMessage());
            }
        }
    }

    private static boolean comparePreviousBackupWithSchedule(Date previousSchedule) {
        firstTimeBackup = false;
        if (previousSchedule == null) {
            logger.debug("Previous Schedule is null");
            NotificationHelper.setServerBackupType((String)"F");
            firstTimeBackup = true;
            return true;
        }
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO == null) {
            NotificationHelper.setServerBackupType((String)"F");
            firstTimeBackup = true;
            return true;
        }
        String timeStamp = backupActivityTO.getBackupActivityTimeStamp();
        long backupTimeStamp = 0L;
        if (timeStamp != null) {
            backupTimeStamp = Long.valueOf(timeStamp);
        }
        if (backupTimeStamp != 0L) {
            Date date = new Date(backupTimeStamp);
            logger.debug(" Current date:" + date + "  Previoud Schedule:" + previousSchedule);
            long previousScheduleTimestamp = previousSchedule.getTime();
            if (previousScheduleTimestamp < backupTimeStamp) {
                logger.debug("Previous Schedule backup occured successfully");
                return true;
            }
            if (backupTimeStamp + 60000L > System.currentTimeMillis()) {
                logger.debug("previous time>>>>>" + (backupTimeStamp + 60000L));
                logger.debug("current time>>>>>" + System.currentTimeMillis());
                logger.debug("Previous Schedule backup occured one minute ago successfully");
                return true;
            }
        }
        return false;
    }

    public static int[] toIntArray(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    public static void startServerBackup(final boolean isManual) {
        if (backUpJob != null && backUpJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("backup job is not null and is alive");
            return;
        }
        if (!SettingHelper.isEnableAutomaticBackUp() && !isManual) {
            logger.debug("isEnableAutomaticBackUp: " + SettingHelper.isEnableAutomaticBackUp());
            return;
        }
        if (NotificationHelper.isRestoreStarted()) {
            logger.debug("Restore is happening so stop backup");
            return;
        }
        logger.debug("Schedule returned container " + NotificationHelper.getScheduledContainerNames());
        final String[] containeNames = NotificationHelper.getScheduledContainerNames().split("\\|");
        new Thread(){

            @Override
            public void run() {
                for (String containerName : containeNames) {
                    logger.debug("cont Name : " + containerName);
                    NotificationHelper.setCurrentContainerName((String)containerName);
                    NotificationHelper.setCurrentPolicyName((String)VolumeShadowService.getPolicyForContainer(containerName));
                    logger.debug("Policy name : " + NotificationHelper.getCurrentPolicyName());
                    backUpJob = new WindowsBackupJob(isManual);
                    backUpJob.setDaemon(true);
                    backUpJob.start();
                    logger.debug("The boolean manual is:" + isManual);
                    try {
                        backUpJob.join();
                        if (backUpJob.jobSucceded) continue;
                        BlusyncThreadHelper.inspectError((BaseJob)backUpJob);
                    }
                    catch (IllegalThreadStateException e) {
                        logger.trace(BlusyncThreadHelper.ILLEGAL_THREAD_STATE_EXCEPTION + e);
                        logger.debug(BlusyncThreadHelper.ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
                    }
                    catch (InterruptedException e) {
                        logger.trace("" + e);
                        logger.debug(BlusyncThreadHelper.ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
                    }
                }
            }
        }.start();
    }
}

