/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.sp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.bp.service.InclusionFilterService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.PolicyResponse;
import com.parablu.paracloud.element.SyncPolicyElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.User;
import com.parablu.sp.service.SyncPolicyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SyncPolicyController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(SyncPolicyController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private SyncPolicyService syncPolicyService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private InclusionFilterService inclusionFilterService;
    @Autowired
    private UserManagementService managementService;
    private static final String ERROR_FAILED_TO_LOAD_BACKUPPOLICY = "Error failed to load BackupPolicy ...";

    @RequestMapping(value={"cloud/{cloudName}/syncPolicy/save"}, method={RequestMethod.POST})
    void saveSyncPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody SyncPolicyElement syncPolicyElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("sync policy name" + syncPolicyElement.getPolicygroupName());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug(syncPolicyElement.getSearchFilterType() + "*****search filtername*******" + syncPolicyElement.getSearchFilterInclusionName());
            logger.debug("cloudId..........." + cloudId);
            logger.debug("cloudname........" + cloudName);
            logger.debug("syncPolicyElement...maxfilesize....." + syncPolicyElement.getMaxFileSize());
            logger.debug("syncPolicyElement...cloud credentials ....." + syncPolicyElement.getCloudCredential());
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            logger.debug("PRIVACY GATE WAY......" + syncPolicyElement.getPrivacyGatewayMappingElement());
            SyncPolicyElement syncPolicyElemnt = this.syncPolicyService.getSyncPolicy(cloudId, cloudName, syncPolicyElement.getPolicygroupName());
            if (syncPolicyElemnt != null && syncPolicyElemnt.isBlocked()) {
                logger.debug("Sync policy blocked----" + syncPolicyElemnt.isBlocked());
                response.setStatus(331);
                return;
            }
            this.syncPolicyService.saveSyncPolicy(cloudId, cloudName, syncPolicyElement, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling cloud/{cloudName}/syncPolicy/save ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/syncPolicy/save"}, method={RequestMethod.PUT})
    void createSyncPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody SyncPolicyElement syncPolicyElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("sync policy name" + syncPolicyElement.getPolicygroupName());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug(syncPolicyElement.getSearchFilterType() + "*****search filtername*******" + syncPolicyElement.getSearchFilterInclusionName());
            logger.debug("cloudId..........." + cloudId);
            logger.debug("cloudname........" + cloudName);
            logger.debug("syncPolicyElement...maxfilesize....." + syncPolicyElement.getMaxFileSize());
            logger.debug("syncPolicyElement...cloud credentials ....." + syncPolicyElement.getCloudCredential());
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            logger.debug("PRIVACY GATE WAY......" + syncPolicyElement.getPrivacyGatewayMappingElement());
            SyncPolicyElement syncPolicyElemnt = this.syncPolicyService.getSyncPolicy(cloudId, cloudName, syncPolicyElement.getPolicygroupName());
            if (syncPolicyElemnt != null) {
                if (syncPolicyElemnt.isBlocked()) {
                    logger.debug("Backup policy Already exists---- and ist blocked....");
                    response.setStatus(331);
                    return;
                }
                logger.debug("Sync policy Already exists----");
                response.setStatus(406);
                return;
            }
            this.syncPolicyService.saveSyncPolicy(cloudId, cloudName, syncPolicyElement, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/syncPolicy/load/{policyName}/"}, method={RequestMethod.GET})
    public ModelAndView getSyncPolicy(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="policyName") String policyName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load syncPolicy ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            SyncPolicyElement syncPolicyElement = this.syncPolicyService.getSyncPolicy(cloudId, cloudName, policyName);
            if (syncPolicyElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)syncPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading BackupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/syncPolicy/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllSyncPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            logger.debug("start of cloud/{cloudName}/syncPolicy/load/all ..." + request.getHeader("userEditProfile"));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String loadOnlyBasic = request.getHeader("loadOnlyBasic");
            User currentUser = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            List<Object> syncPolicyElements = this.syncPolicyService.getAllSyncPolicies(cloudId, cloudName);
            List<Object> responseSyncPolicyElements = new ArrayList();
            if (syncPolicyElements.isEmpty()) {
                syncPolicyElements = new ArrayList<SyncPolicyElement>();
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            if (currentUser != null && currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getSyncPoliciesAdmin())) {
                logger.debug("....readonly admin..." + currentUser.getSyncPoliciesAdmin());
                syncPolicyElements = syncPolicyElements.stream().filter(policy -> Objects.nonNull(policy.getPolicygroupName()) && currentUser.getSyncPoliciesAdmin().contains(policy.getPolicygroupName())).collect(Collectors.toList());
            }
            if (!StringUtils.isEmpty((String)loadOnlyBasic) && loadOnlyBasic.equalsIgnoreCase("true")) {
                for (SyncPolicyElement syncPolicyElement : syncPolicyElements) {
                    SyncPolicyElement tempSyncPolicyElement = new SyncPolicyElement();
                    tempSyncPolicyElement.setPolicygroupName(syncPolicyElement.getPolicygroupName());
                    tempSyncPolicyElement.setMaxVersions(syncPolicyElement.getMaxVersions());
                    tempSyncPolicyElement.setUserSizeAllowed(syncPolicyElement.getUserSizeAllowed());
                    tempSyncPolicyElement.setFilterInclusionName(syncPolicyElement.getFilterInclusionName());
                    tempSyncPolicyElement.setMappedUserCount(Long.toString(this.managementService.getSyncPolicyMappedUserCountbyPolicyName(cloudId, syncPolicyElement.getPolicygroupName())));
                    responseSyncPolicyElements.add(tempSyncPolicyElement);
                }
            } else {
                responseSyncPolicyElements = syncPolicyElements;
            }
            modelAndView.addObject(responseSyncPolicyElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all backupPolicy  ..." + (Object)((Object)e));
            logger.error("Error failed to load all backupPolicy  ..." + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/check/syncPolicy/version"}, method={RequestMethod.GET})
    public void checkGpVersion(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load SyncPolicy for device ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader("userName");
            String lastModifiedTime = request.getHeader("lastModifiedTime");
            String deviceUUID = request.getHeader("deviceUUID");
            String productVersion = request.getHeader("productVersion");
            long lastModifiedTimeVal = 0L;
            if (!StringUtils.isEmpty((String)lastModifiedTime)) {
                lastModifiedTimeVal = Long.parseLong(lastModifiedTime);
            }
            Boolean isLatestVersion = this.syncPolicyService.isPolicyModified(cloudId, cloudName, userName, lastModifiedTimeVal);
            try {
                if (!StringUtils.isEmpty((String)productVersion) && !StringUtils.isEmpty((String)deviceUUID)) {
                    DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                    if (deviceElement != null) {
                        String clientVersion = deviceElement.getClientVersion();
                        logger.debug("Device element product version..........." + clientVersion);
                        if (clientVersion != null) {
                            if (!clientVersion.contentEquals(productVersion)) {
                                this.deviceManagementService.updateClientVersion(cloudId, productVersion, deviceUUID, productVersion);
                            }
                        } else {
                            this.deviceManagementService.updateClientVersion(cloudId, productVersion, deviceUUID, productVersion);
                        }
                    } else {
                        logger.error("device element is nulll...........");
                    }
                } else {
                    logger.debug("product version or uuid is empty.....");
                }
            }
            catch (Exception e) {
                logger.trace("check version and update is Failed..." + e);
                logger.error("check version and update is Failed..." + e.getMessage());
            }
            response.setStatus(200);
            response.setHeader("isLatestVersion", isLatestVersion.toString());
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load SyncPolicy ..." + (Object)((Object)e));
            logger.error("Error failed to load SyncPolicy ..." + e.getMessage());
        }
        logger.debug("end of loading syncPolicy deviceuuid ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/syncPolicy/load/userName"}, method={RequestMethod.GET})
    public ModelAndView getSyncPolicyForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load syncPolicy ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            SyncPolicyElement syncPolicyElement;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            UserElement userByUserNameOrEmail = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), userName);
            if (!StringUtils.isEmpty((String)userByUserNameOrEmail.getSyncPolicyName())) {
                syncPolicyElement = this.syncPolicyService.getSyncPolicy(cloudId, cloudName, userByUserNameOrEmail.getSyncPolicyName());
                if (syncPolicyElement == null) {
                    response.setStatus(400);
                    return null;
                }
            } else {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)syncPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading SyncPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/syncPolicy/loadAllPolicyNames/"}, method={RequestMethod.GET})
    public ModelAndView getAllSyncPolicyNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = authorizationTokens.getUser();
            boolean validAdmin = false;
            if (currentUser != null && currentUser.isReadOnlyAdmin() || currentUser.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> syncPolicyElements = new ArrayList();
            syncPolicyElements = currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getSyncPoliciesAdmin()) ? currentUser.getSyncPoliciesAdmin() : this.syncPolicyService.getAllSyncPoliciyNames(cloudId, cloudName);
            if (syncPolicyElements.isEmpty()) {
                syncPolicyElements = new ArrayList();
            }
            modelAndView.addObject(syncPolicyElements);
            logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + syncPolicyElements.size());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all backupPolicy  ..." + (Object)((Object)e));
            logger.error("Error failed to load all backupPolicy  ..." + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/syncPolicy/loadAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllSyncPolicyWithPagination(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/syncPolicy/loadAll ...");
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            int pageNumber = 0;
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            PolicyResponse elementResponse = new PolicyResponse();
            Map paramSet = request.getParameterMap();
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    policyNames.addAll(user.getSyncPoliciesAdmin());
                }
            }
            List<Object> syncPolicyElements = new ArrayList();
            syncPolicyElements = user.isReadOnlyAdmin() ? this.syncPolicyService.getAllSyncPoliciesWithPagination(cloudId, policyNames, skipValue) : this.syncPolicyService.getAllSyncPoliciesWithPagination(cloudId, skipValue);
            long totalRecordsCount = this.syncPolicyService.getSyncPoliciesCount(cloudId, policyNames);
            ArrayList<SyncPolicyElement> responseSyncPolicyElements = new ArrayList<SyncPolicyElement>();
            if (syncPolicyElements.isEmpty()) {
                syncPolicyElements = new ArrayList();
            }
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("....readonly admin..." + user.getSyncPoliciesAdmin());
                syncPolicyElements = !CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin()) ? syncPolicyElements.stream().filter(policy -> Objects.nonNull(policy.getPolicygroupName()) && user.getSyncPoliciesAdmin().contains(policy.getPolicygroupName())).collect(Collectors.toList()) : new ArrayList();
            }
            for (SyncPolicyElement syncPolicyElement : syncPolicyElements) {
                SyncPolicyElement tempSyncPolicyElement = new SyncPolicyElement();
                tempSyncPolicyElement.setPolicygroupName(syncPolicyElement.getPolicygroupName());
                tempSyncPolicyElement.setMaxVersions(syncPolicyElement.getMaxVersions());
                tempSyncPolicyElement.setUserSizeAllowed(syncPolicyElement.getUserSizeAllowed());
                tempSyncPolicyElement.setFilterInclusionName(syncPolicyElement.getFilterInclusionName());
                tempSyncPolicyElement.setMappedUserCount(Long.toString(this.managementService.getSyncPolicyMappedUserCountbyPolicyName(cloudId, syncPolicyElement.getPolicygroupName())));
                responseSyncPolicyElements.add(tempSyncPolicyElement);
            }
            elementResponse.setSyncPolicyElements(responseSyncPolicyElements);
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), elementResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all syncPolicy  ..." + (Object)((Object)e));
            logger.error("Error failed to load all syncPolicy  ..." + e.getMessage());
            return null;
        }
    }
}

