/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.bp.service.BackupPolicyService;
import com.parablu.bp.service.UserBackupPolicyMappingService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BluSyncGroupBackupPolicyElement;
import com.parablu.paracloud.element.EditDeviceContainerElement;
import com.parablu.paracloud.element.EndpointUiDisabledPreferencesElement;
import com.parablu.paracloud.element.EndpointUiPreferencesElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.User;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import sun.misc.BASE64Encoder;

@Controller
public class UserBackupPolicyMappingController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(UserBackupPolicyMappingController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private UserBackupPolicyMappingService userBackupPolicyMappingService;
    @Autowired
    private BackupPolicyService backupPolicyService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private EventHubManagementService eventHubManagementService;
    @Autowired
    private AuthorizationService authorizationService1;
    private static final String ALGO = "AES";
    private static final byte[] keyValue = new byte[]{84, 104, 101, 66, 101, 115, 116, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String USER_NAME = "userName";
    private static final String ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT = "Error failed to load groupPolicyElement  ...";
    private static final String END_OF_LOADING_ALL_BACKUP_POLICY_MAPPING = "end of loading AllUserBackupPolicyMapping ...";
    private static final String ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING = "Error failed to load AllUserBackupPolicyMapping ...";

    @RequestMapping(value={"cloud/{cloudName}/deviceBackupPolicy"}, method={RequestMethod.GET})
    public ModelAndView getDeviceLicense(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load deviceBackupLicenseElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            if (token.isEmpty()) {
                response.setStatus(400);
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.performAuthorization(cloudId, cloudName, authorizationTokens, response)) {
                return null;
            }
            String deviceUUID = request.getHeader(DEVICE_UUID);
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(400);
                return null;
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all deviceBackupLicenseElement  ..." + (Object)((Object)e));
            logger.error("Error failed to load all deviceBackupLicenseElement  ..." + e.getMessage());
        }
        logger.debug("end of load all deviceBackupLicenseElement ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/groupPolicy"}, method={RequestMethod.GET})
    public ModelAndView getGroupPolicyDetails(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load groupPolicyElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        response.setContentType("text/html; charset=UTF-8");
        try {
            List endpointUiDisabledPreferencesElementList;
            List endpointUiPreferencesElementList;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.checkLicense(cl, response)) {
                logger.error("License failed in load groupPolicyElement  ...");
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            if (StringUtils.isEmpty((String)token)) {
                response.setStatus(400);
                logger.error("Token is empty load groupPolicyElement  ...");
                return null;
            }
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String userName = request.getHeader(USER_NAME);
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                response.setStatus(400);
                logger.error(deviceUUID + "authorizationTokens null failed in load groupPolicyElement  ..." + userName);
                logger.error("TOKEN from Client ............. " + token);
                return null;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                logger.error("Device not available for load groupPolicyElement  ...");
                response.setStatus(400);
                return null;
            }
            BluSyncGroupBackupPolicyElement groupPolicyElement = this.backupPolicyService.getBluSyncGroupPolicyElement(cloudId, cloudName, userName, deviceUUID);
            BackupPolicy backupPolicy = this.backupPolicyService.getBackupPolicy(cloudId, groupPolicyElement.getPolicygroupName());
            if (groupPolicyElement != null) {
                long cpuUtil = groupPolicyElement.getCpuUtilization();
                groupPolicyElement.setCpuUtilization(groupPolicyElement.getMemoryUtilization());
                groupPolicyElement.setMemoryUtilization(Long.valueOf(cpuUtil));
                groupPolicyElement.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            }
            String crawlLimit = "500";
            if (backupPolicy.getCrawlLimit() != 0) {
                crawlLimit = String.valueOf(backupPolicy.getCrawlLimit());
            }
            String fileChunkableSize = String.valueOf(PCHelperConstant.getFileChunkableSize());
            if (backupPolicy.getFileChunkableSize() != 0) {
                fileChunkableSize = String.valueOf(backupPolicy.getFileChunkableSize());
            }
            if (!CollectionUtils.isEmpty((Collection)(endpointUiPreferencesElementList = groupPolicyElement.getEndpointUiPreferencesElementList()))) {
                ArrayList<EndpointUiPreferencesElement> responseValues = new ArrayList<EndpointUiPreferencesElement>();
                for (EndpointUiPreferencesElement endpointUiPreferencesElement : endpointUiPreferencesElementList) {
                    logger.debug(".................." + endpointUiPreferencesElement.getEndpointsUiPreferences());
                    if (endpointUiPreferencesElement.getEndpointsUiPreferences().equals("PAUSE_BACKUP")) continue;
                    responseValues.add(endpointUiPreferencesElement);
                }
                groupPolicyElement.setEndpointUiPreferencesElementList(responseValues);
            }
            if (!CollectionUtils.isEmpty((Collection)(endpointUiDisabledPreferencesElementList = groupPolicyElement.getEndpointUiDisabledPreferencesElementList()))) {
                ArrayList<EndpointUiDisabledPreferencesElement> responseValues = new ArrayList<EndpointUiDisabledPreferencesElement>();
                for (EndpointUiDisabledPreferencesElement endpointUiPreferencesElement : endpointUiDisabledPreferencesElementList) {
                    logger.debug(".................." + endpointUiPreferencesElement.getEndpointDisabledUiPreferences());
                    responseValues.add(endpointUiPreferencesElement);
                }
                groupPolicyElement.setEndpointUiDisabledPreferencesElementList(responseValues);
            }
            groupPolicyElement.setSqlbkpEnabled(backupPolicy.isSqlbkpEnabled());
            logger.debug("....groupPolicyElement...." + groupPolicyElement.isSqlbkpEnabled());
            if (groupPolicyElement != null && !StringUtils.isEmpty((String)groupPolicyElement.getPreScanCommand())) {
                logger.debug("before....getPreScanCommand.." + groupPolicyElement.getPreScanCommand());
                groupPolicyElement.setPreScanCommand(this.encrypt(groupPolicyElement.getPreScanCommand()));
                logger.debug("after...getPreScanCommand..." + groupPolicyElement.getPreScanCommand());
            }
            if (groupPolicyElement != null && !StringUtils.isEmpty((String)groupPolicyElement.getPreBackupCommand())) {
                logger.debug("before....getPreBackupCommand.." + groupPolicyElement.getPreBackupCommand());
                groupPolicyElement.setPreBackupCommand(this.encrypt(groupPolicyElement.getPreBackupCommand()));
                logger.debug("after...getPreBackupCommand..." + groupPolicyElement.getPreBackupCommand());
            }
            if (groupPolicyElement != null && !StringUtils.isEmpty((String)groupPolicyElement.getPostBackupCommand())) {
                logger.debug("before....getPostBackupCommand.." + groupPolicyElement.getPostBackupCommand());
                groupPolicyElement.setPostBackupCommand(this.encrypt(groupPolicyElement.getPostBackupCommand()));
                logger.debug("after...getPostBackupCommand..." + groupPolicyElement.getPostBackupCommand());
            }
            modelAndView.addObject((Object)groupPolicyElement);
            response.setHeader("crawlLimit", crawlLimit);
            response.setHeader("fileChunkableSize", fileChunkableSize);
            response.setHeader("legalHoldEnabled", Boolean.toString(backupPolicy.isLegalHoldEnabled()));
            response.setHeader("vssEnabled", Boolean.toString(backupPolicy.isVssEnabled()));
            response.setHeader("backupSystemFilesEnabled", Boolean.toString(backupPolicy.isBackupSystemFilesEnabled()));
            response.setHeader("fullBackupSchedule", backupPolicy.getFullBackupSchedule());
            response.setStatus(200);
            EventHub eventHub = new EventHub();
            eventHub.setActionToUserName(userName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            this.eventHubManagementService.deleteAction(cloudId, cloudName, eventHub);
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView != null) {
                User user = this.userManagementService.getUserDetails(cloudId, cloudName, overView.getUserName());
                this.deviceManagementService.updateLastHeardTimeAndPolicyModifiedTime(cloudId, overView.getId(), user.getPolicyModifiedTime());
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT + e);
            logger.error(ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT + e.getMessage());
        }
        logger.debug("end of load groupPolicyElement ...");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/groupPolicy"}, method={RequestMethod.GET})
    public ModelAndView getGroupPolicyDetailsNew(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load groupPolicyElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        response.setContentType("text/html; charset=UTF-8");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.checkLicense(cl, response)) {
                logger.error("License failed in load groupPolicyElement  ...");
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            if (StringUtils.isEmpty((String)token)) {
                response.setStatus(400);
                logger.error("Token is empty load groupPolicyElement  ...");
                return null;
            }
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String userName = request.getHeader(USER_NAME);
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                response.setStatus(400);
                logger.error(deviceUUID + "authorizationTokens null failed in load groupPolicyElement  ..." + userName);
                logger.error("TOKEN from Client ............. " + token);
                return null;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                logger.error("Device not available for load groupPolicyElement  ...");
                response.setStatus(400);
                return null;
            }
            BluSyncGroupBackupPolicyElement groupPolicyElement = this.backupPolicyService.getBluSyncGroupPolicyElement(cloudId, cloudName, userName, deviceUUID);
            BackupPolicy backupPolicy = this.backupPolicyService.getBackupPolicy(cloudId, groupPolicyElement.getPolicygroupName());
            if (groupPolicyElement != null) {
                long cpuUtil = groupPolicyElement.getCpuUtilization();
                groupPolicyElement.setCpuUtilization(groupPolicyElement.getMemoryUtilization());
                groupPolicyElement.setMemoryUtilization(Long.valueOf(cpuUtil));
                groupPolicyElement.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
                groupPolicyElement.setSqlbkpEnabled(backupPolicy.isSqlbkpEnabled());
            }
            String crawlLimit = "500";
            if (backupPolicy.getCrawlLimit() != 0) {
                crawlLimit = String.valueOf(backupPolicy.getCrawlLimit());
            }
            String fileChunkableSize = String.valueOf(PCHelperConstant.getFileChunkableSize());
            if (backupPolicy.getFileChunkableSize() != 0) {
                fileChunkableSize = String.valueOf(backupPolicy.getFileChunkableSize());
            }
            modelAndView.addObject((Object)groupPolicyElement);
            response.setHeader("crawlLimit", crawlLimit);
            response.setHeader("fileChunkableSize", fileChunkableSize);
            response.setHeader("legalHoldEnabled", Boolean.toString(backupPolicy.isLegalHoldEnabled()));
            response.setHeader("vssEnabled", Boolean.toString(backupPolicy.isVssEnabled()));
            response.setHeader("backupSystemFilesEnabled", Boolean.toString(backupPolicy.isBackupSystemFilesEnabled()));
            response.setHeader("fullBackupSchedule", backupPolicy.getFullBackupSchedule());
            response.setStatus(200);
            EventHub eventHub = new EventHub();
            eventHub.setActionToUserName(userName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            this.eventHubManagementService.deleteAction(cloudId, cloudName, eventHub);
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView != null) {
                User user = this.userManagementService.getUserDetails(cloudId, cloudName, overView.getUserName());
                this.deviceManagementService.updateLastHeardTimeAndPolicyModifiedTime(cloudId, overView.getId(), user.getPolicyModifiedTime());
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT + e);
            logger.error(ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT + e.getMessage());
        }
        logger.debug("end of load groupPolicyElement ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/check/groupPolicy/{userName}/"}, method={RequestMethod.GET})
    public void getDeviceBackupForMachine(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load deviceBackupElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String policyType = request.getHeader("syncpolicy");
            String deviceUUID = request.getHeader(DEVICE_UUID);
            boolean isUserPolicyMapped = false;
            if (!StringUtils.isEmpty((String)policyType) && "true".equalsIgnoreCase(policyType)) {
                isUserPolicyMapped = this.userBackupPolicyMappingService.isUserPolicyMapped(cloudId, cloudName, userName, "syncPolicy");
            } else if (this.isFeatureEnabled(cl, "Server Backup Enabled")) {
                logger.debug("policy check for server backup");
                List deviceContainerListElement = this.deviceManagementService.getAllDeviceContainers(cloudId, deviceUUID);
                for (EditDeviceContainerElement deviceContainer : deviceContainerListElement) {
                    isUserPolicyMapped = true;
                    if (!"".equals(deviceContainer.getBackupPolicyName())) continue;
                    isUserPolicyMapped = false;
                    break;
                }
            } else if (StringUtils.isEmpty((String)policyType) || "false".equalsIgnoreCase(policyType)) {
                isUserPolicyMapped = this.userBackupPolicyMappingService.isUserPolicyMapped(cloudId, cloudName, userName, "backupPolicy");
            }
            if (!isUserPolicyMapped) {
                response.setStatus(400);
                return;
            }
            response.setHeader("isUserPolicyMapped", Boolean.toString(isUserPolicyMapped));
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load deviceBackupElement ..." + (Object)((Object)e));
            logger.error("Error failed to load deviceBackupElement ..." + e.getMessage());
        }
        logger.debug("end of loading deviceBackupElement ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/load/all/userBackupPolicy/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object loadAllUserBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load AllUserBackupPolicyMapping ..pageNumberInteger.." + pageNumberInteger);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            int pageNumber = 0;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int skipValue = 0;
            int recordsCount = 0;
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            recordsCount = PCHelperConstant.getReportDisplayRecords();
            logger.debug(pageNumber + ".....skip and record count1 .." + skipValue + ".." + recordsCount);
            EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = this.userBackupPolicyMappingService.getPolicyElements(cloudId, skipValue, recordsCount, "backupPolicy", user);
            modelAndView.addObject((Object)editUserBackupPolicyMappingElement);
            response.setStatus(200);
            Map paramSet = request.getParameterMap();
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    policyNames.addAll(user.getBackupPoliciesAdmin());
                }
            }
            long totalRecordsCount = 0L;
            totalRecordsCount = user.isReadOnlyAdmin() ? this.backupPolicyService.loadAllBackupPoliciesMappingCount(cloudId, policyNames) : this.userBackupPolicyMappingService.getTotalMapping(cl.getCloud(), "backupPolicy");
            logger.debug(END_OF_LOADING_ALL_BACKUP_POLICY_MAPPING + pageNumber + "/" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), editUserBackupPolicyMappingElement);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e);
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/load/userBackupPolicy/users/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object loadAllUsersBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load load/userBackupPolicy/users ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String userNames = request.getHeader("userNames");
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = this.userBackupPolicyMappingService.getBackupPolicyElements(cloudId, list, "backupPolicy", user);
            modelAndView.addObject((Object)editUserBackupPolicyMappingElement);
            response.setStatus(200);
            logger.debug("end of loading load/userBackupPolicy/users ...");
            return this.toJSON(200, editUserBackupPolicyMappingElement);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/update/userBackupPolicy/users/"}, method={RequestMethod.GET})
    public void bulkUserPolicyUpdate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling update /update/userBackupPolicy/users/ ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String loginUserName = request.getHeader("loginUserName");
            String userNames = request.getHeader("userNames");
            String policyName = request.getHeader("policyName");
            logger.debug(" user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            String unAssignedUsers = this.userBackupPolicyMappingService.updateUserPolicys(cloudId, list, policyName, loginUserName, "backupPolicy", PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
            response.setHeader("unAssignedUsers", unAssignedUsers);
            if (StringUtils.isEmpty((String)unAssignedUsers)) {
                response.setStatus(200);
            } else {
                response.setStatus(409);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e.getMessage());
        }
        logger.debug("end of  /update/userBackupPolicy/users/ ......");
    }

    @RequestMapping(value={"cloud/{cloudName}/user/edit/backupPolicy/"}, method={RequestMethod.POST})
    public void editBackupPolicyForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling editBackupPolicyForUser ...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader(USER_NAME);
            String newPolicyName = request.getHeader("newPolicyName");
            String loginUserName = request.getHeader("loginUserName");
            this.userBackupPolicyMappingService.saveUserPolicyMapping(cloudId, cloudName, userName, newPolicyName, loginUserName, "backupPolicy", PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to edit BackupPolicyForUser ..." + (Object)((Object)e));
            logger.error("Error failed to edit BackupPolicyForUser ..." + e.getMessage());
        }
        logger.debug("end of calling editBackupPolicyForUser ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/get/groupPolicy"}, method={RequestMethod.GET})
    public ModelAndView getGroupPolicyDetailsForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load groupPolicyElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.checkLicense(cl, response)) {
                logger.error("License failed in load groupPolicyElement  ...");
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            if (StringUtils.isEmpty((String)token)) {
                response.setStatus(400);
                logger.error("Token is empty load groupPolicyElement  ...");
                return null;
            }
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String userName = request.getHeader(USER_NAME);
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                response.setStatus(400);
                logger.error(deviceUUID + "authorizationTokens null failed in load groupPolicyElement  ..." + userName);
                logger.error("TOKEN from Client ............. " + token);
                return null;
            }
            BluSyncGroupBackupPolicyElement groupPolicyElement = this.backupPolicyService.getBluSyncGroupPolicyElement(cloudId, cloudName, userName, deviceUUID);
            BackupPolicy backupPolicy = this.backupPolicyService.getBackupPolicy(cloudId, groupPolicyElement.getPolicygroupName());
            String crawlLimit = "500";
            if (backupPolicy.getCrawlLimit() != 0) {
                crawlLimit = String.valueOf(backupPolicy.getCrawlLimit());
            }
            String fileChunkableSize = String.valueOf(PCHelperConstant.getFileChunkableSize());
            if (backupPolicy.getFileChunkableSize() != 0) {
                fileChunkableSize = String.valueOf(backupPolicy.getFileChunkableSize());
            }
            modelAndView.addObject((Object)groupPolicyElement);
            response.setHeader("crawlLimit", crawlLimit);
            response.setHeader("fileChunkableSize", fileChunkableSize);
            response.setHeader("legalHoldEnabled", Boolean.toString(backupPolicy.isLegalHoldEnabled()));
            response.setHeader("vssEnabled", Boolean.toString(backupPolicy.isVssEnabled()));
            response.setHeader("backupSystemFilesEnabled", Boolean.toString(backupPolicy.isBackupSystemFilesEnabled()));
            response.setHeader("fullBackupSchedule", backupPolicy.getFullBackupSchedule());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT + e);
            logger.error(ERROR_FAILED_TO_LOAD_GROUP_POLICY_ELEMENT + e.getMessage());
        }
        logger.debug("end of load groupPolicyElement ...");
        return modelAndView;
    }

    private boolean isFeatureEnabled(CloudLicenseTo cl, String feature) {
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!customisableDetails.getName().equalsIgnoreCase(feature)) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"cloud/{cloudName}/load/all/oneDriveUserBackupPolicy/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object loadAllOneDriveUserBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load All oneDriveUserBackupPolicy ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            int pageNumber = 0;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            int skipValue = request.getIntHeader("skipValue");
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            int recordsCount = PCHelperConstant.getReportDisplayRecords();
            EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = this.userBackupPolicyMappingService.getODBPolicyElements(cloudId, skipValue, recordsCount, user);
            modelAndView.addObject((Object)editUserBackupPolicyMappingElement);
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = 0L;
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    policyNames.addAll(user.getOdbPoliciesAdmin());
                }
            }
            totalRecordsCount = user.isReadOnlyAdmin() ? this.backupPolicyService.loadAllOfficeBackupPoliciesMappingCount(cloudId, policyNames) : this.userBackupPolicyMappingService.getTotalMapping(cl.getCloud(), "OFFICE_POLICY");
            logger.debug("end of loading AllUserSyncPolicyMapping ...oneDriveUserBackupPolicy" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), editUserBackupPolicyMappingElement);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e);
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/edit/odbBackupPolicy/"}, method={RequestMethod.POST})
    public void editODBBackupPolicyForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling edit odbBackupPolicy for user ...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader(USER_NAME);
            String newPolicyName = request.getHeader("newPolicyName");
            String loginUserName = request.getHeader("loginUserName");
            this.userBackupPolicyMappingService.saveODBUserPolicyMapping(cloudId, userName, newPolicyName, loginUserName, "backupPolicy", PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Error failed to edit BackupPolicyForUser ..." + e);
            logger.error("Error failed to edit BackupPolicyForUser ..." + e.getMessage());
        }
        logger.debug("end of calling edit odbBackupPolicy for user ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/update/userODBPolicy/users/"}, method={RequestMethod.GET})
    public void bulkUserODBPolicyUpdate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling update /update/userODBPolicy/users/ ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String loginUserName = request.getHeader("loginUserName");
            String userNames = request.getHeader("userNames");
            String policyName = request.getHeader("policyName");
            logger.debug(" user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            String unAssignedUsers = this.userBackupPolicyMappingService.updateUserODBPolicys(cloudId, list, policyName, loginUserName, "o365BackupPolicy", PCActionTypes.CHANGE_O365_BACKUP_POLICY.getActionTypeValue());
            response.setHeader("unAssignedUsers", unAssignedUsers);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_BACKUP_POLICY_MAPPING + e.getMessage());
        }
        logger.debug("end of  /update/userODBPolicy/users/ ......");
    }

    public String encrypt(String data) throws Exception {
        Key key = this.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(1, key);
        byte[] encVal = c.doFinal(data.getBytes());
        return new BASE64Encoder().encode(encVal);
    }

    private Key generateKey() throws Exception {
        return new SecretKeySpec(keyValue, ALGO);
    }
}

