/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.PortalPropertiesService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BrandingItem;
import com.parablu.paracloud.element.BrandingItemList;
import com.parablu.paracloud.element.PortalPropertiesElement;
import com.parablu.pcbd.domain.PortalProperties;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PortalPropertiescontroller
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(PortalPropertiescontroller.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private PortalPropertiesService portalPropertiesService;

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/portalProperties/"}, method={RequestMethod.GET})
    public ModelAndView getCloudProperties(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String componentName = request.getHeader("componentName");
        PortalPropertiescontroller.printLogs((String)("calling portalPropertes/get..." + componentName), (boolean)PCHelperConstant.isBrevityLogging());
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            PortalProperties compoenents;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                // empty if block
            }
            if ((compoenents = this.portalPropertiesService.getPortalProperties(cl.getCloud().getCloudId(), componentName)) == null) {
                response.setStatus(404);
                return null;
            }
            response.setStatus(200);
            modelAndView.addObject((Object)compoenents);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error loading properties files ..." + (Object)((Object)e));
            logger.debug("Error properties ..." + e.getMessage());
        }
        logger.debug("end of calling portalPropertes ...");
        return modelAndView;
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/portalProperties/"}, method={RequestMethod.POST})
    public void updateCloudProperties(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, @RequestBody PortalPropertiesElement portalPropertiesElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("saving portalProperties/post...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(404);
                return;
            }
            logger.debug("....properties...." + portalPropertiesElement.getComponentName());
            logger.debug("....properties...." + portalPropertiesElement.toString());
            if (this.portalPropertiesService.updateComponents(cl.getCloud().getCloudId(), portalPropertiesElement).booleanValue()) {
                logger.debug("properties are save successfully...........");
                response.setStatus(200);
                return;
            }
            response.setStatus(204);
            return;
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error loading portalProperties..." + (Object)((Object)e));
            logger.debug("Error portalProperties ..." + e.getMessage());
            return;
        }
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/brandings/"}, method={RequestMethod.POST})
    public void saveBrandingItems(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, @RequestBody BrandingItemList brandingItemList, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("saving saveBrandingItems/post...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(404);
                return;
            }
            List brandingItems = brandingItemList.getBrandingItems();
            for (BrandingItem brandingIte : brandingItems) {
                this.portalPropertiesService.saveBrandingItem(cl.getCloud().getCloudId(), brandingIte.getFilePath(), brandingIte.getFileName());
            }
            response.setStatus(200);
            return;
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error loading portalProperties..." + (Object)((Object)e));
            logger.debug("Error portalProperties ..." + e.getMessage());
            return;
        }
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/brandings/"}, method={RequestMethod.GET})
    public ModelAndView getBrandingItems(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        String fileNames = request.getHeader("fileNames");
        String filePath = request.getHeader("filePath");
        logger.debug("get getBrandingItems ..." + fileNames);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(404);
                return null;
            }
            if (!StringUtils.isEmpty((String)fileNames)) {
                BrandingItemList brandingItem = this.portalPropertiesService.getBrandingItem(Arrays.asList(fileNames.split(",")), filePath);
                modelAndView.addObject((Object)brandingItem);
                response.setStatus(200);
            } else {
                response.setStatus(204);
            }
            return modelAndView;
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error loading portalProperties..." + (Object)((Object)e));
            logger.debug("Error portalProperties ..." + e.getMessage());
            return null;
        }
    }
}

