/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.BackupPolicyService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.OPWSElement;
import com.parablu.pcbd.domain.OPWS;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class OperationalWindowController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(OperationalWindowController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private BackupPolicyService backupPolicyService;
    private static final String ERROR_FAILED_TO_SAVE_OPWS = "Error failed to save opws ...";

    @RequestMapping(value={"/cloud/{cloudName}/mt/opws/save/"}, method={RequestMethod.POST})
    public void saveOpWinSupport(@PathVariable(value="cloudName") String cloudName1, @RequestBody OPWSElement opwsElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save Opws ..." + opwsElement.getThreadSize());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            OPWS opws = new OPWS();
            opws.setThreadSize(opwsElement.getThreadSize());
            this.backupPolicyService.saveOPWS(cloudId, cloudName, opws);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_OPWS + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_OPWS + e.getMessage());
        }
        logger.debug("end of saving /opws/save ...");
    }

    @RequestMapping(value={"/cloud/{cloudName}/opws/get/threadsize"}, method={RequestMethod.GET})
    public void getThreadSize(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling get thread size in Opws ...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            long threadSize = this.backupPolicyService.getThreadSize(cloudId, cloudName);
            response.setStatus(200);
            response.setHeader("thread-size", String.valueOf(threadSize));
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_OPWS + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_OPWS + e.getMessage());
        }
        logger.debug("end of calling /get/threadSize ...");
    }
}

