/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.BackupFolderService;
import com.parablu.bp.service.NotificationsService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.NotificationsTypeElement;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class NotificationsController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(NotificationsController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private BackupFolderService backupFolderService;
    @Autowired
    private NotificationsService notificationsService;
    private static final String ERROR_FAILED_TO_SAVE_SCHEDULE = "Error failed to save Schedule ...";
    private static final String CALLING_GET_NOTIFICATIONS = "calling get notifications ...";
    private static final String END_OF_GET_NOTIFICATIONS = "end of get /notifications...";

    @RequestMapping(value={"cloud/{cloudName}/notificationsType/save"}, method={RequestMethod.POST})
    public void saveNotificationsType(@PathVariable(value="cloudName") String cloudName1, @RequestBody NotificationsTypeElement notificationsTypeElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save notifications type ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            this.notificationsService.saveNotificationsType(cloudId, cloudName, notificationsTypeElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_SCHEDULE + e.getMessage());
        }
        logger.debug("end of calling /saveNotificationsType ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/notifications/get"}, method={RequestMethod.GET})
    public ModelAndView getNotifications(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_GET_NOTIFICATIONS);
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            NotificationsTypeElement element = this.notificationsService.getNotifications(cloudId, cloudName);
            modelAndView.addObject((Object)element);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_SCHEDULE + e.getMessage());
        }
        logger.debug(END_OF_GET_NOTIFICATIONS);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/notifications/save"}, method={RequestMethod.POST})
    public void saveNotifications(@PathVariable(value="cloudName") String cloudName1, @RequestBody NotificationsTypeElement notificationsTypeElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling save notifications ...");
        String cloudName = cloudName1;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            this.notificationsService.saveNotifications(cloudId, cloudName, notificationsTypeElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_SCHEDULE + e.getMessage());
        }
        logger.debug("end of calling /saveNotifications...");
    }

    @RequestMapping(value={"cloud/{cloudName}/notifications/getusernames/{policyName}/"}, method={RequestMethod.GET})
    public ModelAndView getuserNamesForPolicy(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="policyType") String policyType, @PathVariable(value="policyName") String policyName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling get user names for policy ...policy name is:" + policyName);
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            NotificationsTypeElement element = this.notificationsService.getusersListForPolicy(cloudId, cloudName, policyName, "backupPolicy");
            modelAndView.addObject((Object)element.getUserNames());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to get user names For policy ..." + (Object)((Object)e));
            logger.error("Error failed to get user names For policy ..." + e.getMessage());
        }
        logger.debug("end of get /user names for policy...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/savednotifications/get"}, method={RequestMethod.GET})
    public ModelAndView getSavedNotifications(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_GET_NOTIFICATIONS);
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<NotificationsTypeElement> elementList = this.notificationsService.getSavedNotifications(cloudId, cloudName);
            modelAndView.addObject(elementList);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_SCHEDULE + e.getMessage());
        }
        logger.debug(END_OF_GET_NOTIFICATIONS);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/notifications/update"}, method={RequestMethod.POST})
    public void updateNotifications(@PathVariable(value="cloudName") String cloudName1, @RequestBody NotificationsTypeElement notificationsTypeElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling save notifications ...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String notificationId = request.getHeader("notification-id");
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            if (notificationsTypeElement != null) {
                this.notificationsService.updateNotification(cloudId, cloudName, notificationId, notificationsTypeElement);
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_SCHEDULE + e.getMessage());
        }
        logger.debug("end of calling /updateNotifications...");
    }

    @RequestMapping(value={"cloud/{cloudName}/savednotifications/delete/{notificationId}/"}, method={RequestMethod.DELETE})
    public void deleteSavedNotificationsById(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="notificationId") String notificationId, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling delete notifications ...");
        String cloudName = cloudName1;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            this.notificationsService.deleteSavedNotificationsById(cloudId, cloudName, notificationId);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to delete Notification ..." + (Object)((Object)e));
            logger.error("Error failed to delete Notification ..." + e.getMessage());
        }
        logger.debug("end of delete /notifications...");
    }

    @RequestMapping(value={"cloud/{cloudName}/savednotifications/get/{notificationId}/"}, method={RequestMethod.GET})
    public ModelAndView getSavedNotificationsById(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="notificationId") String notificationId, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_GET_NOTIFICATIONS);
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            NotificationsTypeElement element = this.notificationsService.getSavedNotificationsForId(cloudId, cloudName, notificationId);
            modelAndView.addObject((Object)element);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_SCHEDULE + e.getMessage());
        }
        logger.debug(END_OF_GET_NOTIFICATIONS);
        return modelAndView;
    }
}

