/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.DeviceBackupPolicyMappingService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.BluSyncGroupPolicyElementList;
import com.parablu.paracloud.element.bp.EditDeviceBackupPolicyMappingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DeviceBackupPolicyMappingController
extends BaseController {
    private static Logger logger = Logger.getLogger(DeviceBackupPolicyMappingController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceBackupPolicyMappingService deviceBackupPolicyMappingService;

    @RequestMapping(value={"cloud/{cloudName}/update/deviceBackupPolicy/devices/"}, method={RequestMethod.GET})
    public void updateDevicePolicies(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug((Object)"DeviceBackupPolicyMappingController > updateDevicePolicies > BEGIN");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            logger.debug((Object)("updateDevicePolicies > CLOUD NAME >" + cloudName));
            int cloudId = cl.getCloud().getCloudId();
            String loggedinUserName = request.getHeader("loginUserName");
            String devices = request.getHeader("devices");
            String policyName = request.getHeader("policyName");
            logger.debug((Object)("DeviceBackupPolicyMappingController > updateDevicePolicies > divices >" + devices));
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(devices.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            this.deviceBackupPolicyMappingService.saveDevicePolicies(cloudId, cloudName, list, policyName, loggedinUserName);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug((Object)("Error failed to load saveDevicePolicies ..." + (Object)((Object)e)));
            logger.error((Object)("Error failed to load saveDevicePolicies ..." + e.getMessage()));
        }
        logger.debug((Object)"updateDevicePolicies > END");
    }

    @RequestMapping(value={"cloud/{cloudName}/load/all/deviceBackupPolicies/"}, method={RequestMethod.GET})
    public ModelAndView loadAllDeviceBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug((Object)"loadAllDeviceBackupPolicyMapping > BEGIN ");
        ModelAndView modelAndView = new ModelAndView();
        String deviceNames = request.getHeader("deviceNames");
        ArrayList<String> deviceNameList = null;
        if (deviceNames != null && !"all".equalsIgnoreCase(deviceNames)) {
            String[] temp = deviceNames.split(",");
            deviceNameList = new ArrayList<String>();
            for (int i = 0; i < temp.length; ++i) {
                deviceNameList.add(temp[i].trim());
            }
        }
        int skipValue = request.getIntHeader("skipValue");
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            EditDeviceBackupPolicyMappingElement edpm = this.deviceBackupPolicyMappingService.getAllDeviceBackupPolicyMapings(cloudId, cloudName, skipValue, deviceNameList);
            modelAndView.addObject((Object)edpm);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug((Object)("Error failed to load loadAllDeviceBackupPolicyMapping ..." + (Object)((Object)e)));
            logger.error((Object)("Error failed to load loadAllDeviceBackupPolicyMapping ..." + e.getMessage()));
        }
        logger.debug((Object)"loadAllDeviceBackupPolicyMapping > END ");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/get/deviceBackupPolicy/"}, method={RequestMethod.GET})
    public ModelAndView getDeviceBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug((Object)"getDeviceBackupPolicyMapping > BEGIN ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String deviceUUID = request.getHeader("deviceUUID");
        String userName = request.getHeader("userName");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            BluSyncGroupPolicyElementList bSyncGpEl = this.deviceBackupPolicyMappingService.getDeviceContainerGroupPolicyElement(cloudId, cloudName, deviceUUID, userName);
            modelAndView.addObject((Object)(bSyncGpEl == null ? "Invalid Device/Policy" : bSyncGpEl));
            logger.debug((Object)("BluSync groupelement:" + bSyncGpEl));
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug((Object)("Error failed to load getDeviceBackupPolicyMapping ..." + (Object)((Object)e)));
            logger.error((Object)("Error failed to load getDeviceBackupPolicyMapping ..." + e.getMessage()));
        }
        logger.debug((Object)"getDeviceBackupPolicyMapping > END ");
        return modelAndView;
    }
}

