/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.DeviceBackupJobService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.element.bp.DeviceBackupJobElement;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DeviceBackupJobController
extends BaseController {
    private static Logger logger = Logger.getLogger(DeviceBackupJobController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceBackupJobService deviceBackupJobService;
    private static final String INVALID_CLOUD_NAME = "Invalid cloud name ....";
    private static final String EXCEPTION = "Exception  ";

    @RequestMapping(value={"/cloud/{cloudName}/registerBackupJob/"}, method={RequestMethod.POST})
    public void registerBackupJob(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody DeviceBackupJobElement deviceBackupJobElement) {
        String token;
        String cloudName = cloudName1;
        logger.debug((Object)"registerBackupJob(DeviceBackupJobElement deviceBackupJobElement) > BEGIN");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug((Object)INVALID_CLOUD_NAME);
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
            return;
        }
        try {
            String jobId = this.deviceBackupJobService.registerBackupJob(deviceBackupJobElement, cloudId);
            logger.debug((Object)("registerBackupJob(DeviceBackupJobElement deviceBackupJobElement) > JOBID > ----------------- " + jobId));
            response.setHeader("JobID", jobId);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace((Object)(EXCEPTION + ex));
            logger.error((Object)(EXCEPTION + ex.getMessage()));
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/updateBackupJob/"}, method={RequestMethod.POST})
    public void updateBackupJob(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String token;
        String cloudName = cloudName1;
        logger.debug((Object)"registerBackupJob(DeviceBackupJobElement deviceBackupJobElement) > BEGIN");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug((Object)INVALID_CLOUD_NAME);
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
            return;
        }
        try {
            String deviceUUID = request.getHeader("deviceUUID");
            String currentStep = request.getHeader("currentStep");
            String status = request.getHeader("status");
            String jobId = request.getHeader("jobId");
            long endTime = request.getHeader("endTime") == null ? 0L : Long.parseLong(request.getHeader("endTime"));
            long sizeOnDiskInBytes = request.getHeader("backupSizeOnDiskInBytes") == null ? 0L : Long.parseLong(request.getHeader("backupSizeOnDiskInBytes"));
            logger.debug((Object)("sizeOnDiskInBytes sizeOnDiskInBytes ....sizeOnDiskInBytes " + sizeOnDiskInBytes));
            this.deviceBackupJobService.updateDeviceBackupJob(cloudId, deviceUUID, status, currentStep, jobId, endTime, sizeOnDiskInBytes);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace((Object)(EXCEPTION + ex));
            logger.error((Object)(EXCEPTION + ex.getMessage()));
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/getOngoingBackupJobs/"}, method={RequestMethod.GET})
    public ModelAndView getOngoingBackupJobs(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug((Object)"getOngoingBackupJobs > BEGIN");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug((Object)INVALID_CLOUD_NAME);
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        String deviceUUID = request.getHeader("deviceUUID");
        int skipValue = request.getIntHeader("skipValue");
        String status = request.getHeader("status");
        try {
            List<DeviceBackupJobElement> bkpJobElemets = this.deviceBackupJobService.getAllOngoingJobs(cloudId, deviceUUID, skipValue, status);
            modelAndView.addObject(bkpJobElemets);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setStatus(500);
            logger.trace((Object)(EXCEPTION + ex));
            logger.error((Object)(EXCEPTION + ex.getMessage()));
        }
        return modelAndView;
    }
}

