/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.PortalPropertiesService;
import com.parablu.paracloud.element.BrandingItem;
import com.parablu.paracloud.element.BrandingItemList;
import com.parablu.paracloud.element.PortalPropertiesElement;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.PortalProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PortalPropertiesServiceImpl
implements PortalPropertiesService {
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    private static Logger logger = LoggerFactory.getLogger(PortalPropertiesServiceImpl.class);
    @Resource
    private BluVaultDao bluVaultDao;
    public static final String FILE_PATH = "/parablu/tmp-chunk";

    @Override
    public PortalProperties getPortalProperties(int cloudId, String componentName) {
        return this.portalPropertiesDao.getPortalProperties(cloudId, componentName);
    }

    public PortalPropertiesDao getPortalPropertiesDao() {
        return this.portalPropertiesDao;
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    @Override
    public Boolean updateComponents(int cloudId, PortalPropertiesElement portalPropertiesElement) {
        PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloudId, portalPropertiesElement.getComponentName());
        if (portalProperties != null) {
            portalProperties.setComponentsProperties(portalPropertiesElement.getComponentsProperties());
            this.portalPropertiesDao.savePortalProperties(cloudId, portalProperties);
            return true;
        }
        return false;
    }

    @Override
    public BrandingItemList getBrandingItem(List<String> fileNames, String filePath) {
        BrandingItemList brandingItemList = new BrandingItemList();
        ArrayList<BrandingItem> branchElements = new ArrayList<BrandingItem>();
        if (StringUtils.isEmpty((String)filePath)) {
            filePath = FILE_PATH;
        }
        for (String fileName : fileNames) {
            boolean brandingItimeResult = this.portalPropertiesDao.getBrandingItem(filePath, fileName);
            if (!brandingItimeResult) continue;
            BrandingItem brandingItem = new BrandingItem();
            brandingItem.setFilePath(filePath);
            brandingItem.setFileName(fileName);
            branchElements.add(brandingItem);
        }
        brandingItemList.setBrandingItems(branchElements);
        return brandingItemList;
    }

    @Override
    public void saveBrandingItem(int cloudId, String filePath, String fileName) {
        this.portalPropertiesDao.saveBrandingItem(filePath, fileName);
        List allGateways = this.bluVaultDao.getAllBluVaults(cloudId, "");
        for (BluVault gateway : allGateways) {
            logger.debug(".....allGateways...." + gateway.getBluVaultName());
            Map componentsProperties = gateway.getComponentsProperties();
            if (gateway == null || CollectionUtils.isEmpty((Map)componentsProperties)) continue;
            componentsProperties.put("brandingPropertyUpdated", "false");
            gateway.setComponentsProperties(componentsProperties);
            logger.debug(".....allGateways...." + (String)gateway.getComponentsProperties().get("brandingPropertyUpdated"));
            this.bluVaultDao.saveBluVault(cloudId, "", gateway);
        }
    }

    public BluVaultDao getBluVaultDao() {
        return this.bluVaultDao;
    }

    public void setBluVaultDao(BluVaultDao bluVaultDao) {
        this.bluVaultDao = bluVaultDao;
    }
}

