/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.PGInfoService;
import com.parablu.paracloud.element.PGInfoElement;
import com.parablu.pcbd.dao.PGInfoDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.domain.PGInfo;
import com.parablu.pcbd.domain.PrivacyGateway;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PGInfoServiceImpl
implements PGInfoService {
    @Resource
    private PGInfoDao pgInfoDao;
    @Resource
    private PrivacyGateWayDao privacyGateWayDao;
    private static Logger logger = Logger.getLogger(PGInfoServiceImpl.class);
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String PARSE_EXCEPTION = "ParseException  :";

    @Override
    public List<PGInfoElement> getPGInfo(int cloudId, String cloudName, String startDate, String endDate) {
        List pgInfoList = this.pgInfoDao.getPGInfo(cloudId, cloudName, PGInfoServiceImpl.getStartOfDay(startDate), PGInfoServiceImpl.getEndOfDay(endDate));
        ArrayList<PGInfoElement> pgInfoElements = new ArrayList<PGInfoElement>();
        for (PGInfo pgInfo : pgInfoList) {
            PGInfoElement element = new PGInfoElement();
            element.setGatewayName(pgInfo.getGatewayName());
            element.setSizeInMB(pgInfo.getSizeInMB());
            element.setDate(this.getDate(pgInfo.getTimeStamp()));
            pgInfoElements.add(element);
        }
        return pgInfoElements;
    }

    public static long getStartOfDay(String startDate1) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        String startDate = startDate1;
        if (startDate == null || startDate == "") {
            startDate = "01/01/1971";
        }
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.trace((Object)(PARSE_EXCEPTION + e));
            logger.error((Object)(PARSE_EXCEPTION + e.getMessage()));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    private String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace((Object)("NumberFormatException  :" + e));
            logger.error((Object)("NumberFormatException  :" + e.getMessage()));
        }
        return date;
    }

    public static long getEndOfDay(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        if (endDate == null || endDate == "") {
            return System.currentTimeMillis();
        }
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.trace((Object)(PARSE_EXCEPTION + e));
            logger.error((Object)(PARSE_EXCEPTION + e.getMessage()));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    @Override
    public List<PGInfoElement> getTotalStoragePerPG(int cloudId, String cloudName) {
        List gatewayList = this.privacyGateWayDao.getAllGateways(cloudId);
        ArrayList<PGInfoElement> pgInfoElements = new ArrayList<PGInfoElement>();
        for (PrivacyGateway gateway : gatewayList) {
            PGInfo pgInfo = this.pgInfoDao.getTotalStoragePerPg(cloudId, cloudName, gateway.getGatewayName());
            PGInfoElement element = new PGInfoElement();
            element.setGatewayName(gateway.getGatewayName());
            element.setSizeInMB(pgInfo.getSizeInMB());
            pgInfoElements.add(element);
        }
        return pgInfoElements;
    }

    @Override
    public List<PGInfoElement> getODInfo(int cloudId, String cloudName, String startDate, String endDate) {
        List pgInfoList = this.pgInfoDao.getODInfo(cloudId, cloudName, PGInfoServiceImpl.getStartOfDay(startDate), PGInfoServiceImpl.getEndOfDay(endDate));
        ArrayList<PGInfoElement> pgInfoElements = new ArrayList<PGInfoElement>();
        for (PGInfo pgInfo : pgInfoList) {
            PGInfoElement element = new PGInfoElement();
            element.setGatewayName(pgInfo.getGatewayName());
            element.setSizeInMB(pgInfo.getSizeInMB());
            element.setDate(this.getDate(pgInfo.getTimeStamp()));
            pgInfoElements.add(element);
        }
        return pgInfoElements;
    }

    @Override
    public List<PGInfoElement> getBlobStorageInfo(int cloudId, String cloudName, String startDate, String endDate) {
        List pgInfoList = this.pgInfoDao.getBlobStorageInfo(cloudId, cloudName, PGInfoServiceImpl.getStartOfDay(startDate), PGInfoServiceImpl.getEndOfDay(endDate));
        ArrayList<PGInfoElement> pgInfoElements = new ArrayList<PGInfoElement>();
        for (PGInfo pgInfo : pgInfoList) {
            PGInfoElement element = new PGInfoElement();
            element.setGatewayName(pgInfo.getGatewayName());
            element.setSizeInMB(pgInfo.getSizeInMB());
            element.setDate(this.getDate(pgInfo.getTimeStamp()));
            pgInfoElements.add(element);
        }
        return pgInfoElements;
    }
}

