/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.InclusionFilterService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.FilterTemplateElement;
import com.parablu.paracloud.element.InclusionFilterElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.FilterTemplate;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InclusionFilterServiceImpl
implements InclusionFilterService {
    Logger logger = LoggerFactory.getLogger(InclusionFilterServiceImpl.class);
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    SyncPolicyDao syncPolicyDao;
    @Resource
    private UserDao userDao;

    @Override
    public void saveInclusionFilter(int cloudId, String cloudName, InclusionFilter inclusionFilter, String userName) {
        InclusionFilter existingInclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, inclusionFilter.getFilterName());
        this.logger.debug(inclusionFilter.getFilterName() + ".....save inclusion/exclusion filter ..... " + existingInclusionFilter);
        if (existingInclusionFilter != null) {
            ObjectId id = existingInclusionFilter.getId();
            BeanUtils.copyProperties((Object)inclusionFilter, (Object)existingInclusionFilter);
            existingInclusionFilter.setId(id);
            this.inclusionFilterDao.saveInclusionFilter(cloudId, cloudName, existingInclusionFilter);
            List backupPolicyList = this.backupPolicyDao.getBackupPolicyForFilterId(cloudId, cloudName, existingInclusionFilter.getId());
            List syncPolicyList = this.syncPolicyDao.getSyncPolicyForFilterId(cloudId, cloudName, existingInclusionFilter.getId());
            this.logger.debug("......id....." + existingInclusionFilter.getId());
            if (!CollectionUtils.isEmpty((Collection)backupPolicyList)) {
                this.logger.debug("..policies affected.... " + backupPolicyList.size());
            }
            for (BackupPolicy backupPolicy : backupPolicyList) {
                backupPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
                this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, backupPolicy);
                this.userDao.updateBackupPolicyModifiedTime(cloudId, backupPolicy.getPolicyName());
            }
            for (SyncPolicy syncPolicy : syncPolicyList) {
                syncPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
                this.syncPolicyDao.saveSyncPolicy(cloudId, cloudName, syncPolicy);
                this.userDao.updateSyncPolicyModifiedTime(cloudId, syncPolicy.getPolicyName());
            }
            this.saveStatisticToDatabase(cloudId, cloudName, "modified filter", userName, existingInclusionFilter.getFilterName(), PCActionTypes.FILTER_UPDATE.getActionTypeValue());
        } else {
            this.inclusionFilterDao.saveInclusionFilter(cloudId, cloudName, inclusionFilter);
            this.saveStatisticToDatabase(cloudId, cloudName, "created filter", userName, inclusionFilter.getFilterName(), PCActionTypes.FILTER_CREATE.getActionTypeValue());
        }
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public InclusionFilterElement getInclusionFilter(int cloudId, String cloudName, String filterName) {
        InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
        return this.getInclusionFilterElement(inclusionFilter);
    }

    @Override
    public List<InclusionFilterElement> getInclusionFiltersByNames(int cloudId, String cloudName, List<String> filterNames) {
        ArrayList<InclusionFilterElement> filtersList = new ArrayList<InclusionFilterElement>();
        for (String filterName : filterNames) {
            InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilter == null) continue;
            filtersList.add(this.getInclusionFilterElement(inclusionFilter));
        }
        return filtersList;
    }

    @Override
    public boolean deleteInclusionFilter(int cloudId, String cloudName, String filterName, String userName) {
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        List syncPolicies = this.syncPolicyDao.getAllSyncPolicy(cloudId, cloudName);
        ArrayList<String> backupPolicyFilterNames = new ArrayList<String>();
        ArrayList<String> syncPolicyFilterNames = new ArrayList<String>();
        List officeBackupPolicies = this.backupPolicyDao.getAllOfficePolicies(cloudId);
        ArrayList<String> officyPolicyFilterNames = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)officeBackupPolicies)) {
            for (OfficeBackupPolicy backupPolicy : officeBackupPolicies) {
                if (!CollectionUtils.isEmpty((Collection)backupPolicy.getMailInclusionFilter())) {
                    for (String filter : backupPolicy.getMailInclusionFilter()) {
                        officyPolicyFilterNames.add(filter.getFilterName());
                    }
                }
                if (CollectionUtils.isEmpty((Collection)backupPolicy.getOdInclusionFilter())) continue;
                for (String filter : backupPolicy.getOdInclusionFilter()) {
                    officyPolicyFilterNames.add(filter.getFilterName());
                }
            }
        }
        for (OfficeBackupPolicy backupPolicy : backupPolicies) {
            for (String filter : backupPolicy.getFilterInclusionName()) {
                backupPolicyFilterNames.add(filter);
            }
        }
        for (SyncPolicy syncPolicy : syncPolicies) {
            for (String filter : syncPolicy.getFilterInclusionName()) {
                syncPolicyFilterNames.add(filter);
            }
        }
        if (!CollectionUtils.isEmpty(backupPolicyFilterNames) && backupPolicyFilterNames.contains(filterName) || !CollectionUtils.isEmpty(syncPolicyFilterNames) && syncPolicyFilterNames.contains(filterName) || !CollectionUtils.isEmpty(officyPolicyFilterNames) && officyPolicyFilterNames.contains(filterName)) {
            return false;
        }
        boolean deleted = this.inclusionFilterDao.removeInclusionFilter(cloudId, filterName);
        if (deleted) {
            this.saveStatisticToDatabase(cloudId, cloudName, "deleted filter", userName, filterName, PCActionTypes.FILTER_DELETE.getActionTypeValue());
            return true;
        }
        return false;
    }

    @Override
    public List<InclusionFilterElement> getAllInclusionFilters(int cloudId, String cloudName) {
        List inclusionFilterList = this.inclusionFilterDao.getAllInclusionFilters(cloudId, cloudName);
        ArrayList<InclusionFilterElement> elements = new ArrayList<InclusionFilterElement>();
        for (InclusionFilter inclusionFilter : inclusionFilterList) {
            InclusionFilterElement element = this.getInclusionFilterElement(inclusionFilter);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<FilterTemplateElement> getFilterTemplets(int cloudId) {
        List FilterList = this.inclusionFilterDao.getAllFilterTemplates(cloudId);
        ArrayList<FilterTemplateElement> elements = new ArrayList<FilterTemplateElement>();
        for (FilterTemplate filter : FilterList) {
            FilterTemplateElement element = this.getFilterTempletElement(filter);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<FilterTemplateElement> getFilterTempletsByName(int cloudId, List<String> filterNames) {
        ArrayList<FilterTemplateElement> filtersList = new ArrayList<FilterTemplateElement>();
        for (String filterName : filterNames) {
            FilterTemplate filter = this.inclusionFilterDao.getFilterTemplateByName(cloudId, filterName);
            if (filter == null) continue;
            FilterTemplateElement element = this.getFilterTempletElement(filter);
            filtersList.add(element);
        }
        return filtersList;
    }

    private InclusionFilterElement getInclusionFilterElement(InclusionFilter inclusionFilter) {
        InclusionFilterElement element = null;
        if (inclusionFilter != null) {
            element = new InclusionFilterElement();
            element.setFilterName(inclusionFilter.getFilterName());
            element.setFilters(inclusionFilter.getExtensionName());
        }
        return element;
    }

    private FilterTemplateElement getFilterTempletElement(FilterTemplate filter) {
        FilterTemplateElement element = new FilterTemplateElement();
        element.setFilterName(filter.getFilterName());
        element.setExtensionName(filter.getExtensionName());
        return element;
    }
}

