/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.CalloutScriptService;
import com.parablu.paracloud.element.CalloutScriptElement;
import com.parablu.pcbd.dao.CalloutScriptDao;
import com.parablu.pcbd.domain.CalloutScript;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CalloutScriptServiceImpl
implements CalloutScriptService {
    @Resource
    private CalloutScriptDao calloutScriptDao;

    @Override
    public void saveCalloutScript(int cloudId, String cloudName, CalloutScriptElement calloutScriptElement) {
        CalloutScript calloutScript = new CalloutScript();
        calloutScript.setScriptName(calloutScriptElement.getScriptName());
        calloutScript.setScriptArgs(calloutScriptElement.getScriptArgs());
        calloutScript.setScriptType(calloutScriptElement.getScriptType());
        this.createOrEdit(cloudId, cloudName, calloutScriptElement, calloutScript);
    }

    private void createOrEdit(int cloudId, String cloudName, CalloutScriptElement calloutScriptElement, CalloutScript calloutScript) {
        CalloutScript existingCalloutScript = this.calloutScriptDao.getCalloutScript(cloudId, cloudName, calloutScriptElement.getScriptName(), null);
        if (existingCalloutScript != null) {
            ObjectId id = existingCalloutScript.getId();
            BeanUtils.copyProperties((Object)calloutScript, (Object)existingCalloutScript);
            existingCalloutScript.setId(id);
            this.calloutScriptDao.saveCalloutScript(cloudId, cloudName, existingCalloutScript);
        } else {
            this.calloutScriptDao.saveCalloutScript(cloudId, cloudName, calloutScript);
        }
    }

    @Override
    public CalloutScriptElement getCalloutScript(int cloudId, String cloudName, String folderPath, List<String> argsList) {
        CalloutScript calloutScript = this.calloutScriptDao.getCalloutScript(cloudId, cloudName, folderPath, argsList);
        return this.getCalloutScriptElement(calloutScript);
    }

    @Override
    public List<CalloutScriptElement> getAllCalloutScripts(int cloudId, String cloudName) {
        List calloutScriptList = this.calloutScriptDao.getAllCalloutScript(cloudId, cloudName);
        ArrayList<CalloutScriptElement> elements = new ArrayList<CalloutScriptElement>();
        for (CalloutScript calloutScript : calloutScriptList) {
            CalloutScriptElement element = this.getCalloutScriptElement(calloutScript);
            elements.add(element);
        }
        return elements;
    }

    private CalloutScriptElement getCalloutScriptElement(CalloutScript calloutScript) {
        CalloutScriptElement element = null;
        if (calloutScript != null) {
            element = new CalloutScriptElement();
            element.setScriptName(calloutScript.getScriptName());
            element.setScriptArgs(calloutScript.getScriptArgs());
            element.setScriptType(calloutScript.getScriptType());
        }
        return element;
    }
}

