/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveSearchParameterSet;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveCollectionPage;
import com.microsoft.graph.requests.DriveCollectionRequest;
import com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.DriveSearchCollectionPage;
import com.microsoft.graph.requests.DriveSearchCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.pg.controller.Graph;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import okhttp3.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicStatusLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Office365DownloadServiceImplDataTest {
    private static final String BEARER = "Bearer ";
    private HttpResponse result;
    private PciAuthorizationTokenElement authorizationTokenElement;
    private String deviceUUID;
    private String downloadUrl;
    private String proxyUserName;
    private String password;
    private String host;
    private int port;
    private String driveId;
    private static GraphServiceClient graphClient;
    private static Logger logger;

    public Office365DownloadServiceImplDataTest(String proxyUserName, String password, String host, int port) {
        this.proxyUserName = proxyUserName;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public Office365DownloadServiceImplDataTest() {
    }

    public static void main(String[] args) throws IOException {
        Office365DownloadServiceImplDataTest.searchItem();
    }

    protected HttpResponse executeDownload() throws ClientProtocolException, IOException {
        logger.debug(" ............new path................." + this.downloadUrl);
        HttpGet httpGet = new HttpGet(this.downloadUrl);
        httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
            logger.debug(" without proxy ....");
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            this.result = httpclient.execute((HttpUriRequest)httpGet);
        } else {
            logger.debug(" using proxy ....");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpHost proxy = new HttpHost(this.host, this.port);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            httpGet.setConfig(config);
            this.result = httpclient.execute((HttpUriRequest)httpGet);
        }
        logger.debug(this.result.getStatusLine().getReasonPhrase() + "...Inside execute..." + this.result.getStatusLine().getStatusCode());
        return this.result;
    }

    protected HttpResponse executeDownloadUsingGraph() throws IOException, ClientProtocolException {
        try {
            HttpGet httpGet = new HttpGet(this.downloadUrl);
            httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
                logger.debug(" without proxy ....");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                this.result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ....");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(this.host, this.port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                this.result = httpclient.execute((HttpUriRequest)httpGet);
            }
            logger.debug(this.result.getStatusLine().getReasonPhrase() + "...Inside execute..." + this.result.getStatusLine().getStatusCode());
        }
        catch (GraphServiceException e) {
            logger.error("... failed graph exception ... " + e.getResponseCode());
            DefaultHttpResponseFactory factory = new DefaultHttpResponseFactory();
            this.result = factory.newHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, e.getResponseCode(), null), null);
        }
        return this.result;
    }

    public static void searchItem() throws IOException {
        block4: {
            String driveId = "";
            String id = "";
            try {
                User user = graphClient.users("praveen@parablu.com").buildRequest(new Option[0]).get();
                Drive drive = graphClient.users("praveen@parablu.com").drive().buildRequest(new Option[0]).get();
                String mysite = user.mySite;
                long totalStorage = drive.quota.total;
                DriveSearchParameterSet searchset = new DriveSearchParameterSet();
                searchset.q = "+jUhe8ac+11OFD3VIkXp8Q";
                DriveSearchCollectionPage search = (DriveSearchCollectionPage)((DriveSearchCollectionRequest)((DriveRequestBuilder)graphClient.users("samis@testpara.onmicrosoft.com").drives().byId("b!cojjwYW6I06HL4g7EaVDWXJ6poHprAZGmVW0O5eTNxR1lU0yD4W4SJO1-L7UUcqk")).search(searchset).buildRequest(new Option[0])).get();
                if (search == null) {
                    System.out.println("Search object is null...");
                    return;
                }
                String itemId = "";
                for (DriveItem driveItem : search.getCurrentPage()) {
                    System.out.println(driveItem.id + "..." + driveItem.name);
                    itemId = driveItem.id;
                }
                System.out.println("search result:" + itemId);
                System.out.println("driveId:" + driveId + " Item id:" + id);
                InputStream stream = graphClient.drives(driveId).items(itemId).content().buildRequest(new Option[0]).get();
                System.out.println("stream...." + stream.available());
                String text = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
                System.out.println("text...." + text);
            }
            catch (GraphServiceException e) {
                System.out.println("exception...." + e.getMessage());
                if (e.getResponseCode() != 401) break block4;
                System.out.println("un authorized........");
            }
        }
    }

    public String getPBFolderItemId() {
        String pbFolderItemId = "";
        try {
            this.getGraphClient();
            UserRequestBuilder users = graphClient.users(this.authorizationTokenElement.getAccountId());
            DriveCollectionRequestBuilder drives = users.drives();
            DriveCollectionRequest buildRequests = (DriveCollectionRequest)drives.buildRequest(new Option[0]);
            DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!Office365DownloadServiceImplDataTest.isPBDrive(drive.webUrl)) continue;
                this.driveId = pbFolderItemId = drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                pbFolderItemId = "401";
            }
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        logger.debug("driveId:" + this.driveId);
        return pbFolderItemId;
    }

    private GraphServiceClient<Request> getGraphClient() {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }

    private static boolean isPBDrive(String webUrl) {
        boolean pbDrive = false;
        try {
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    public HttpResponse getResult() {
        return this.result;
    }

    public void setResult(HttpResponse result) {
        this.result = result;
    }

    public PciAuthorizationTokenElement getToken() {
        return this.authorizationTokenElement;
    }

    public void setToken(PciAuthorizationTokenElement authorizationTokenElement) {
        this.authorizationTokenElement = authorizationTokenElement;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    static {
        logger = LogManager.getLogger(Office365DownloadServiceImplDataTest.class);
    }
}

