/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.parablu.model.BackBlazeAuthorizeElement;
import com.parablu.model.BackBlazeBucket;
import com.parablu.model.BackBlazeBuckets;
import com.parablu.model.BackBlazeUploadInfo;
import com.pg.helper.constant.PCHelperConstant;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class BackBlazeUtil {
    final String AUTHORIZEACCOUNT = "https://api.backblazeb2.com/b2api/v2/b2_authorize_account";
    private static BackBlazeUtil singleton = new BackBlazeUtil();
    private static Logger logger = LogManager.getLogger(BackBlazeUtil.class);

    public static BackBlazeUtil getInstance() {
        return singleton;
    }

    public boolean uploadToBlackBlaze(String applicationKeyId, String applicationKey, String bucketName, File file, String folderName) throws Exception {
        String authorizeAcc = this.AuthorizeAcc(applicationKeyId, applicationKey);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        BackBlazeAuthorizeElement authorize = (BackBlazeAuthorizeElement)mapper.readValue(authorizeAcc, BackBlazeAuthorizeElement.class);
        String bucketList = this.getBucketList(authorize.getApiUrl(), applicationKeyId, authorize.getAuthorizationToken());
        BackBlazeBuckets aadUserElement = (BackBlazeBuckets)mapper.readValue(bucketList, BackBlazeBuckets.class);
        BackBlazeBucket orElse = aadUserElement.getBuckets().stream().filter(buck -> buck.getBucketName().equalsIgnoreCase(bucketName)).findFirst().orElse(null);
        String uploadResult = "";
        if (orElse != null) {
            String uploadURL = this.getUploadURL(authorize.getApiUrl(), authorize.getAuthorizationToken(), orElse.getBucketId());
            BackBlazeUploadInfo backBlazeUploadInfo = (BackBlazeUploadInfo)mapper.readValue(uploadURL, BackBlazeUploadInfo.class);
            uploadResult = this.upload(backBlazeUploadInfo.getUploadUrl(), backBlazeUploadInfo.getAuthorizationToken(), file.getName(), file, folderName);
        }
        boolean result = false;
        if (!StringUtils.isEmpty((Object)uploadResult)) {
            result = true;
        }
        logger.debug("result ......" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String AuthorizeAcc(String applicationKeyId, String applicationKey) {
        HttpURLConnection connection = null;
        String jsonResponse = "";
        logger.debug("..applicationKeyId.." + applicationKeyId);
        logger.debug("..applicationKey.." + applicationKey);
        String headerForAuthorizeAccount = "Basic " + Base64.getEncoder().encodeToString((applicationKeyId + ":" + applicationKey).getBytes());
        try {
            URL url = new URL("https://api.backblazeb2.com/b2api/v2/b2_authorize_account");
            Proxy proxy = this.getProxy();
            connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            logger.debug("URL :" + url);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", headerForAuthorizeAccount);
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            jsonResponse = this.myInputStreamReader(in);
            logger.debug(jsonResponse);
        }
        catch (Exception e) {
            logger.debug("Exception :", (Throwable)e);
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upload(String uploadUrl, String uploadAuthorizationToken, String fileName, File file, String folderName) throws Exception {
        String jsonResponse = "";
        String sha1 = this.createSha1(file);
        HttpURLConnection connection = null;
        try {
            int buff;
            URL url = new URL(uploadUrl);
            Proxy proxy = this.getProxy();
            connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            logger.debug("URL :" + url);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", uploadAuthorizationToken);
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            connection.setRequestProperty("X-Bz-File-Name", folderName + "/" + fileName);
            connection.setRequestProperty("X-Bz-Content-Sha1", sha1);
            connection.setDoOutput(true);
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            byte[] b = new byte[8192];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                connection.getOutputStream().write(b, 0, buff);
                connection.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            jsonResponse = this.myInputStreamReader(connection.getInputStream());
            logger.debug(jsonResponse);
        }
        catch (Exception e) {
            logger.debug("Exception :", (Throwable)e);
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    public String createSha1(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        FileInputStream fis = new FileInputStream(file);
        int n = 0;
        byte[] buffer = new byte[8192];
        while (n != -1) {
            n = ((InputStream)fis).read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        return new HexBinaryAdapter().marshal(digest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBucketList(String apiUrl, String accountId, String accountAuthorizationToken) throws IOException {
        HttpURLConnection connection = null;
        String result = "";
        try {
            URL url = new URL(apiUrl + "/b2api/v2/b2_list_buckets");
            Proxy proxy = this.getProxy();
            connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            logger.debug("URL :" + url);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", accountAuthorizationToken);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            String json = "{\"accountId\":\"" + accountId + "\", \"bucketTypes\": [\"allPrivate\",\"allPublic\"]}";
            byte[] postData = json.getBytes(StandardCharsets.UTF_8);
            logger.debug(json);
            connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
            connection.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
            writer.write(postData);
            result = this.myInputStreamReader(connection.getInputStream());
            connection.getResponseMessage();
        }
        catch (Exception e) {
            logger.error(connection.getResponseMessage() + "...Exception :" + e.getMessage());
        }
        finally {
            connection.disconnect();
        }
        return result;
    }

    public String myInputStreamReader(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        int c = reader.read();
        while (c != -1) {
            sb.append((char)c);
            c = reader.read();
        }
        reader.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUploadURL(String apiUrl, String accountAuthorizationToken, String bucketId) {
        HttpURLConnection connection = null;
        String result = "";
        String postParams = "{\"bucketId\":\"" + bucketId + "\"}";
        byte[] postData = postParams.getBytes(StandardCharsets.UTF_8);
        try {
            URL url = new URL(apiUrl + "/b2api/v2/b2_get_upload_url");
            Proxy proxy = this.getProxy();
            connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            logger.debug("URL :" + url);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", accountAuthorizationToken);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
            connection.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
            writer.write(postData);
            result = this.myInputStreamReader(connection.getInputStream());
            logger.debug(result);
        }
        catch (Exception e) {
            logger.error("...Exception :" + e.getMessage());
        }
        finally {
            connection.disconnect();
        }
        return result;
    }

    private Proxy getProxy() {
        final String proxyUserName = PCHelperConstant.getProxyUserName();
        final String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        if (StringUtils.isEmpty((Object)host) || port <= 0) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)proxyUserName) && !StringUtils.isEmpty((Object)password)) {
            Authenticator authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUserName, password.toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }
}

