/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.UserBackupPolicyMappingService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceBackupElement;
import com.parablu.paracloud.element.PolicyMappingElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.paracloud.element.bp.UserBackupPolicyMappingElement;
import com.parablu.paracloud.element.bp.UserPolicyMappingElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserBackupPolicyMappingServiceImpl
implements UserBackupPolicyMappingService {
    private static Logger logger = LogManager.getLogger(UserBackupPolicyMappingServiceImpl.class);
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private SyncPolicyDao syncPolicyDao;
    @Resource
    private UserDao userDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private OfficeBackupPolicyDao oneDriveBackupPolicyDao;
    private static final String EXCEPTION = " Exception  :";

    @Override
    public void saveUserBackupPolicyMapping(int cloudId, String cloudName, DeviceBackupElement deviceBackupElement) {
        String backupPolicyName = deviceBackupElement.getBackupPolicyName();
        String userName = deviceBackupElement.getUserName();
        this.savePolicyMapping(cloudId, cloudName, backupPolicyName, userName, "", "backupPolicy", "");
    }

    private String savePolicyMapping(int cloudId, String cloudName, String newpolicyName, String userName, String unAssignedUsers1, String policyType, String loginUserName) {
        User loginUser;
        String unAssignedUsers = unAssignedUsers1;
        ArrayList<String> failedUserNames = new ArrayList<String>();
        ArrayList policyMappingElement = new ArrayList();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (StringUtils.isNotEmpty((String)loginUserName) && user != null && (loginUser = this.userDao.getUserByName(cloudId, loginUserName)) != null && loginUser.isReadOnlyAdmin()) {
            if ("backupPolicy".equalsIgnoreCase(policyType) && !loginUser.getBackupPoliciesAdmin().contains(user.getPolicyName())) {
                logger.debug(" user does not exist .... " + userName);
                unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
                return unAssignedUsers;
            }
            if (!loginUser.getSyncPoliciesAdmin().contains(user.getSyncPolicyName())) {
                logger.debug(" user does not exist .... " + userName);
                unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
                return unAssignedUsers;
            }
        }
        if (user != null) {
            userName = user.getUserName();
            BackupPolicy backupPolicy = null;
            SyncPolicy syncPolicy = null;
            logger.debug("policy type:" + policyType);
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, newpolicyName);
                if (backupPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                    user.setAdmin(false);
                    this.userDao.saveUser(cloudId, cloudName, user);
                    this.deviceDao.updatePolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
                }
            } else {
                syncPolicy = this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, newpolicyName);
            }
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                this.userDao.updateUserPolicy(cloudId, newpolicyName, user.getUserId(), "backupPolicy", backupPolicy.getLastModifiedTimestamp());
                this.deviceDao.updatePolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
            } else {
                this.userDao.updateUserPolicy(cloudId, newpolicyName, user.getUserId(), "syncPolicy", syncPolicy.getLastModifiedTimestamp());
            }
        } else {
            logger.debug(" user does not exist .... " + userName);
            unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
        }
        if (!StringUtils.isEmpty((String)unAssignedUsers)) {
            System.out.println(unAssignedUsers);
            failedUserNames.addAll(Arrays.asList(unAssignedUsers.split(",")));
            logger.debug("failedUserNames.." + failedUserNames.size());
            this.createUsersExcelMappingFail(cloudId, failedUserNames);
        }
        return unAssignedUsers;
    }

    @Override
    public Boolean isPolicyModified(int cloudId, String cloudName, String userName, Long lastModifiedTimeVal) {
        boolean isPolicyModified = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
            long policyModifiedTime;
            long userPolicyModifiedTime = user.getPolicyModifiedTime();
            BackupPolicy bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
            if (bkpPolicy != null && (policyModifiedTime = bkpPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                isPolicyModified = true;
                return isPolicyModified;
            }
        }
        return isPolicyModified;
    }

    @Override
    public boolean isUserPolicyMapped(int cloudId, String cloudName, String userName, String policyType) {
        logger.debug("policy type:" + policyType);
        boolean isPolicyModified = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
                long policyModifiedTime;
                long userPolicyModifiedTime = user.getPolicyModifiedTime();
                BackupPolicy bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
                if (bkpPolicy != null && (policyModifiedTime = bkpPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                    isPolicyModified = true;
                    return isPolicyModified;
                }
            }
        } else if (user != null && !StringUtils.isEmpty((String)user.getSyncPolicyName())) {
            long policyModifiedTime;
            long userPolicyModifiedTime = user.getSyncPolicyModifiedTime();
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
            if (syncPolicy != null && (policyModifiedTime = syncPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                isPolicyModified = true;
                return isPolicyModified;
            }
        }
        return isPolicyModified;
    }

    private void createUsersExcelMappingFailNew(int cloudId, List<PolicyMappingElement> policyMappingElementList) {
        if (!CollectionUtils.isEmpty(policyMappingElementList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForMappingFailNew(policyMappingElementList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsxForBlackFail(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateUserElementValuesToExcelForMappingFailNew(List<PolicyMappingElement> policyMappingElementList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (PolicyMappingElement userElement : policyMappingElementList) {
            recordToAdd.add(this.loadDataOnRowForUserXlsxForMappingFail(userElement));
        }
        return recordToAdd;
    }

    List<String> loadDataOnRowForUserXlsxForMappingFail(PolicyMappingElement userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getUserName());
        firstRow.add(userElement.getPolicyName());
        firstRow.add(userElement.getReason());
        return firstRow;
    }

    @Override
    public List<UserBackupPolicyMappingElement> loadAllUserBackupPolicyMappingElements(int cloudId, String cloudName, String policyType) {
        String userName;
        UserBackupPolicyMappingElement element;
        boolean site = false;
        if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            site = true;
        }
        List users = this.userDao.getAllUsers(cloudId, cloudName, site);
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        for (User user : users) {
            element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                element.setBackupPolicyName(user.getPolicyName());
            } else {
                element.setSyncPolicyName(user.getSyncPolicyName());
            }
            userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
            this.removeAlreadyMappedUsers(users, userName);
        }
        for (User user : users) {
            element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                element.setBackupPolicyName("");
            } else {
                element.setSyncPolicyName("");
            }
            userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        return elements;
    }

    private void removeAlreadyMappedUsers(List<User> users, String userName) {
        boolean userAlreadyMapped = false;
        User alreadyMappedUser = null;
        for (User user : users) {
            if (!user.getUserName().equals(userName)) continue;
            userAlreadyMapped = true;
            alreadyMappedUser = user;
        }
        if (userAlreadyMapped) {
            users.remove(alreadyMappedUser);
        }
    }

    @Override
    public void saveUserPolicyMapping(int cloudId, String cloudName, String userName, String newPolicyName, String loginUserName, String policyType, int actionType) {
        String productType = this.mapPolicyTypeToProduct(policyType);
        this.savePolicyMapping(cloudId, cloudName, newPolicyName, userName, "", policyType, loginUserName);
        this.saveStatisticToDatabase(cloudId, cloudName, "assigned " + newPolicyName + productType + " Policy to ", loginUserName, userName, actionType);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public EditUserBackupPolicyMappingElement getPolicyElements(int cloudId, int skipValue, int recordsCount, String policyType, User adminUser) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List userList = new ArrayList();
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        if (adminUser != null && adminUser.isReadOnlyAdmin()) {
            ArrayList policyNames = new ArrayList();
            ArrayList syncPolicyNames = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)adminUser.getBackupPoliciesAdmin())) {
                policyNames.addAll(adminUser.getBackupPoliciesAdmin());
            }
            if (!CollectionUtils.isEmpty((Collection)adminUser.getSyncPoliciesAdmin())) {
                syncPolicyNames.addAll(adminUser.getSyncPoliciesAdmin());
            }
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                userList = this.userDao.getAllUsersByPolicyNames(cloudId, (List)policyNames, false, skipValue, recordsCount);
            } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
                userList = this.userDao.getAllUsersBySyncPolicyNames(cloudId, syncPolicyNames, skipValue, recordsCount);
            }
        } else if ("backupPolicy".equalsIgnoreCase(policyType)) {
            userList = this.userDao.getAllUsers(cloudId, true, false, false, skipValue);
        } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
            userList = this.userDao.getAllActiveUsers(cloudId, skipValue);
        }
        logger.debug(" ....USER BP mapping size  ..." + userList.size());
        for (User user : userList) {
            if (user == null || !user.isActive()) continue;
            String policyName = "";
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                policyName = user.getPolicyName();
                element.setBackupPolicyName(policyName);
            } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
                policyName = user.getSyncPolicyName();
                element.setSyncPolicyName(policyName);
            }
            String userName = user.getUserName();
            element.setUserName(userName);
            logger.debug(policyName + " ....USER AND BP ..." + userName);
            elements.add(element);
        }
        List policyNamesList = "backupPolicy".equalsIgnoreCase(policyType) ? this.backupPolicyDao.getAllBackupPolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()) : ("syncPolicy".equalsIgnoreCase(policyType) ? this.syncPolicyDao.getAllSyncPolicy(cloudId, "").stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()) : this.backupPolicyDao.getAllOfficePolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(policyNamesList)) {
            policyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(policyNamesList);
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public EditUserBackupPolicyMappingElement getBackupPolicyElements(int cloudId, List<String> userNames, String policyType, User adminUser) {
        List policyNamesList;
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List userList = null;
        List backupPoliciesAdmin = new ArrayList();
        List syncPoliciesAdmin = new ArrayList();
        userList = this.userDao.getAllBackupUsersForNamesForPolicyMap(cloudId, userNames);
        if (adminUser.isReadOnlyAdmin() && "backupPolicy".equalsIgnoreCase(policyType)) {
            userList = this.userDao.getAllUsersForDelegatedAdminWithNamesAndPolicyMap(cloudId, userNames, adminUser.getBackupPoliciesAdmin(), policyType);
        } else if (adminUser.isReadOnlyAdmin() && "syncPolicy".equalsIgnoreCase(policyType)) {
            userList = this.userDao.getAllUsersForDelegatedAdminWithNamesAndPolicyMap(cloudId, userNames, adminUser.getSyncPoliciesAdmin(), policyType);
        }
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        if (userList != null && userList.size() > 0) {
            for (User user : userList) {
                UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
                if ("backupPolicy".equalsIgnoreCase(policyType)) {
                    element.setBackupPolicyName(user.getPolicyName());
                } else {
                    element.setSyncPolicyName(user.getSyncPolicyName());
                }
                String userName = user.getUserName();
                element.setUserName(userName);
                elements.add(element);
            }
        }
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            policyNamesList = this.backupPolicyDao.getAllBackupPolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
            if (adminUser.isReadOnlyAdmin()) {
                if (adminUser.getBackupPoliciesAdmin() != null) {
                    backupPoliciesAdmin = adminUser.getBackupPoliciesAdmin();
                }
                policyNamesList = this.backupPolicyDao.getAllBackupPoliciesByPagination(cloudId, backupPoliciesAdmin, 0).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
            }
        } else {
            policyNamesList = this.syncPolicyDao.getAllSyncPolicy(cloudId, "").stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
            if (adminUser.isReadOnlyAdmin()) {
                if (adminUser.getSyncPoliciesAdmin() != null) {
                    syncPoliciesAdmin = adminUser.getSyncPoliciesAdmin();
                }
                policyNamesList = this.syncPolicyDao.getAllSyncPoliciesWithPagination(cloudId, syncPoliciesAdmin, 0).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(policyNamesList)) {
            policyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(policyNamesList);
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public List<PolicyMappingElement> updateUserPolicys(int cloudId, List<PolicyMappingElement> list, String loginUserName, String policyType, int actionType) {
        ArrayList<PolicyMappingElement> PolicyMappingElementList = new ArrayList();
        PolicyMappingElementList = this.savePolicyMappingNew(cloudId, "", list, policyType, actionType, loginUserName);
        return PolicyMappingElementList;
    }

    @Override
    public String updateUserPolicysOld(int cloudId, List<String> list, String policyName, String loginUserName, String policyType, int actionType) {
        String unAssignedUsers = "";
        for (String userName : list) {
            String productType = this.mapPolicyTypeToProduct(policyType);
            unAssignedUsers = this.savePolicyMapping(cloudId, "", policyName, userName, unAssignedUsers, policyType, loginUserName);
            this.saveStatisticToDatabase(cloudId, "", "assigned " + policyName + productType + " Policy to ", loginUserName, userName, actionType);
        }
        return unAssignedUsers;
    }

    @Override
    public EditUserBackupPolicyMappingElement getODBPolicyElements(int cloudId, int skipValue, int recordsCount, User logedInUser, String policyType) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List list = new ArrayList();
        list = logedInUser != null && logedInUser.isReadOnlyAdmin() ? this.userDao.getAllUsersByPolicyNamesAndPolicyType(cloudId, logedInUser.getOdbPoliciesAdmin(), true, skipValue, recordsCount, policyType) : this.userDao.getAllUsersByPolicyType(cloudId, false, false, true, skipValue, policyType);
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList();
        }
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        logger.debug(skipValue + " ....USER BP mapping size  ..." + list.size());
        for (User user : list) {
            String userName;
            UserBackupPolicyMappingElement element;
            String policyName;
            if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType) && user.isOnedriveBkpEnabled()) {
                policyName = "";
                if (!StringUtils.isEmpty((String)user.getOneDrivePolicyName())) {
                    policyName = user.getOneDrivePolicyName();
                }
                element = new UserBackupPolicyMappingElement();
                element.setOneDrivePolicyName(policyName);
                userName = user.getUserName();
                element.setUserName(userName);
                elements.add(element);
            }
            if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType) && user.isExchangeBkpEnabled()) {
                policyName = "";
                if (!StringUtils.isEmpty((String)user.getExchangePolicyName())) {
                    policyName = user.getExchangePolicyName();
                }
                element = new UserBackupPolicyMappingElement();
                element.setExchangePolicyName(policyName);
                userName = user.getUserName();
                element.setUserName(userName);
                elements.add(element);
            }
            if (!OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType) || !user.isSite()) continue;
            policyName = "";
            if (!StringUtils.isEmpty((String)user.getSpPolicyName())) {
                policyName = user.getSpPolicyName();
            }
            element = new UserBackupPolicyMappingElement();
            element.setSpPolicyName(policyName);
            userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        List allOneDriveBackupPolicies = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId, policyType);
        List backupPolicyNamesList = null;
        if (logedInUser.isAdmin()) {
            backupPolicyNamesList = allOneDriveBackupPolicies.stream().filter(odbPolicy -> Objects.nonNull(odbPolicy.getPolicyName())).map(odbPolicy -> odbPolicy.getPolicyName()).collect(Collectors.toList());
        }
        if (logedInUser.isReadOnlyAdmin()) {
            if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
                backupPolicyNamesList = logedInUser.getOdbPoliciesAdmin().stream().filter(exchangePolicyName -> exchangePolicyName.startsWith("EX_")).collect(Collectors.toList());
            } else if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
                backupPolicyNamesList = logedInUser.getOdbPoliciesAdmin().stream().filter(odbPolicyName -> odbPolicyName.startsWith("ODB_")).collect(Collectors.toList());
            } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                backupPolicyNamesList = logedInUser.getOdbPoliciesAdmin().stream().filter(sharePointPolicyName -> sharePointPolicyName.startsWith("SP_")).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(backupPolicyNamesList)) {
            backupPolicyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(backupPolicyNamesList);
        logger.debug(elements.size() + "....total odb policy list... " + backupPolicyNamesList.size());
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public void saveODBUserPolicyMapping(int cloudId, String userName, String newPolicyName, String loginUserName, String policyType, int actionTypeValue) {
        String productType = this.mapPolicyTypeToProduct(policyType);
        this.saveODBPolicyMapping(cloudId, newPolicyName, userName, policyType);
        this.saveStatisticToDatabase(cloudId, "", "assigned " + newPolicyName + productType + " Policy to ", loginUserName, userName, actionTypeValue);
    }

    private String saveODBPolicyMapping(int cloudId, String newpolicyName, String userName, String policyType) {
        User user = this.userDao.getUserInfoByName(cloudId, "", userName);
        String oldPolicyName = "";
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            oldPolicyName = user.getOneDrivePolicyName();
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            oldPolicyName = user.getExchangePolicyName();
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            oldPolicyName = user.getSpPolicyName();
        }
        if (user != null) {
            this.userDao.updateODBUserPolicy(cloudId, newpolicyName, userName, policyType);
            this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName, policyType);
            this.userDao.checkandChangePolicyRelatedBackup(oldPolicyName, newpolicyName, userName);
        } else {
            logger.debug(" user does not exist .... " + userName);
        }
        return "";
    }

    @Override
    public List<PolicyMappingElement> updateUserODBPolicys(int cloudId, List<PolicyMappingElement> list, String loginUserName, String policyType, int actionType) {
        ArrayList<PolicyMappingElement> PolicyMappingElementList = new ArrayList();
        PolicyMappingElementList = this.saveODBUserPolicyMapping(cloudId, "", list, policyType, actionType, loginUserName);
        return PolicyMappingElementList;
    }

    private List<PolicyMappingElement> saveODBUserPolicyMapping(int cloudId, String cloudName, List<PolicyMappingElement> list, String policyType, int actionType, String loginUserName) {
        ArrayList<PolicyMappingElement> policyMappingElement = new ArrayList<PolicyMappingElement>();
        for (PolicyMappingElement pmElement : list) {
            String userName = pmElement.getUserName();
            String newpolicyName = pmElement.getPolicyName();
            userName = userName.trim();
            newpolicyName = newpolicyName.trim();
            User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
            if (user != null) {
                userName = user.getUserName();
                OfficeBackupPolicy odbPolicy = null;
                logger.debug("policy type:" + policyType);
                if (StringUtils.isEmpty((String)policyType)) continue;
                odbPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, newpolicyName, policyType);
                if (odbPolicy != null) {
                    if (odbPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                        user.setAdmin(false);
                        this.userDao.saveUser(cloudId, cloudName, user);
                    }
                    String productType = this.mapPolicyTypeToProduct(policyType);
                    this.userDao.updateODBUserPolicy(cloudId, newpolicyName, user.getUserId(), policyType, odbPolicy.getLastModifiedTimestamp());
                    this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName, policyType);
                    String oldPolicyName = user.getPolicyName();
                    if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
                        oldPolicyName = user.getOneDrivePolicyName();
                    } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
                        oldPolicyName = user.getExchangePolicyName();
                    } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                        oldPolicyName = user.getSpPolicyName();
                    }
                    logger.debug(oldPolicyName + "...policy type:" + policyType);
                    this.userDao.checkandChangePolicyRelatedBackup(oldPolicyName, newpolicyName, userName);
                    this.saveStatisticToDatabase(cloudId, "", "assigned " + newpolicyName + productType + " Policy to ", loginUserName, userName, actionType);
                    continue;
                }
                this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                continue;
            }
            PolicyMappingElement failedPolicyMappingElement = new PolicyMappingElement();
            failedPolicyMappingElement.setPolicyName(newpolicyName);
            failedPolicyMappingElement.setUserName(userName);
            failedPolicyMappingElement.setReason("User not found");
            policyMappingElement.add(failedPolicyMappingElement);
            logger.debug(" user does not exist .... " + userName);
        }
        if (!CollectionUtils.isEmpty(policyMappingElement)) {
            logger.debug(" failed policyMappingElement  is not empty.." + policyMappingElement.size());
            this.createUsersExcelMappingFailNew(cloudId, policyMappingElement);
        }
        return policyMappingElement;
    }

    @Override
    public String updateUserODBPolicysOld(int cloudId, List<String> list, String policyName, String loginUserName, String policyType, int actionType) {
        String unAssignedUsers = "";
        for (String userName : list) {
            String productType = this.mapPolicyTypeToProduct(policyType);
            unAssignedUsers = this.saveODBUserPolicyMappingOld(cloudId, "", policyName, userName, unAssignedUsers, policyType, loginUserName);
            this.saveStatisticToDatabase(cloudId, "", "assigned " + policyName + productType + " Policy to ", loginUserName, userName, actionType);
        }
        return unAssignedUsers;
    }

    private String saveODBUserPolicyMappingOld(int cloudId, String cloudName, String newpolicyName, String userName, String unAssignedUsers1, String policyType, String loginUserName) {
        User loginUser;
        String unAssignedUsers = unAssignedUsers1;
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (StringUtils.isNotEmpty((String)loginUserName) && user != null && (loginUser = this.userDao.getUserByName(cloudId, loginUserName)) != null && loginUser.isReadOnlyAdmin() && !loginUser.getOdbPoliciesAdmin().contains(user.getExchangePolicyName()) && !loginUser.getOdbPoliciesAdmin().contains(user.getOneDrivePolicyName()) && !loginUser.getOdbPoliciesAdmin().contains(user.getSpPolicyName())) {
            logger.debug(" user does not exist .... " + userName);
            unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
        }
        if (user != null) {
            userName = user.getUserName();
            OfficeBackupPolicy odbPolicy = null;
            String oldPolicyName = user.getPolicyName();
            if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
                oldPolicyName = user.getOneDrivePolicyName();
            } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
                oldPolicyName = user.getExchangePolicyName();
            } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                oldPolicyName = user.getSpPolicyName();
            }
            logger.debug(oldPolicyName + "...policy type:" + policyType);
            if (!StringUtils.isEmpty((String)policyType)) {
                odbPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, newpolicyName, policyType);
                if (odbPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                    user.setAdmin(false);
                    this.userDao.saveUser(cloudId, cloudName, user);
                }
                this.userDao.updateODBUserPolicy(cloudId, newpolicyName, user.getUserName(), policyType);
                this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName, policyType);
                this.userDao.checkandChangePolicyRelatedBackup(oldPolicyName, newpolicyName, userName);
            }
        } else {
            logger.debug(" user does not exist .... " + userName);
            unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
        }
        return unAssignedUsers;
    }

    private void createUsersExcelMappingFail(int cloudId, List<String> userList) {
        if (!CollectionUtils.isEmpty(userList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForMappingFail(userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsxForBlackFail(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    void writeExcelForUserXlsxForBlackFail(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Users_Policy_Mapping_Fail.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private List<List> updateUserElementValuesToExcelForMappingFail(List<String> userList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (String userElement : userList) {
            recordToAdd.add(this.loadDataOnRowForUserXlsxForMappingFail(userElement));
        }
        return recordToAdd;
    }

    void createExcelForUserXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    List<String> createHeaderRowForUserXlsxForBlockFail() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Policy Name");
        headerRow.add("Reason");
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsxForMappingFail(String userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement);
        firstRow.add("Invalid User");
        return firstRow;
    }

    private boolean isSyncEnabledForCloud(Cloud cloud) {
        boolean isSyncEnabled = false;
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"Sync Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSyncEnabled = true;
                break;
            }
        }
        return isSyncEnabled;
    }

    @Override
    public long getTotalMapping(Cloud cloud, String backupPolicy, String policyType) {
        int cloudId = cloud.getCloudId();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            return this.userDao.countOfPresentODBBackupUsers(cloudId, "", true);
        }
        if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            return this.userDao.countOfPresentODBBackupUsers(cloudId, "", true);
        }
        if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            return this.userDao.countOfPresentODBBackupUsers(cloudId, "", true);
        }
        if (backupPolicy.equalsIgnoreCase("backupPolicy")) {
            return this.userDao.countOfPresentBackupUsers(cloudId, "", true, true);
        }
        if (backupPolicy.equalsIgnoreCase("syncPolicy")) {
            boolean isSyncEnabledForCloud = this.isSyncEnabledForCloud(cloud);
            long noOfUsers = isSyncEnabledForCloud ? this.userDao.countOfPresentUsers(cloudId, cloud.getCloudName(), true) : this.userDao.countOfPresentSyncUsers(1, "", true);
            return noOfUsers;
        }
        if (backupPolicy.equalsIgnoreCase("OFFICE_POLICY")) {
            return this.userDao.countOfPresentODBBackupUsers(cloudId, "", true);
        }
        return 0L;
    }

    @Override
    public long loadAllSyncPoliciesMappingCount(int cloudId, List<String> policyNames) {
        return this.userDao.loadAllSyncPoliciesMappingCount(cloudId, policyNames);
    }

    @Override
    public List<UserPolicyMappingElement> getPolicyMappingElements(int cloudId, String cloudName) {
        List backupPolicyList = this.backupPolicyDao.loadAllBackupPolicies(cloudId);
        ArrayList<UserPolicyMappingElement> userPolicyMappingElementList = new ArrayList<UserPolicyMappingElement>();
        for (Object backupPolicy : backupPolicyList) {
            List users;
            if (backupPolicy == null || (users = this.userDao.getBackupPolicyMappedUserSbyPolicyName(cloudId, backupPolicy.getPolicyName())).isEmpty()) continue;
            List userNamesList = users.stream().filter(user -> Objects.nonNull(user.getUserName())).map(user -> user.getUserName()).collect(Collectors.toList());
            UserPolicyMappingElement userPolicyMappingElement = new UserPolicyMappingElement();
            userPolicyMappingElement.setPolicyName(backupPolicy.getPolicyName());
            userPolicyMappingElement.setUserNames(userNamesList);
            userPolicyMappingElement.setProductType("backup");
            userPolicyMappingElementList.add(userPolicyMappingElement);
        }
        List syncPolicyList = this.syncPolicyDao.getAllSyncPolicy(cloudId, cloudName);
        for (SyncPolicy syncPolicy : syncPolicyList) {
            List users;
            if (syncPolicy == null || (users = this.userDao.getSyncPolicyMappedUsersbyPolicyName(cloudId, syncPolicy.getPolicyName())).isEmpty()) continue;
            List userNamesList = users.stream().filter(user -> Objects.nonNull(user.getUserName())).map(user -> user.getUserName()).collect(Collectors.toList());
            UserPolicyMappingElement userPolicyMappingElement = new UserPolicyMappingElement();
            userPolicyMappingElement.setPolicyName(syncPolicy.getPolicyName());
            userPolicyMappingElement.setUserNames(userNamesList);
            userPolicyMappingElement.setProductType("sync");
            userPolicyMappingElementList.add(userPolicyMappingElement);
        }
        List officePolicyList = this.backupPolicyDao.getAllOfficePolicies(cloudId);
        for (OfficeBackupPolicy officePolicy : officePolicyList) {
            if (officePolicy == null) continue;
            ArrayList<String> policylist = new ArrayList<String>();
            policylist.add(officePolicy.getPolicyName());
            List userNamesList = this.userDao.getUserNamesByOfficePoliciesAdmin(cloudId, policylist);
            if (userNamesList.isEmpty()) continue;
            UserPolicyMappingElement userPolicyMappingElement = new UserPolicyMappingElement();
            userPolicyMappingElement.setPolicyName(officePolicy.getPolicyName());
            userPolicyMappingElement.setUserNames(userNamesList);
            userPolicyMappingElement.setProductType("office");
            userPolicyMappingElementList.add(userPolicyMappingElement);
        }
        return userPolicyMappingElementList;
    }

    private List<PolicyMappingElement> savePolicyMappingNew(int cloudId, String cloudName, List<PolicyMappingElement> list, String policyType, int actionType, String loginUserName) {
        ArrayList<PolicyMappingElement> policyMappingElement = new ArrayList<PolicyMappingElement>();
        for (PolicyMappingElement pmElement : list) {
            User user;
            String userName = pmElement.getUserName();
            String newpolicyName = pmElement.getPolicyName();
            userName = userName.trim();
            newpolicyName = newpolicyName.trim();
            User loginUser = null;
            if (StringUtils.isNotEmpty((String)loginUserName)) {
                loginUser = this.userDao.getUserByName(cloudId, loginUserName);
            }
            if ((user = this.userDao.getUserInfoByName(cloudId, cloudName, userName)) != null) {
                PolicyMappingElement failedPolicyMappingElement;
                userName = user.getUserName();
                BackupPolicy backupPolicy = null;
                SyncPolicy syncPolicy = null;
                logger.debug("policy type:" + policyType);
                if (StringUtils.isEmpty((String)policyType)) continue;
                if ("backupPolicy".equalsIgnoreCase(policyType)) {
                    backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, newpolicyName);
                    if (backupPolicy != null) {
                        if (loginUser != null && loginUser.isReadOnlyAdmin()) {
                            if (!loginUser.getBackupPoliciesAdmin().contains(user.getPolicyName())) {
                                failedPolicyMappingElement = new PolicyMappingElement();
                                failedPolicyMappingElement.setPolicyName(newpolicyName);
                                failedPolicyMappingElement.setUserName(userName);
                                failedPolicyMappingElement.setReason("User not found");
                                policyMappingElement.add(failedPolicyMappingElement);
                                logger.debug(" user does not exist .... " + userName);
                                continue;
                            }
                            if (!loginUser.getBackupPoliciesAdmin().contains(backupPolicy.getPolicyName())) {
                                this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                                continue;
                            }
                        }
                        if (backupPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                            user.setAdmin(false);
                            this.userDao.saveUser(cloudId, cloudName, user);
                            this.deviceDao.updatePolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
                        }
                        String productType = this.mapPolicyTypeToProduct(policyType);
                        this.userDao.updateUserPolicy(cloudId, newpolicyName, user.getUserId(), "backupPolicy", backupPolicy.getLastModifiedTimestamp());
                        this.deviceDao.updatePolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
                        this.saveStatisticToDatabase(cloudId, "", "assigned " + newpolicyName + productType + " Policy to ", loginUserName, userName, actionType);
                        continue;
                    }
                    this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                    continue;
                }
                if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType) || OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType) || OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                    OfficeBackupPolicy officeBackupPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, newpolicyName, policyType);
                    if (officeBackupPolicy != null) {
                        if (loginUser != null && loginUser.isReadOnlyAdmin()) {
                            if (!(loginUser.getOdbPoliciesAdmin().contains(user.getOneDrivePolicyName()) || loginUser.getOdbPoliciesAdmin().contains(user.getExchangePolicyName()) || loginUser.getOdbPoliciesAdmin().contains(user.getSpPolicyName()))) {
                                PolicyMappingElement failedPolicyMappingElement2 = new PolicyMappingElement();
                                failedPolicyMappingElement2.setPolicyName(newpolicyName);
                                failedPolicyMappingElement2.setUserName(userName);
                                failedPolicyMappingElement2.setReason("User not found");
                                policyMappingElement.add(failedPolicyMappingElement2);
                                logger.debug(" user does not exist .... " + userName);
                                continue;
                            }
                            if (!loginUser.getOdbPoliciesAdmin().contains(officeBackupPolicy.getPolicyName())) {
                                this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                                continue;
                            }
                        }
                        if (officeBackupPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                            user.setAdmin(false);
                            this.userDao.saveUser(cloudId, cloudName, user);
                            this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName, policyType);
                        }
                        this.userDao.updateODBUserPolicy(cloudId, newpolicyName, userName, policyType);
                        this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName, policyType);
                        this.saveStatisticToDatabase(cloudId, "", "assigned " + newpolicyName + " Policy to ", loginUserName, userName, actionType);
                        continue;
                    }
                    this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                    continue;
                }
                if (!"syncPolicy".equalsIgnoreCase(policyType)) continue;
                syncPolicy = this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, newpolicyName);
                if (syncPolicy != null) {
                    if (loginUser != null && loginUser.isReadOnlyAdmin()) {
                        if (!loginUser.getSyncPoliciesAdmin().contains(user.getSyncPolicyName())) {
                            failedPolicyMappingElement = new PolicyMappingElement();
                            failedPolicyMappingElement.setPolicyName(newpolicyName);
                            failedPolicyMappingElement.setUserName(userName);
                            failedPolicyMappingElement.setReason("User not found");
                            policyMappingElement.add(failedPolicyMappingElement);
                            logger.debug(" user does not exist .... " + userName);
                            continue;
                        }
                        if (!loginUser.getSyncPoliciesAdmin().contains(syncPolicy.getPolicyName())) {
                            this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                            continue;
                        }
                    }
                    this.userDao.updateUserPolicy(cloudId, newpolicyName, user.getUserId(), "syncPolicy", syncPolicy.getLastModifiedTimestamp());
                    this.saveStatisticToDatabase(cloudId, "", "assigned " + newpolicyName + " Policy to ", loginUserName, userName, actionType);
                    continue;
                }
                this.setPolicyNotFound(policyMappingElement, userName, newpolicyName);
                continue;
            }
            PolicyMappingElement failedPolicyMappingElement = new PolicyMappingElement();
            failedPolicyMappingElement.setPolicyName(newpolicyName);
            failedPolicyMappingElement.setUserName(userName);
            failedPolicyMappingElement.setReason("User not found");
            policyMappingElement.add(failedPolicyMappingElement);
            logger.debug(" user does not exist .... " + userName);
        }
        if (!CollectionUtils.isEmpty(policyMappingElement)) {
            logger.debug(" failed policyMappingElement  is not empty.." + policyMappingElement.size());
            this.createUsersExcelMappingFailNew(cloudId, policyMappingElement);
        }
        return policyMappingElement;
    }

    private void setPolicyNotFound(List<PolicyMappingElement> policyMappingElement, String userName, String newpolicyName) {
        PolicyMappingElement failedPolicyMappingElement = new PolicyMappingElement();
        failedPolicyMappingElement.setPolicyName(newpolicyName);
        failedPolicyMappingElement.setUserName(userName);
        failedPolicyMappingElement.setReason("Policy not found");
        logger.debug(" policy does not exist .... " + newpolicyName);
        policyMappingElement.add(failedPolicyMappingElement);
    }

    @Override
    public EditUserBackupPolicyMappingElement getSPPolicyElements(int cloudId, User logedInUser, String policyType) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List list = new ArrayList();
        if (logedInUser.isAdmin()) {
            list = this.userDao.getAllSPSites(cloudId);
        } else if (logedInUser.isReadOnlyAdmin()) {
            list = this.userDao.getAllSPSitesForDelegatedAdmin(cloudId, logedInUser.getOdbPoliciesAdmin());
        }
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList();
            logger.debug("....sitelist..empty..");
        }
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        for (User user : list) {
            if (user == null) continue;
            logger.debug("...user ...list...." + user.getUserName());
            String policyName = "";
            if (!StringUtils.isEmpty((String)user.getSpPolicyName())) {
                policyName = user.getSpPolicyName();
            }
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            element.setSpPolicyName(policyName);
            String userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        List allOneDriveBackupPolicies = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId, policyType);
        List backupPolicyNamesList = null;
        if (logedInUser.isAdmin()) {
            backupPolicyNamesList = allOneDriveBackupPolicies.stream().filter(odbPolicy -> Objects.nonNull(odbPolicy.getPolicyName())).map(odbPolicy -> odbPolicy.getPolicyName()).collect(Collectors.toList());
        }
        if (logedInUser.isReadOnlyAdmin()) {
            if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
                backupPolicyNamesList = logedInUser.getOdbPoliciesAdmin().stream().filter(exchangePolicyName -> exchangePolicyName.startsWith("EX_")).collect(Collectors.toList());
            } else if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
                backupPolicyNamesList = logedInUser.getOdbPoliciesAdmin().stream().filter(odbPolicyName -> odbPolicyName.startsWith("ODB_")).collect(Collectors.toList());
            } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                backupPolicyNamesList = logedInUser.getOdbPoliciesAdmin().stream().filter(sharePointPolicyName -> sharePointPolicyName.startsWith("SP_")).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(backupPolicyNamesList)) {
            backupPolicyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(backupPolicyNamesList);
        logger.debug(elements.size() + "....total odb policy list... " + backupPolicyNamesList.size());
        return editUserBackupPolicyMappingElement;
    }

    private String mapPolicyTypeToProduct(String policyType) {
        String productType;
        switch (policyType) {
            case "ODB": {
                productType = "(OneDrive for Business)";
                break;
            }
            case "Exchange": {
                productType = "(Microsoft Exchange)";
                break;
            }
            case "Sharepoint": {
                productType = "(SharePoint Online)";
                break;
            }
            case "Backup": {
                productType = "(BluVault)";
            }
            default: {
                productType = policyType;
            }
        }
        return productType;
    }
}

