/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.BackupFolderService;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.domain.BackupFolders;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BackupFolderServiceImpl
implements BackupFolderService {
    @Resource
    private BackupFoldersDao backupFoldersDao;

    @Override
    public void saveBackupFolder(int cloudId, String cloudName, BackupFolderElement backupFolderElement) {
        BackupFolders backupFolders = new BackupFolders();
        backupFolders.setFolderPath(backupFolderElement.getFolderPath());
        backupFolders.setOs(backupFolderElement.getOsType());
        this.createOrEdit(cloudId, cloudName, backupFolderElement, backupFolders);
    }

    private void createOrEdit(int cloudId, String cloudName, BackupFolderElement backupFolderElement, BackupFolders backupFolders) {
        BackupFolders existingBackupFolders = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderElement.getFolderPath());
        if (existingBackupFolders != null) {
            ObjectId id = existingBackupFolders.getId();
            BeanUtils.copyProperties((Object)backupFolders, (Object)existingBackupFolders);
            existingBackupFolders.setId(id);
            this.backupFoldersDao.saveBackupFolders(cloudId, cloudName, existingBackupFolders);
        } else {
            this.backupFoldersDao.saveBackupFolders(cloudId, cloudName, backupFolders);
        }
    }

    @Override
    public BackupFolderElement getBackupFolder(int cloudId, String cloudName, String folderPath) {
        BackupFolders backupFolders = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, folderPath);
        return this.getBackupFolderElement(backupFolders);
    }

    @Override
    public List<BackupFolderElement> getAllBackupFolders(int cloudId, String cloudName) {
        List backupFoldersList = this.backupFoldersDao.getAllBackupFolders(cloudId, cloudName);
        ArrayList<BackupFolderElement> elements = new ArrayList<BackupFolderElement>();
        for (BackupFolders backupFolders : backupFoldersList) {
            BackupFolderElement element = this.getBackupFolderElement(backupFolders);
            elements.add(element);
        }
        return elements;
    }

    private BackupFolderElement getBackupFolderElement(BackupFolders backupFolders) {
        BackupFolderElement element = null;
        if (backupFolders != null) {
            element = new BackupFolderElement();
            element.setFolderPath(backupFolders.getFolderPath());
            element.setOsType(backupFolders.getOs());
        }
        return element;
    }
}

