/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.domain;

import com.parablu.pcbd.domain.OfficeBackupPolicy;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="MAIL_BACKUP_BATCH")
@CompoundIndexes(value={@CompoundIndex(name="user_1_device_1_jobType_1", def="{'user' : 1, 'device':1, 'jobType':1}"), @CompoundIndex(name="jobType_1_status_1", def="{'jobType':1, 'status':1}")})
public class MailBackupBatch {
    @Id
    @Field
    private ObjectId id;
    @Field
    @Indexed
    private String userName;
    @Field
    @Indexed
    private String deviceName;
    @Field
    @Indexed
    private String restoreByUserName;
    @Field
    @Indexed
    private String deviceUUID;
    @Field
    private String backupId;
    @Field
    private boolean isFolder;
    @Field
    private long batchStartTimestamp;
    @Field
    private long batchEndTimestamp;
    @Field
    private long noOfFiles;
    @Field
    private String uploadedSize;
    @Field
    private String uploadedFiles;
    @Field
    private String totalNoOfFiles;
    @Field
    private String status;
    @Field
    private String jobType;
    @Field
    private String errorCode;
    @Field
    private String crawlTimestamp;
    @Field
    private long totalSizeToUpload;
    @Field
    private String officePolicyName;
    @Transient
    private OfficeBackupPolicy oneDriveBackupPolicy;

    public String getOfficePolicyName() {
        return this.officePolicyName;
    }

    public void setOfficePolicyName(String officePolicyName) {
        this.officePolicyName = officePolicyName;
    }

    public OfficeBackupPolicy getOfficeBackupPolicy() {
        return this.oneDriveBackupPolicy;
    }

    public void setOfficeBackupPolicy(OfficeBackupPolicy oneDriveBackupPolicy) {
        this.oneDriveBackupPolicy = oneDriveBackupPolicy;
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public long getBatchStartTimestamp() {
        return this.batchStartTimestamp;
    }

    public void setBatchStartTimestamp(long batchStartTimestamp) {
        this.batchStartTimestamp = batchStartTimestamp;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getBatchEndTimestamp() {
        return this.batchEndTimestamp;
    }

    public void setBatchEndTimestamp(long batchEndTimestamp) {
        this.batchEndTimestamp = batchEndTimestamp;
    }

    public long getNoOfFiles() {
        return this.noOfFiles;
    }

    public void setNoOfFiles(long noOfFiles) {
        this.noOfFiles = noOfFiles;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getUploadedSize() {
        return this.uploadedSize;
    }

    public void setUploadedSize(String uploadedSize) {
        this.uploadedSize = uploadedSize;
    }

    public String getUploadedFiles() {
        return this.uploadedFiles;
    }

    public void setUploadedFiles(String uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public String getTotalNoOfFiles() {
        return this.totalNoOfFiles;
    }

    public void setTotalNoOfFiles(String totalNoOfFiles) {
        this.totalNoOfFiles = totalNoOfFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BackupBatch: \n");
        sb.append("\t backupBatchId\t\t").append(this.id);
        return sb.toString();
    }

    public String getCrawlTimestamp() {
        return this.crawlTimestamp;
    }

    public void setCrawlTimestamp(String crawlTimestamp) {
        this.crawlTimestamp = crawlTimestamp;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public long getTotalSizeToUpload() {
        return this.totalSizeToUpload;
    }

    public void setTotalSizeToUpload(long totalSizeToUpload) {
        this.totalSizeToUpload = totalSizeToUpload;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    public String getRestoreByUserName() {
        return this.restoreByUserName;
    }

    public void setRestoreByUserName(String restoreByUserName) {
        this.restoreByUserName = restoreByUserName;
    }

    public static enum STATUS {
        STARTED,
        COMPLETED,
        FAILED,
        INTERRUPTED;

    }
}

