/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.UserGroupDao;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.MiniCloudGroupMapping;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class UserGroupDaoImpl
implements UserGroupDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    Logger logger = LogManager.getLogger(UserGroupDaoImpl.class);
    private static final String GROUP_NAME = "groupName";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveGroup(int cloudId, Group group, List<String> users) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)group);
        this.createUserGroup(cloudId, group, users);
    }

    private void createUserGroup(int cloudId, Group group, List<String> users) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<UserGroup> existingGroup = this.getAllUsersForGroup(cloudId, null, group.getId().toString());
        for (UserGroup userGroup : existingGroup) {
            mongoTemplate.remove((Object)userGroup);
        }
        for (String userName : users) {
            UserGroup userGroup = new UserGroup();
            userGroup.setGroup(group);
            User user = this.getUserForName(mongoTemplate, userName);
            userGroup.setUser(user);
            mongoTemplate.save((Object)userGroup);
        }
    }

    private User getUserForName(MongoTemplate mongoTemplate, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex("^" + userName + "$", "i"), Criteria.where((String)"active").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)mongoTemplate.findOne(query, User.class);
    }

    @Override
    public List<UserGroup> getAllUsersForGroup(int cloudId, String groupName, String groupId1) {
        Query query;
        String groupId = groupId1;
        Criteria criteria = new Criteria();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)groupId)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)GROUP_NAME).is((Object)groupName)});
            query = new Query((CriteriaDefinition)criteria);
            Group group = (Group)mongoTemplate.findOne(query, Group.class);
            groupId = group.getId().toString();
        }
        if (StringUtils.isEmpty((Object)groupId)) {
            return new ArrayList<UserGroup>();
        }
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"group.$id").is((Object)new ObjectId(groupId))});
        query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, UserGroup.class);
    }

    @Override
    public void deleteGroup(int cloudId, Group group) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"group.$id").is((Object)group.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, MiniCloudGroupMapping.class);
        for (MiniCloudGroupMapping miniCloudGroupMapping : list) {
            mongoTemplate.remove((Object)miniCloudGroupMapping);
        }
        mongoTemplate.remove((Object)group);
    }

    @Override
    public Group getGroupByName(int cloudId, String groupName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)GROUP_NAME).regex(Pattern.compile("^" + groupName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        return (Group)mongoTemplate.findOne(query, Group.class);
    }

    @Override
    public List<Group> getAllGroups(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(Group.class);
    }

    @Override
    public List<Group> getAllGroups(int cloudId, int skipValue) {
        Query query = new Query();
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{GROUP_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, Group.class);
    }

    @Override
    public void saveMCGroupMapping(int cloudId, MiniCloudGroupMapping miniCloudGroupMapping) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)miniCloudGroupMapping);
    }

    @Override
    public List<Group> searchGroups(int cloudId, String groupName1) {
        String groupName = groupName1;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Group> groupList = new ArrayList<Group>();
        groupName = groupName.trim();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)GROUP_NAME).regex(Pattern.compile("^" + groupName, 2))});
        List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), Group.class);
        if (userDbList != null) {
            for (Group groupObj : userDbList) {
                groupList.add(groupObj);
            }
        }
        return groupList;
    }

    @Override
    public Group getUserGroup(int cloudId, User user) {
        this.logger.debug("Group getUserGroup(int cloudId, User user) > BEGIN");
        Group group = null;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"user").is((Object)user);
        Query query = new Query((CriteriaDefinition)criteria);
        UserGroup userGroup = (UserGroup)mongoTemplate.findOne(query, UserGroup.class);
        this.logger.debug("Group getUserGroup(int cloudId, User user) > BEFORE RETURN");
        if (userGroup != null) {
            group = userGroup.getGroup();
        }
        return group;
    }
}

