/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.result.UpdateResult;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.FailedLogin;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PstBatch;
import com.parablu.pcbd.domain.PstBatchDetail;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UserDaoImpl
implements UserDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    Logger logger = LogManager.getLogger(UserDaoImpl.class);
    private static final String DELETED = "deleted";
    private static final String ACTIVE = "active";
    private static final String USER_NAME = "userName";
    private static final String USER_ID = "userId";
    private static final String EMAIL_ID = "emailId";
    private static final String LOCAL_USER = "localUser";
    private static final String GUEST = "guest";
    private static final String USER_NAME_LOWER_CASE = "userNameLowerCase";
    private static final String POLICY_NAME = "policyName";
    private static final String GUEST_USER = "guest";
    private MongoOperations mongoOps;

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, int skipValue, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        } else {
            Criteria criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersWithoutPagination(int cloudId, String cloudName, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        } else {
            Criteria criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public User getUserInfoByName(int cloudId, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase()));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public boolean checkUserExistByUserNameOrEmail(int cloudId, String userName, String emailId) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailId = Criteria.where((String)EMAIL_ID).is((Object)emailId);
        criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class) != null;
    }

    @Override
    public List<User> getAllUsers(int cloudId) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(User.class);
    }

    @Override
    public User getUserByUserNameOrEmail(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailId = Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + userName + "$", 2));
        criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserByUserNameOrAADLoginId(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        userName = UserDaoImpl.escapeMetaCharacters(userName);
        Criteria criteriaUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailId = Criteria.where((String)"aadLoginId").regex(Pattern.compile("^" + userName, 2));
        criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId});
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("query for get user.." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserByUserNameOrEmail(int cloudId, String userName, String emailId) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserNameWithUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailIdWithUserName = Criteria.where((String)EMAIL_ID).is((Object)userName);
        Criteria criteriaEmailIdWithEmail = Criteria.where((String)EMAIL_ID).is((Object)emailId);
        Criteria criteriaUserNameWithEmail = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)emailId.toLowerCase());
        criteria.orOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{criteriaUserNameWithUserName, criteriaEmailIdWithUserName}), new Criteria().orOperator(new Criteria[]{criteriaUserNameWithEmail, criteriaEmailIdWithEmail})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserInfo(int cloudId, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public void removeUserbyID(int cloudId, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAndRemove(query, User.class);
    }

    @Override
    public User updateUser(int cloudId, String cloudName, User user) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.save((Object)user);
        return user;
    }

    @Override
    public void deleteUser(int cloudId, String cloudName, User user) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove((Object)user);
    }

    @Override
    public void deleteUsers(int cloudId, String cloudName, List<String> userIdList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIdList)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, User.class);
    }

    @Override
    public long getUsersCountInPolicyNames(int cloudId, List<String> userNamesList, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true)});
        } else {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, List<String> userIdlist) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIdlist), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserInfoByName(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null && !user.isDeleted()) {
            return user;
        }
        return null;
    }

    @Override
    public long countOfPresentUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public long countOfPresentUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentSyncUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"syncEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentBackupUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"backupEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<User> getAllAdmins(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"admin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Criteria orCriteria1 = new Criteria();
        orCriteria1.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)false), Criteria.where((String)"admin").is((Object)false)});
        criteria.andOperator(new Criteria[]{orCriteria1, orCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllReadOnlyAdmins(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllShareEnabledActiveUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"shareEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void saveFailedLogin(int cloudId, String cloudName, FailedLogin failedLogin) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)failedLogin);
    }

    @Override
    public User saveUser(int cloudId, String cloudName, User user) {
        user.setLastModifiedTimestamp(Long.toString(System.currentTimeMillis()));
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)user);
        return user;
    }

    @Override
    public List<User> searchUsers(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile(userName, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> searchUsersForReport(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> searchUserbyUsernameOrDisplaynameOrEmailId(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            Criteria criteriaUserName = Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2));
            Criteria criteriaDisplayName = Criteria.where((String)"displayName").regex(Pattern.compile("^" + userName, 2));
            Criteria criteriaEmailId = Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + userName, 2));
            Criteria criteriaDeleted = Criteria.where((String)DELETED).is((Object)false);
            criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaDisplayName, criteriaEmailId}), criteriaDeleted});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> getUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList, boolean backup) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).nin(existingUserIDList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupEnabled").is((Object)backup)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getODBUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList) {
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"onedriveBkpEnabled").exists(true)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).nin(existingUserIDList), orCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void updateUserPolicy(int cloudId, String policyName, ObjectId userId, String policyType, long updatedTimeStamp) {
        Criteria criteria = Criteria.where((String)USER_ID).is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            update.set(POLICY_NAME, (Object)policyName);
        } else {
            update.set("syncPolicyName", (Object)policyName);
        }
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).nin(existingUserIDList)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllDeletedUsersById(int cloudId, String cloudName, List<ObjectId> userIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllDeletedUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, List<ObjectId> userIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public boolean checkIfEmailAlreadyExists(int cloudId, String emailId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).is((Object)emailId)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public boolean checkIfEmailAlreadyExistsAsUserName(int cloudId, String emailId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)emailId.toLowerCase())});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public List<User> getAllUsersForNames(int cloudId, List<String> usersNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(usersNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        userName = UserDaoImpl.escapeMetaCharacters(userName);
        this.logger.debug("special characters..." + userName);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    public static String escapeMetaCharacters(String inputString) {
        String[] metaCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", "*", "+", "?", "|", "<", ">", "-", "&", "%"};
        for (int i = 0; i < metaCharacters.length; ++i) {
            if (!inputString.contains(metaCharacters[i])) continue;
            inputString = inputString.replace(metaCharacters[i], "\\" + metaCharacters[i]);
        }
        return inputString;
    }

    @Override
    public User getAdminUserWithServerBackupEnabled(int cloudId) {
        this.logger.debug("User getAdminUserWithServerBackupEnabled(int cloudId) > BEGIN");
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true).and("admin").is((Object)true).and("serverBackupEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        this.logger.debug("User getAdminUserWithServerBackupEnabled(int cloudId) > BEFORE RETURN > USER OBJ > " + user);
        return user;
    }

    @Override
    public List<User> searchUsersByEmail(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String email : list) {
            email = email.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + email, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public User getUserDetailsForEmail(int cloudId, String email) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + email + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public void updateUserLoggedInTime(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastLoggedInTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllActiveLdapUser(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)LOCAL_USER).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getOneADUser(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LOCAL_USER).is((Object)false), Criteria.where((String)ACTIVE).exists(true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public List<User> getAllUsersByPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled) {
        Criteria criteriaForDelete;
        Criteria criteria = new Criteria();
        this.logger.debug(policyNames + "....getAllUsersByPolicyNames...." + isODBBackupEnabled);
        if (isODBBackupEnabled) {
            criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForBkpPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForOdbPolicyName = Criteria.where((String)"odbPolicyName").in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)"syncPolicyName").in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForOdbPolicyName, criteriaForSyncPolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete.orOperator(new Criteria[]{criteriaForBkpPolicyName, orCriteria})});
        } else {
            criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)"syncPolicyName").in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForPolicyName, criteriaForSyncPolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete, orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersByPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        if (isODBBackupEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), orCriteria, Criteria.where((String)"odbPolicyName").in(policyNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)POLICY_NAME).in(policyNames)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        this.logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long getAllUsersCountByPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled) {
        Criteria criteriaForDelete;
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria = Criteria.where((String)DELETED).is((Object)false);
        } else if (isODBBackupEnabled) {
            criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForBkpPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForOdbPolicyName = Criteria.where((String)"odbPolicyName").in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)"syncPolicyName").in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForOdbPolicyName, criteriaForSyncPolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete.orOperator(new Criteria[]{criteriaForBkpPolicyName, orCriteria})});
        } else {
            criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)"syncPolicyName").in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForPolicyName, criteriaForSyncPolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete, orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<String> getUserNamesByBackupPoliciesAdmin(int cloudId, List<String> backupPoliciesAdmin) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        List userDbList = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userDbList)) {
            for (User userObj : userDbList) {
                userNameList.add(userObj.getUserName());
            }
        }
        return userNameList;
    }

    @Override
    public List<String> getUserNamesByOfficePoliciesAdmin(int cloudId, List<String> officePoliciesAdmin) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odbPolicyName").in(officePoliciesAdmin), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        List userDbList = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userDbList)) {
            for (User userObj : userDbList) {
                userNameList.add(userObj.getUserName());
            }
        }
        return userNameList;
    }

    @Override
    public List<User> searchUsersForPolicyAdmin(int cloudId, List<String> list, List<String> backupPoliciesAdmin) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public boolean checkPolicyMappedToUsers(int cloudId, String policyName, String policyType) {
        Criteria criteria = new Criteria();
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName), Criteria.where((String)DELETED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"syncPolicyName").is((Object)policyName), Criteria.where((String)DELETED).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        return user != null;
    }

    @Override
    public void deleteUsersByName(int cloudId, List<String> userNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(userNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAllAndRemove(query, User.class);
    }

    @Override
    public void updateAADUserInfo(int cloudId, String userName, Boolean bkpEnabled, Boolean syncEnabled) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)LOCAL_USER).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (bkpEnabled != null) {
            update.set("backupEnabled", (Object)bkpEnabled);
        }
        if (syncEnabled != null) {
            update.set("syncEnabled", (Object)syncEnabled);
        }
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).updateFirst(query, update, User.class);
    }

    @Override
    public void saveAudit(int cloudId, String cloudName, AuditHistory audit) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)audit);
    }

    @Override
    public List<User> getAllOneDriveBkpEnabledUsers(int cloudId) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteria = new Criteria();
        Criteria criteriaActive = Criteria.where((String)ACTIVE).is((Object)true);
        Criteria criteriaODBBKpEnabled = Criteria.where((String)"onedriveBkpEnabled").is((Object)true);
        list.add(criteriaActive);
        list.add(criteriaODBBKpEnabled);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void updateODBUserPolicy(int cloudId, String policyName, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("odbPolicyName", (Object)policyName);
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public long countOfPresentODBBackupUsers(int cloudId, String cloudName, boolean active) {
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)active), Criteria.where((String)"exchangeBkpEnabled").is((Object)active)});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), orCriteria, Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<BlackListUser> getAllBlockedListUser(int cloudId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, BlackListUser.class);
    }

    @Override
    public List<O365BlackListUser> getAllO365BlockedListUser(int cloudId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, O365BlackListUser.class);
    }

    @Override
    public List<User> getAllLdapUser(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LOCAL_USER).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public BackupPolicy getBackupPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    @Override
    public List<BackupPolicy> getAllBackupPolicies(int cloudId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public void updateBackupPolicyModifiedTime(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        paracloudMongoTemplate.updateMulti(query, update, User.class);
    }

    @Override
    public void updateSyncPolicyModifiedTime(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)"syncPolicyName").is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("syncPolicyModifiedTime", (Object)System.currentTimeMillis());
        paracloudMongoTemplate.updateMulti(query, update, User.class);
    }

    @Override
    public List<User> getUsersByBackupPolicyName(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getUsersBySyncPolicyName(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)"syncPolicyName").is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long getBackupPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public long getODBBackupPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public long getSyncPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"syncPolicyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public User getUserByUserName(int cloudId, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase()));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserByAADLoginId(int cloudId, String aadLoginId) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)"aadLoginId").regex(Pattern.compile("^" + aadLoginId, 2));
        Criteria criteriaEmailId = Criteria.where((String)USER_NAME).is((Object)aadLoginId);
        criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    @Override
    public void updateODBUserPolicy(int cloudId, String policyName, ObjectId userId, String policyType, long updatedTimeStamp) {
        Criteria criteria = Criteria.where((String)USER_ID).is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("odbPolicyName", (Object)policyName);
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public boolean checkODBPolicyMappedToUsers(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odbPolicyName").is((Object)policyName), Criteria.where((String)DELETED).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        return user != null;
    }

    @Override
    public List<User> getUsersForDataMigration(int cloudId) {
        Criteria criteria = Criteria.where((String)"migrationStatus").is((Object)User.MIGRATION_STATUS.IN_PROGRESS);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getUsersForDataMigration(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)false), Criteria.where((String)"migrationStatus").ne((Object)User.MIGRATION_STATUS.IN_PROGRESS)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public boolean startMigration(int cloudId, String userName, String destOdbId) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("destOdbLoginId", (Object)destOdbId);
        update.set("migrationStatus", (Object)User.MIGRATION_STATUS.IN_PROGRESS);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, User.class);
        this.logger.debug("... update user data migration .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
        return updateFirst.getModifiedCount() > 0L;
    }

    @Override
    public void updateMigrationStatusAndFolderName(int cloudId, String userName, String migratedFolderName) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("migratedFolderName", (Object)migratedFolderName);
        update.set("migrationStatus", (Object)User.MIGRATION_STATUS.COMPLETED);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, User.class);
        this.logger.debug("... update user data migration .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
    }

    @Override
    public List<User> getAllNewUserForOnedrive(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"isNewOdbUser").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllFailedMailBox(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"failedMailBox").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void updateMailBoxFailStatus(int cloudId, String userName, boolean failMailBox) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("failedMailBox", (Object)failMailBox);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUserByODBLoginIdOrEmailId(int cloudId, String odbLoginId) {
        Criteria criteria = new Criteria();
        Criteria criteriaOdbLoginId = Criteria.where((String)"odbLoginId").is((Object)odbLoginId);
        Criteria criteriaEmailIdWithEmail = Criteria.where((String)EMAIL_ID).is((Object)odbLoginId);
        criteria.orOperator(new Criteria[]{criteriaOdbLoginId, criteriaEmailIdWithEmail});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getUserByODBLoginId(int cloudId, String odbLoginId) {
        Criteria criteriaOdbLoginId = Criteria.where((String)"odbLoginId").is((Object)odbLoginId);
        Query query = new Query((CriteriaDefinition)criteriaOdbLoginId);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void updateUserBkpTargetStatus(int cloudId, String userName, int backupTargetErrorCode, boolean backupTargetAssigned, String odbLoginId) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupTargetErrorCode", (Object)backupTargetErrorCode);
        update.set("backupTargetAssigned", (Object)backupTargetAssigned);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        update.set("odbLoginId", (Object)odbLoginId);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateUserfailedMailBox(int cloudId, String userName, boolean failedMailBox) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("failedMailBox", (Object)failedMailBox);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllBackupTargetNotAssignedUser(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupTargetAssigned").in(new Object[]{false}), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<String> getAllUnMapedUserNames(int cloudId) {
        List<String> userNames = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupTargetAssigned").is((Object)false)});
            Query query = new Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("USER").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userNames;
        }
    }

    @Override
    public List<String> loadAllUsersEmailIds(int cloudId) {
        ArrayList<String> emailIds = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"admin").is((Object)true)});
            Query query = new Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("USER").distinct(EMAIL_ID, (Bson)query.getQueryObject(), String.class);
            List<String> userNames = new ArrayList();
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return emailIds;
        }
    }

    @Override
    public boolean updateODBId(int cloudId, String userName, String destOdbId) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("odbLoginId", (Object)destOdbId);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, User.class);
        this.logger.debug("... update user data migration .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
        return updateFirst.getModifiedCount() > 0L;
    }

    @Override
    public long getAllUsersCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        } else {
            Criteria criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)"syncPolicyName").in(policyNames);
            Criteria criteriaForOfficePolicyName = Criteria.where((String)"odbPolicyName").in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForPolicyName, criteriaForSyncPolicyName, criteriaForOfficePolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete, orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("......." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public void blockUnblockUser(int cloudId, String userName, boolean blockOrUnblock) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(ACTIVE, (Object)blockOrUnblock);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<String> getUsersCountInNames(int cloudId, List<String> userNamesList) {
        List<String> userNames = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).in(userNamesList), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("USER").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
        if (distStr != null) {
            userNames = IteratorUtils.toList((Iterator)distStr.iterator());
        }
        return userNames;
    }

    @Override
    public long countOfPresentBackupUsersByPolicy(int cloudId, String cloudName, boolean active, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        } else {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<String> getBkpUserNamesByBackupPolicies(int cloudId, List<String> backupPoliciesAdmin) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        List userDbList = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userDbList)) {
            for (User userObj : userDbList) {
                userNameList.add(userObj.getUserName());
            }
        }
        return userNameList;
    }

    @Override
    public List<User> getAllUsers(int cloudId, boolean backupEnabled, boolean syncEnabled, boolean isODBBackupEnabled, int skipValue) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        if (backupEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupEnabled").is((Object)true), criteria1});
        } else if (syncEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"syncEnabled").is((Object)true), criteria1});
        } else if (isODBBackupEnabled) {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"onedriveBkpEnabled").exists(true)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), orCriteria, criteria1});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllExchangeBkpEnabledUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void disabledOfficeLicense(int cloudId, String userName, boolean onedriveEnabled, boolean exchangeEnabled) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (onedriveEnabled) {
            update.set("onedriveBkpEnabled", (Object)false);
        }
        if (exchangeEnabled) {
            update.set("exchangeBkpEnabled", (Object)false);
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllSoftBlockUsers(int cloudId, String string, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"softBlockEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long getAllSoftBlockUsersCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"softBlockEnabled").is((Object)true)});
        } else {
            Criteria criteriaForDelete = new Criteria();
            criteriaForDelete.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"softBlockEnabled").is((Object)true)});
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)"syncPolicyName").in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForPolicyName, criteriaForSyncPolicyName, Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteriaForDelete, orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("......." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<User> getAllUsersForReadOnlyWithPagination(int cloudId, List<String> policyNames, int skipValue) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)DELETED).is((Object)false);
        if (!CollectionUtils.isEmpty(policyNames)) {
            Criteria criteriaForPolicyName = new Criteria();
            criteriaForPolicyName.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames), Criteria.where((String)"syncPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaUserDeleted, criteriaForPolicyName});
        } else {
            criteria.andOperator(new Criteria[]{criteriaUserDeleted});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug(" No of records ... " + PCHelperConstant.getReportDisplayRecords());
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersBySyncPolicyNames(int cloudId, List<String> policyNames, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"syncPolicyName").in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        this.logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long loadAllSyncPoliciesMappingCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"syncPolicyName").in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentBackupUsersByPolicyByProductType(int cloudId, String cloudName, boolean active, List<String> policyNames, String productType) {
        Criteria productCriteria = null;
        if (!StringUtils.isEmpty((Object)productType)) {
            productCriteria = new Criteria();
            if ("office".equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
            } else {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true)});
            }
        }
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), productCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false)});
            }
        } else {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), orCriteria, productCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), orCriteria});
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long getUsersCountInPolicyNamesByProductType(int cloudId, List<String> userNamesList, List<String> policyNames, String productType) {
        Criteria productCriteria = null;
        if (!StringUtils.isEmpty((Object)productType)) {
            productCriteria = new Criteria();
            if ("office".equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
            } else {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true)});
            }
        }
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), productCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false)});
            }
        } else {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), orCriteria, productCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), orCriteria});
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public void updateTargetStatus(int cloudId, boolean targetAssigned, int backupTargetErrorCode, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupTargetErrorCode", (Object)backupTargetErrorCode);
        update.set("backupTargetAssigned", (Object)targetAssigned);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateMulti(query, update, User.class);
        if (backupTargetErrorCode > 0) {
            BlackListUser blackListUserObj = this.getBlackListUserbyName(1, userName, PCHelperConstant.getPropertyValueComponentName());
            if (blackListUserObj == null) {
                BlackListUser blackListUser = new BlackListUser();
                blackListUser.setResponseCode("404");
                blackListUser.setUserName(userName);
                blackListUser.setLocalHost(PCHelperConstant.getPropertyValueComponentName());
                this.saveBlackListUser(1, blackListUser);
            } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                this.updateBlackListUserWithCode(1, userName, PCHelperConstant.getPropertyValueComponentName(), "404");
            }
        }
    }

    public void updateBlackListUserWithCode(int cloudId, String userName, String gateWayName, String code) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)gateWayName);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("responseCode", (Object)code);
        update.set("blackListedTime", (Object)System.currentTimeMillis());
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).updateMulti(query, update, BlackListUser.class);
    }

    public void saveBlackListUser(int cloudId, BlackListUser blackListUser) {
        blackListUser.setBlackListedTime(System.currentTimeMillis());
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)blackListUser);
    }

    public BlackListUser getBlackListUserbyName(int cloudId, String userName, String localHost) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)localHost);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BlackListUser)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, BlackListUser.class);
    }

    @Override
    public List<User> getActiveOneDriveUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getActiveExchangeUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long countOfPresentOnedriveUsers(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"onedriveBkpEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentExchangeUsers(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"exchangeBkpEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public void updateAdInfoForUser(int cloudId, String userName, boolean accountStatus, String department, String displayName, String location) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("accountStatus", (Object)accountStatus);
        update.set("department", (Object)department);
        update.set("displayName", (Object)displayName);
        update.set("location", (Object)location);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateUserInfo(int cloudId, boolean backupEnabled, boolean syncEnabled, String userName, boolean softBlockEnabled, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("softBlockEnabled", (Object)softBlockEnabled);
        if (!softBlockEnabled) {
            update.set("backupEnabled", (Object)backupEnabled);
            update.set("syncEnabled", (Object)syncEnabled);
        }
        update.set(ACTIVE, (Object)active);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateUserInfoLicense(int cloudId, String userName, boolean backupEnabled, boolean syncEnabled) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupEnabled", (Object)backupEnabled);
        update.set("syncEnabled", (Object)syncEnabled);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public String savePstBatch(PstBatch pstBatch) {
        this.mongoOps.save((Object)pstBatch);
        this.logger.debug("....pstbatchid..." + pstBatch.getId());
        return pstBatch.getId().toString();
    }

    @Override
    public void savePstBatchDetail(PstBatchDetail pstBatchDetail) {
        this.mongoOps.save((Object)pstBatchDetail);
    }

    @Override
    public void blockOrUnblockUser(int cloudId, String userName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (!active) {
            update.set("backupEnabled", (Object)false);
            update.set("syncEnabled", (Object)false);
            update.set("onedriveBkpEnabled", (Object)false);
            update.set("exchangeBkpEnabled", (Object)false);
        }
        update.set(ACTIVE, (Object)active);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUsersByOneDrivePolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }
}

