/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.client.result.DeleteResult;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.SettingsDao;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.OdbFolderName;
import com.parablu.pcbd.domain.Proxy;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class SettingsDaoImpl
implements SettingsDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public boolean saveProxy(int cloudId, Proxy proxy, boolean isUpdate) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Proxy oldProxy = this.getProxy(cloudId);
        if (oldProxy == null) {
            mongoTemplate.save((Object)proxy);
            return true;
        }
        if (isUpdate) {
            oldProxy.setUserName(proxy.getUserName());
            oldProxy.setPassword(proxy.getPassword());
            oldProxy.setPort(proxy.getPort());
            oldProxy.setHost(proxy.getHost());
            mongoTemplate.save((Object)oldProxy);
            return true;
        }
        return false;
    }

    @Override
    public Proxy getProxy(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List proxies = mongoTemplate.findAll(Proxy.class);
        if (CollectionUtils.isEmpty((Collection)proxies)) {
            return null;
        }
        return (Proxy)proxies.get(0);
    }

    @Override
    public void saveODBFolderName(int cloudId, String folderName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        OdbFolderName odbFolderName = new OdbFolderName();
        odbFolderName.setFolderName(folderName);
        odbFolderName.setUpdatedTime(System.currentTimeMillis());
        mongoTemplate.save((Object)odbFolderName);
    }

    @Override
    public int removeProxy(int cloudId, String host) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"host").is((Object)host));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, Proxy.class);
        return (int)remove.getDeletedCount();
    }

    @Override
    public boolean editProxy(int cloudId, Proxy proxy) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"host").is((Object)proxy.getHost()));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Proxy oldProxy = (Proxy)mongoTemplate.findOne(query, Proxy.class);
        if (oldProxy == null) {
            return false;
        }
        oldProxy.setUserName(proxy.getUserName());
        oldProxy.setPassword(proxy.getPassword());
        oldProxy.setPort(proxy.getPort());
        oldProxy.setHost(proxy.getHost());
        mongoTemplate.save((Object)oldProxy);
        return true;
    }

    @Override
    public List<Proxy> getAllProxy(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List proxies = mongoTemplate.findAll(Proxy.class);
        if (CollectionUtils.isEmpty((Collection)proxies)) {
            return null;
        }
        return proxies;
    }

    @Override
    public Proxy getSpecificProxy(int cloudId, String host) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"host").is((Object)host));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Proxy)mongoTemplate.findOne(query, Proxy.class);
    }

    @Override
    public void saveDedupStartTime(int cloudId, long dedupStartTime) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        CloudSettings cloudSettings = new CloudSettings();
        cloudSettings.setDedupStartTime(dedupStartTime);
        mongoTemplate.save((Object)cloudSettings);
    }
}

