/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.domain.NetworkThrottling;
import java.util.List;
import org.bson.types.ObjectId;
import org.hibernate.SQLQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class NetworkThrottlingDaoImpl
implements NetworkThrottlingDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveNetworkThrottling(int cloudId, String cloudName, NetworkThrottling networkThrottling) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)networkThrottling);
    }

    @Override
    public NetworkThrottling getNetworkThrottling(int cloudId, String cloudName, String name) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (NetworkThrottling)mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"networkThrottlingName").is((Object)name)), NetworkThrottling.class);
    }

    @Override
    public List<NetworkThrottling> getAllNetworkThrottling(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(NetworkThrottling.class);
    }

    @Override
    public List<NetworkThrottling> getNetworkThrottlings(int cloudId, String cloudName, List<String> names) {
        Criteria criteria = Criteria.where((String)"networkThrottlingName").in(names);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), NetworkThrottling.class);
    }

    @Override
    public List<ObjectId> getNetworkThrottlingMappedValue(int cloudId, String cloudName, ObjectId networkThrottlingId) {
        String sqlQuery = "select MGP_ID  from MACHINE_GROUP_NWT_MAPPING where NWT_ID =:networkThrottlingId ";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sqlQuery);
        query.setParameter("networkThrottlingId", (Object)networkThrottlingId);
        return query.list();
    }

    @Override
    public List<NetworkThrottling> getNetworkThrottlingsForPG(int cloudId, String cloudName, String pgName) {
        Criteria criteria = Criteria.where((String)"privacyGatewayName").in(new Object[]{pgName});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), NetworkThrottling.class);
    }

    @Override
    public void deleteThrottle(int cloudId, String cloudName, String throttleId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(new Object[]{throttleId})});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, NetworkThrottling.class);
    }

    @Override
    public NetworkThrottling getNetworkThrottle(int cloudId, String cloudName, String throttleId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(new Object[]{throttleId})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (NetworkThrottling)paracloudMongoTemplate.findOne(query, NetworkThrottling.class);
    }

    @Override
    public List<NetworkThrottling> getNetworkThrottlingsByType(int cloudId, String cloudName, String pgName, String type) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"privacyGatewayName").is((Object)pgName), Criteria.where((String)"throttleType").is((Object)type)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), NetworkThrottling.class);
    }
}

