/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class EventHubDaoImpl
implements EventHubDao {
    private static Logger logger = LogManager.getLogger(EventHubDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String ACTION_TO_USER_NAME = "actionToUserName";
    private static final String ACTION_TO_DEVICEUUID = "actionToDeviceUUID";
    private static final String ACTION_STATUS = "actionStatus";
    private static final String ACTION = "action";
    private static final String START_RESTORE = "START_RESTORE";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveAction(int cloudId, String cloudName, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)eventHub);
    }

    @Override
    public void changeStatus(int cloudId, String cloudName, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(ACTION_STATUS, (Object)eventHub.getActionStatus());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, EventHub.class);
    }

    @Override
    public void deleteAction(int cloudId, String cloudName, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, EventHub.class);
    }

    @Override
    public List<EventHub> getActionsByUserNameAndActionByDeviceUUID(int cloudId, String cloudName, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public boolean checkActionIsPresent(int cloudId, String cloudName, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return Optional.ofNullable(mongoTemplate.findOne(query, EventHub.class)).isPresent();
    }

    @Override
    public void deleteAllActionByDeviceUUID(int cloudId, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, EventHub.class);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)ACTION).is((Object)action)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, EventHub.class);
    }

    @Override
    public void updateBackupBatchForStopAndPauseBkp(int cloudId, String actionToDeviceUUID, String errorCode, String status) {
        EventHub eventHub;
        logger.debug("......." + actionToDeviceUUID + "........" + errorCode + "......." + status);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID), Criteria.where((String)"jobType").is((Object)"BACKUP")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"batchEndTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        backupBatch.setErrorCode(errorCode);
        logger.debug(backupBatch.getStatus() + "......." + backupBatch.getErrorCode());
        if (backupBatch != null && backupBatch.getStatus().equals("SCANNING")) {
            logger.debug("..........");
            eventHub = new EventHub();
            eventHub.setActionToDeviceUUID(actionToDeviceUUID);
            eventHub.setActionToUserName(backupBatch.getUserName());
            eventHub.setAction(status);
            if (!this.checkActionIsPresent(cloudId, "", eventHub)) {
                logger.debug("..saving action....");
                this.saveAction(cloudId, "", eventHub);
            } else {
                logger.debug("event is alredy present....");
            }
        }
        if ((errorCode = errorCode.trim()).trim().equals("1207") || errorCode.trim().equals("1209")) {
            backupBatch.setStatus("ABORTED");
        }
        if (errorCode.trim().equals("1992") || errorCode.trim().equals("1208")) {
            backupBatch.setStatus("PAUSED");
            if (errorCode.equals("1208")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "PAUSED", 1208);
            }
            if (errorCode.equals("1992")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "PAUSED", 1992);
            }
        }
        mongoTemplate.save((Object)backupBatch);
        if ((errorCode.equals("1207") || errorCode.equals("1209")) && (eventHub = this.getEventActionBasedOnBackupBatchStatus(cloudId, actionToDeviceUUID)) == null) {
            if (errorCode.equals("1207")) {
                this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1207);
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1207);
            }
            if (errorCode.equals("1209")) {
                this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1209);
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1209);
            }
        }
    }

    public void updateBackBatch(int cloudId, ObjectId backupBatchId, String status, int errorCode) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatchId))), BackupBatch.class);
        if (backupBatch != null) {
            Update update = new Update();
            update.set("status", (Object)status);
            update.set("errorCode", (Object)("" + errorCode));
            update.set("batchEndTimestamp", (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    public void updateOverViewStatus(int cloudId, String actionToDeviceUUID, String status, int errorCode) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastBkpStatus", (Object)status);
        update.set("reason", (Object)("" + errorCode));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    public EventHub getEventActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID) {
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria devUUIDCriteria = Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID);
        andCriteria.andOperator(new Criteria[]{devUUIDCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (EventHub)mongoTemplate.findOne(query, EventHub.class);
    }

    @Override
    public RestoreEvents getRestoreEventsByDestUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)destinationFolder)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID), Criteria.where((String)"destinationFolder").is((Object)destinationFolder)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public void deleteRestoreEventsByDestUUID(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        RestoreEvents restoreEvents = (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
        if (restoreEvents != null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)restoreEvents.getDestinationDeviceUUID())});
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.findAndRemove(query, RestoreEvents.class);
            this.updateBackupBatchForStopRestore(cloudId, deviceUUID, "1207");
        }
    }

    @Override
    public void saveRestoreEvents(int cloudId, RestoreEvents restoreEvents) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)restoreEvents);
    }

    @Override
    public void deleteRestoreEvents(int cloudId, RestoreEvents restoreEvents) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)restoreEvents);
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"status").is((Object)"STARTED")});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MailBackupBatch)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), MailBackupBatch.class);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode, String status) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID), Criteria.where((String)"jobType").is((Object)"RESTORE")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"batchEndTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        backupBatch.setErrorCode(errorCode);
        if (backupBatch != null) {
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            backupBatch.setErrorCode(errorCode);
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            mongoTemplate.save((Object)backupBatch);
        }
    }

    @Override
    public RestoreEvents getRestoreEventsByDestUUIDAndFolder(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public RestoreEvents getRestoreEventsBySourceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public RestoreProgressEvents getRestoreProgressByEvents(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreProgressEvents)mongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public void removeRestoreProgress(int cloudId, String deviceUUID) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
    }

    @Override
    public void removeRestoreProgressById(int cloudId, ObjectId id) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
    }

    @Override
    public RestoreProgressEvents getRestoreEventProgressByUUID(int cloudId, String deviceUUID) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreProgressEvents)paracloudMongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID), Criteria.where((String)"jobType").is((Object)"RESTORE")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"batchEndTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        if (backupBatch != null) {
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            backupBatch.setStatus("STOPPED");
            backupBatch.setErrorCode(errorCode);
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            mongoTemplate.save((Object)backupBatch);
        }
    }

    @Override
    public RestoreEvents getRestoreEventForBatchId(int cloudId, String batchId) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)batchId)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreEvents)paracloudMongoTemplate.findOne(query, RestoreEvents.class);
    }
}

