/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.LicenseKeyFileElement;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudPluginDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.SmtpCredentials;
import com.parablu.pcbd.domain.TamperDetails;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class CloudDaoImpl
implements CloudDao {
    private static final String PARABLU_DB = "parablu";
    private MongoOperations mongoOps;
    private static final String CLOUD_NAME = "cloudName";
    private static final String IDENTITY = "identity";
    private static final String CLOUD_ID = "cloudId";
    private static final String LICENSEKEY = "LICENSEKEY";
    private static Logger logger = LogManager.getLogger(CloudDaoImpl.class);

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    @Override
    public Cloud getCloudDetails(String cloudName) {
        Criteria criteria = Criteria.where((String)CLOUD_NAME).is((Object)cloudName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        return (Cloud)this.mongoOps.findOne(query, Cloud.class);
    }

    @Override
    public void saveCloud(Cloud cloud) {
        this.mongoOps.save((Object)cloud);
    }

    @Override
    public void updateCloudLicense(Cloud cloud) {
        this.mongoOps.save((Object)cloud);
    }

    @Override
    public List<Cloud> getAllClouds() {
        return this.mongoOps.findAll(Cloud.class);
    }

    @Override
    public void createNewCloud(Cloud cloud) {
        this.addCloudPlugins(cloud);
        this.addCloudCustomizable(cloud);
        this.mongoOps.save((Object)cloud);
    }

    private void addCloudPlugins(Cloud cloud) {
        List<CloudPluginDetails> cloudPluginDetailsList = cloud.getCloudPluginDetails();
        ArrayList<CloudPluginDetails> newCloudPluginDetailsList = new ArrayList<CloudPluginDetails>();
        for (CloudPluginDetails cloudPluginDetails : cloudPluginDetailsList) {
            Criteria criteria = Criteria.where((String)"pluginName").is((Object)cloudPluginDetails.getPluginName());
            Query query = new Query((CriteriaDefinition)criteria);
            CloudPluginDetails existingPluginDetails = (CloudPluginDetails)this.mongoOps.findOne(query, CloudPluginDetails.class);
            if (existingPluginDetails == null) {
                this.mongoOps.save((Object)cloudPluginDetails);
                newCloudPluginDetailsList.add(cloudPluginDetails);
                continue;
            }
            newCloudPluginDetailsList.add(existingPluginDetails);
        }
        cloud.getCloudPluginDetails().clear();
        cloud.getCloudPluginDetails().addAll(newCloudPluginDetailsList);
    }

    private void addCloudCustomizable(Cloud cloud) {
        List<CloudCustomisableDetails> cloudCustomisableDetailsList = cloud.getCloudCustomisableDetails();
        ArrayList<CloudCustomisableDetails> newCloudCustomisableDetailsList = new ArrayList<CloudCustomisableDetails>();
        for (CloudCustomisableDetails cloudCustomizableDetails : cloudCustomisableDetailsList) {
            Criteria criteria = Criteria.where((String)"name").is((Object)cloudCustomizableDetails.getName());
            Query query = new Query((CriteriaDefinition)criteria);
            CloudCustomisableDetails existingPluginDetails = (CloudCustomisableDetails)this.mongoOps.findOne(query, CloudCustomisableDetails.class);
            if (existingPluginDetails == null) {
                this.mongoOps.save((Object)cloudCustomizableDetails);
                newCloudCustomisableDetailsList.add(cloudCustomizableDetails);
                continue;
            }
            newCloudCustomisableDetailsList.add(existingPluginDetails);
        }
        cloud.getCloudCustomisableDetails().clear();
        cloud.getCloudCustomisableDetails().addAll(newCloudCustomisableDetailsList);
    }

    @Override
    public List<CloudCustomisableDetails> getCloudCustomizable(int cloudId) {
        List cloudCustomisableDetailsList = this.mongoOps.findAll(CloudCustomisableDetails.class);
        logger.debug(" ...device getALL..... ");
        return cloudCustomisableDetailsList;
    }

    @Override
    public void updateAmazonCloud(String cloudName) {
        Criteria criteria = Criteria.where((String)CLOUD_NAME).is((Object)"");
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(CLOUD_NAME, (Object)cloudName.toLowerCase());
        this.mongoOps.updateFirst(query, update, Cloud.class);
    }

    @Override
    public void saveCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        Criteria criteria = Criteria.where((String)CLOUD_ID).is((Object)cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        Cloud cloud = (Cloud)this.mongoOps.findOne(query, Cloud.class);
        criteria = Criteria.where((String)IDENTITY).is((Object)cloudCredentials.getIdentity());
        query = new Query((CriteriaDefinition)criteria);
        CloudCredentials credentials = (CloudCredentials)this.mongoOps.findOne(query, CloudCredentials.class);
        if (credentials != null) {
            credentials.setCredential(cloudCredentials.getCredential());
            credentials.setEndPointUrl(cloudCredentials.getEndPointUrl());
            credentials.setProvider(cloudCredentials.getProvider());
            this.mongoOps.save((Object)credentials);
            this.saveCredentialsToCloud(cloud);
        } else {
            if (!StringUtils.isEmpty((Object)cloudCredentials.getBlobTagName())) {
                criteria = Criteria.where((String)"blobTagName").is((Object)cloudCredentials.getBlobTagName());
                query = new Query((CriteriaDefinition)criteria);
                this.mongoOps.remove(query, CloudCredentials.class);
            }
            this.mongoOps.save((Object)cloudCredentials);
            this.saveCredentialsToCloud(cloud);
        }
    }

    private void saveCredentialsToCloud(Cloud cloud) {
        List allCredentials = this.mongoOps.findAll(CloudCredentials.class);
        cloud.getCloudCredentials().clear();
        cloud.getCloudCredentials().addAll(allCredentials);
        this.mongoOps.save((Object)cloud);
    }

    @Override
    public List<CloudCredentials> getAllCloudCredentials(int cloudId) {
        return this.mongoOps.findAll(CloudCredentials.class);
    }

    @Override
    public boolean deleteCloudCredentials(int cloudId, String identity) {
        DeleteResult remove;
        Criteria criteria = Criteria.where((String)IDENTITY).is((Object)identity);
        Query query = new Query((CriteriaDefinition)criteria);
        CloudCredentials credentials = (CloudCredentials)this.mongoOps.findOne(query, CloudCredentials.class);
        return credentials != null && 0L < (remove = this.mongoOps.remove((Object)credentials)).getDeletedCount();
    }

    @Override
    public CloudCredentials getCloudCredentials(int cloudId, String identity) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)IDENTITY).is((Object)identity)});
        return (CloudCredentials)this.mongoOps.findOne(new Query((CriteriaDefinition)criteria), CloudCredentials.class);
    }

    @Override
    public void saveSmtpCredentials(int cloudId, SmtpCredentials smtpCredentials) {
        this.mongoOps.save((Object)smtpCredentials);
    }

    @Override
    public void saveCloudProperties(int cloudId, CloudProperties cloudProperties) {
        this.mongoOps.save((Object)cloudProperties);
    }

    @Override
    @Cacheable(value={"getSmtpCred"})
    public SmtpCredentials getSmtpCredentials(int cloudId) {
        List smtpCreds = this.mongoOps.findAll(SmtpCredentials.class);
        if (smtpCreds != null && !smtpCreds.isEmpty()) {
            return (SmtpCredentials)smtpCreds.get(0);
        }
        return null;
    }

    @Override
    @Cacheable(value={"getCloudProps"})
    public CloudProperties getCloudProperties(int cloudId) {
        List cloudProps = this.mongoOps.findAll(CloudProperties.class);
        if (cloudProps != null && !cloudProps.isEmpty()) {
            return (CloudProperties)cloudProps.get(0);
        }
        return null;
    }

    @Override
    public boolean createCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        Criteria criteria = Criteria.where((String)CLOUD_ID).is((Object)cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        Cloud cloud = (Cloud)this.mongoOps.findOne(query, Cloud.class);
        criteria = Criteria.where((String)IDENTITY).is((Object)cloudCredentials.getIdentity());
        query = new Query((CriteriaDefinition)criteria);
        CloudCredentials credentials = (CloudCredentials)this.mongoOps.findOne(query, CloudCredentials.class);
        if (credentials == null) {
            this.mongoOps.save((Object)cloudCredentials);
            this.saveCredentialsToCloud(cloud);
            return true;
        }
        return false;
    }

    @Override
    public boolean editCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        Criteria criteria = Criteria.where((String)CLOUD_ID).is((Object)cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        Cloud cloud = (Cloud)this.mongoOps.findOne(query, Cloud.class);
        criteria = Criteria.where((String)IDENTITY).is((Object)cloudCredentials.getIdentity());
        query = new Query((CriteriaDefinition)criteria);
        CloudCredentials credentials = (CloudCredentials)this.mongoOps.findOne(query, CloudCredentials.class);
        if (credentials != null) {
            credentials.setCredential(cloudCredentials.getCredential());
            credentials.setEndPointUrl(cloudCredentials.getEndPointUrl());
            credentials.setProvider(cloudCredentials.getProvider());
            this.mongoOps.save((Object)credentials);
            this.saveCredentialsToCloud(cloud);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCloud(String cloudName, Cloud cloud) {
        Criteria criteria = Criteria.where((String)CLOUD_NAME).is((Object)cloudName);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoOps.save((Object)cloud);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(String fileName, String filePath, long lastModifiedTime) {
        logger.debug("..filePath....." + filePath + "..........fileName....ss...." + fileName);
        MongoClient client = this.getMongoClient();
        DB db = client.getDB(PARABLU_DB);
        String collectionName = LICENSEKEY;
        logger.debug("...saving..Coll. new chnages .." + collectionName);
        File brandingFile = new File(filePath + "/" + fileName);
        GridFS gfs = new GridFS(db, collectionName);
        try {
            gfs.remove((DBObject)gfs.findOne(fileName));
        }
        catch (Exception e1) {
            logger.debug("failed to remove existing data" + e1);
            logger.error("failed to remove existing data......" + e1.getMessage());
        }
        gfs = new GridFS(db, collectionName);
        try {
            GridFSInputFile gfsFile = gfs.createFile(brandingFile);
            gfsFile.put("lastModifiedTime", (Object)lastModifiedTime);
            gfsFile.setFilename(fileName);
            gfsFile.save();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("failed to save license key file......" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("failed to save license key file......" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getLicenseKeyFile(String destinationPath, String fileName) {
        MongoClient client = null;
        client = this.getMongoClient();
        DB db = client.getDB(PARABLU_DB);
        String collectioName = LICENSEKEY;
        GridFS gfs = new GridFS(db, collectioName);
        GridFSDBFile imageForOutput = gfs.findOne(fileName);
        try {
            logger.debug(".......fileName" + fileName + "..." + destinationPath + "..." + collectioName);
            imageForOutput.writeTo(destinationPath + "/" + fileName);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("failed to get License Key File......" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("failed to save license key file......" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    private MongoClient getMongoClient() {
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)PARABLU_DB, (char[])PARABLU_DB.toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress(PCHelperConstant.getPropertyValueDBHost1().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort1().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost2().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort2().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost3().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort3().trim()))), credential, options);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LicenseKeyFileElement> getLicenseKeyList() {
        logger.debug("....getLicenseKeyList.....");
        ArrayList<LicenseKeyFileElement> licenseKeyFileElementList = new ArrayList<LicenseKeyFileElement>();
        try (MongoClient client = null;){
            client = this.getMongoClient();
            DB db = client.getDB(PARABLU_DB);
            String collectioName = LICENSEKEY;
            GridFS gfs = new GridFS(db, collectioName);
            List imageForOutput = gfs.find((DBObject)new BasicDBObject());
            for (GridFSDBFile file : imageForOutput) {
                Date myDate = file.getUploadDate();
                long modifiedTime = (Long)file.get("lastModifiedTime");
                LicenseKeyFileElement licenseKeyFileElement = new LicenseKeyFileElement();
                licenseKeyFileElement.setFileName(file.getFilename());
                licenseKeyFileElement.setLastModifiedTime(modifiedTime);
                logger.debug(modifiedTime + "  lates time stamp");
                logger.debug(file.getFilename() + "  file name");
                licenseKeyFileElementList.add(licenseKeyFileElement);
            }
        }
        return licenseKeyFileElementList;
    }

    @Override
    public void addTamperDetection(String licensekeyFileName, long tamperDetectedTime, String modifiedFields, boolean tamperDetected) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        TamperDetails tamperDetails = (TamperDetails)this.mongoOps.findOne(query, TamperDetails.class);
        if (tamperDetails != null) {
            logger.debug("inside tamper details not  nulll");
            tamperDetails.setLicensekeyFileName(licensekeyFileName);
            tamperDetails.setModifiedFields(modifiedFields);
            tamperDetails.setTamperDetected(tamperDetected);
            tamperDetails.setTamperDetectedTime(tamperDetectedTime);
            this.mongoOps.save((Object)tamperDetails);
        } else {
            logger.debug("inside tamper details nulll");
            TamperDetails tamperDetails1 = new TamperDetails();
            tamperDetails1.setLicensekeyFileName(licensekeyFileName);
            tamperDetails1.setModifiedFields(modifiedFields);
            tamperDetails1.setTamperDetected(tamperDetected);
            tamperDetails1.setTamperDetectedTime(tamperDetectedTime);
            this.mongoOps.save((Object)tamperDetails1);
        }
    }

    @Override
    public boolean updateCloud(String cloudName) {
        Criteria criteria = Criteria.where((String)CLOUD_NAME).is((Object)cloudName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("validityPeriod", (Object)System.currentTimeMillis());
        this.mongoOps.updateFirst(query, update, Cloud.class);
        return true;
    }
}

