/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.BluvaultProperties;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BluVaultDaoImpl
implements BluVaultDao {
    private static Logger logger = LogManager.getLogger(BluVaultDaoImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveBluVault(int cloudId, String cloudName, BluVault bluVaultMapping) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"bluVaultName").is((Object)bluVaultMapping.getBluVaultName());
        Query query = new Query((CriteriaDefinition)criteria);
        BluVault org = (BluVault)mongoTemplate.findOne(query, BluVault.class);
        BluvaultProperties bluvaultProperties = (BluvaultProperties)mongoTemplate.findOne(new Query(), BluvaultProperties.class);
        if (bluvaultProperties != null && !CollectionUtils.isEmpty(bluvaultProperties.getComponentsProperties())) {
            if (org == null) {
                BluVault bluVault = new BluVault();
                BeanUtils.copyProperties((Object)bluVaultMapping, (Object)bluVault);
                bluVault.setComponentsProperties(bluvaultProperties.getComponentsProperties());
                mongoTemplate.save((Object)bluVault);
            } else {
                if (!CollectionUtils.isEmpty(bluVaultMapping.getComponentsProperties())) {
                    org.setComponentsProperties(bluVaultMapping.getComponentsProperties());
                }
                mongoTemplate.save((Object)org);
            }
        } else {
            logger.debug("BluvaultProperties is empty so don't save");
        }
    }

    @Override
    public void deleteBluVault(int cloudId, String cloudName, String ebmsId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(new Object[]{ebmsId})});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, BluVault.class);
    }

    @Override
    public List<BluVault> getAllBluVaults(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(BluVault.class);
    }

    @Override
    public boolean isBluVaultNameExist(int cloudId, String bluVaultName) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BluVault bluVault = (BluVault)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"bluVaultName").is((Object)bluVaultName))), BluVault.class);
        return !StringUtils.isEmpty((Object)bluVault);
    }
}

