/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.OPWS;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGatewayBackupPolicyMapping;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class BackupPolicyDaoImpl
implements BackupPolicyDao {
    private static Logger logger = LogManager.getLogger(BackupPolicyDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String POLICY_NAME = "policyName";
    private static final String DELETED = "deleted";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveBackupPolicy(int cloudId, String cloudName, BackupPolicy backupPolicy) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupPolicy);
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String cloudName, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public List<BackupPolicy> getAllBackupPolicies(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public List<BackupPolicy> getAllBackupPoliciesByPagination(int cloudId, int pageNo) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (pageNo != 0) {
            query.skip((long)(pageNo * PCHelperConstant.getReportDisplayRecords()));
        }
        if (PCHelperConstant.getReportDisplayRecords() != 0) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public BackupPolicy getBackupPolicyForDevice(int cloudId, String cloudName, String deviceUUID) {
        return null;
    }

    @Override
    public Boolean getBackupPolicy(int cloudId, String cloudName, String policyName, long lastModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName), Criteria.where((String)"lastModifiedTimestamp").is((Object)lastModifiedTime)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupPolicy backupPolicy = (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
        if (backupPolicy != null) {
            return true;
        }
        return false;
    }

    @Override
    public void deletePGNWTMappings(int cloudId, String cloudName, List<Integer> existIdList) {
    }

    @Override
    public List<PrivacyGatewayBackupPolicyMapping> getPrivGatewayBackupPolicyMappings(int cloudId, String cloudName, Long backupPolicyId) {
        return null;
    }

    @Override
    public List<BackupPolicy> getBackupPolicyForFilterId(int cloudId, String cloudName, ObjectId id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"inclusionFilter.$id").is((Object)id)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public void saveOPWS(int cloudId, String cloudName, OPWS opws) {
        List list;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = mongoTemplate.findAll(OPWS.class, tableName)))) {
            Query query = new Query();
            Update update = new Update();
            update.set("threadSize", (Object)opws.getThreadSize());
            mongoTemplate.updateFirst(query, update, OPWS.class, tableName);
        } else {
            mongoTemplate.insert((Object)opws, tableName);
        }
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        Query query;
        OPWS opws;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if ((opws = (OPWS)mongoTemplate.findOne(query = new Query(), OPWS.class, tableName)) != null) {
            return opws.getThreadSize();
        }
        return 0L;
    }

    @Override
    public List<BackupPolicy> getAllLegalHoldBackupPolicies(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"legalHoldEnabled").is((Object)true)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public void updatePolicyModifiedTime(int cloudId, ObjectId objectId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndModify(query, update, BackupPolicy.class);
    }

    @Override
    public boolean checkIfBackupPolicyNameExists(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, BackupPolicy.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public void blockPolicy(int cloudId, String policyName, String policyType) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("isBlocked", (Object)true);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            paracloudMongoTemplate.updateFirst(query, update, BackupPolicy.class);
        } else {
            paracloudMongoTemplate.updateFirst(query, update, SyncPolicy.class);
        }
    }

    @Override
    public List<BackupPolicy> loadAllBackupPolicies(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("id");
        query.fields().include(POLICY_NAME);
        query.fields().include("maxVersions");
        query.fields().include("schedules");
        query.fields().include("inclusionFilter");
        query.fields().include("userConsentEnabled");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public long loadAllBackupPoliciesCount(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupPolicy.class);
    }

    @Override
    public List<BackupPolicy> loadLiteBackupPolicies(int cloudId) {
        ArrayList<BackupPolicy> backupPolicyList = new ArrayList<BackupPolicy>();
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).exists(true)});
            TypedAggregation aggregation = Aggregation.newAggregation(BackupPolicy.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{POLICY_NAME, "maxVersions", "schedules", "inclusionFilter"}), Aggregation.project((String[])new String[]{POLICY_NAME, "maxVersions", "schedules", "inclusionFilter"})});
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(1);
            AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
            List stateStatsList = result.getMappedResults();
            for (BasicDBObject policy : stateStatsList) {
                BackupPolicy backupPolicy = new BackupPolicy();
                backupPolicy.setPolicyName(policy.getString(POLICY_NAME));
                ArrayList<Schedule> schedulesList = new ArrayList<Schedule>();
                ArrayList<InclusionFilter> inclusionFilters = new ArrayList<InclusionFilter>();
                List schedules = (List)policy.get("schedules");
                ArrayList filters = (ArrayList)policy.get("inclusionFilter");
                this.getFiltersAndSchedules(criteria, mongoTemplate, schedulesList, inclusionFilters, schedules, filters);
                backupPolicy.setInclusionFilter(inclusionFilters);
                backupPolicy.setSchedules(schedulesList);
                backupPolicy.setMaxVersions(policy.getInt("maxVersions"));
                backupPolicyList.add(backupPolicy);
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to load loadLiteBackupPolicies ..." + e);
            logger.error("Error failed to load loadLiteBackupPolicies  ..." + e.getMessage());
        }
        return backupPolicyList;
    }

    private void getFiltersAndSchedules(Criteria criteria, MongoTemplate mongoTemplate, List<Schedule> schedulesList, List<InclusionFilter> inclusionFilters, List<DBRef> schedules, List<DBRef> filters) {
        for (DBRef sch : schedules) {
            Criteria criteria1 = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is(sch.getId())});
            Query query1 = new Query((CriteriaDefinition)criteria1);
            Schedule schedule = (Schedule)mongoTemplate.findOne(query1, Schedule.class);
            schedulesList.add(schedule);
        }
        Criteria criteria1 = new Criteria();
        List collect = filters.stream().filter(line -> Objects.nonNull(line.getId())).map(line -> line.getId()).collect(Collectors.toList());
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is(collect)});
        Query query1 = new Query((CriteriaDefinition)criteria1);
        InclusionFilter filterFromDB = (InclusionFilter)mongoTemplate.findOne(query1, InclusionFilter.class);
        if (filterFromDB != null) {
            BeanUtils.copyProperties((Object)filterFromDB, inclusionFilters);
        }
    }

    @Override
    public boolean checkIfODBBackupPolicyNameExists(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, OfficeBackupPolicy.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public void blockODBPolicy(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("isBlocked", (Object)true);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, OfficeBackupPolicy.class);
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficePolicies(int cloudId) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.findAll(OfficeBackupPolicy.class);
    }

    @Override
    public long loadAllBackupPoliciesCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupPolicy.class);
    }

    @Override
    public List<BackupPolicy> getAllBackupPoliciesByPagination(int cloudId, List<String> policyNames, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        if (PCHelperConstant.getReportDisplayRecords() != 0) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public long loadAllBackupPoliciesMappingCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)POLICY_NAME).in(policyNames)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public long loadAllOfficeBackupPoliciesMappingCount(int cloudId, List<String> policyNames) {
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), orCriteria, Criteria.where((String)"odbPolicyName").in(policyNames)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }
}

