/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.BackupLogsDao;
import com.parablu.pcbd.domain.BackupLog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class BackupLogsDaoImpl
implements BackupLogsDao {
    private static Logger logger = LogManager.getLogger(BackupLogsDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveBackupLog(int cloudId, String cloudName, BackupLog backupLog) {
        logger.debug("Before Saving backup log>>>>>");
        Criteria criteria = Criteria.where((String)"id").is((Object)backupLog.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        this.getBackupLogforId(cloudId, cloudName, backupLog);
        Update update = new Update();
        update.set("restartId", (Object)backupLog.getRestartId());
        update.set("failedFiles", backupLog.getFailedFiles());
        update.set("deviceUUID", (Object)backupLog.getDeviceUUID());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.upsert(query, update, BackupLog.class);
    }

    private void getBackupLogforId(int cloudId, String cloudName, BackupLog backupLog) {
        logger.debug("Before Saving backup log>>>>>");
        Criteria criteria = Criteria.where((String)"id").is((Object)backupLog.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupLog backupLog2 = (BackupLog)mongoTemplate.findOne(query, BackupLog.class);
        if (backupLog2 != null) {
            backupLog.getFailedFiles().addAll(backupLog2.getFailedFiles());
        }
    }
}

