/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.service.impl;

import com.parablu.bluvault.settings.service.SupportService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.SupportDao;
import com.parablu.pcbd.domain.Support;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupportServiceImpl
implements SupportService {
    private static Logger logger = LogManager.getLogger(SupportServiceImpl.class);
    private SupportDao supportDao;

    public void setSupportDao(SupportDao supportDao) {
        this.supportDao = supportDao;
    }

    @Override
    public void deleteOldSupportLogs(int noOfDays) {
        long startDate = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(noOfDays);
        for (Support support : this.supportDao.getAllLogFiles()) {
            boolean isFileDeleted = true;
            if (Long.parseLong(support.getTimeStamp()) >= startDate) continue;
            try {
                FileUtils.deleteDirectory((File)new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "support/bslogs/" + support.getId()));
            }
            catch (IOException e) {
                isFileDeleted = false;
                logger.debug("Exception while deleting the file" + PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "support/bslogs/" + support.getId());
                logger.debug("Exception while deleting the file " + e.getMessage());
            }
            if (!isFileDeleted) continue;
            this.supportDao.deleteLogFile(support.getId().toString());
        }
    }
}

