/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.service.impl;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.settings.service.SettingsService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.helper.decryption.Encryption;
import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.CloudCustomisableElement;
import com.parablu.paracloud.element.CloudElement;
import com.parablu.paracloud.element.LicenseKeyFileElement;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.SettingsDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.GlobalExcludedFolders;
import com.parablu.pcbd.domain.Proxy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SettingsServiceImpl
implements SettingsService {
    private static Logger logger = LogManager.getLogger(SettingsServiceImpl.class);
    @Resource
    private SettingsDao settingsDao;
    @Resource
    private BluVaultDao bluVaultDao;
    @Autowired
    private LicenseService licenseService;
    private static final String AV_SCAN_ENABLED = "AV Scan Enabled";
    private ExcludedFoldersDao excludedFoldersDao;
    @Autowired
    private BackupPolicyDao backupPolicyDao;
    @Autowired
    private UserDao userDao;
    @Resource
    private CloudDao cloudDao;

    public void setSettingsDao(SettingsDao settingsDao) {
        this.settingsDao = settingsDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setExcludedFoldersDao(ExcludedFoldersDao excludedFoldersDao) {
        this.excludedFoldersDao = excludedFoldersDao;
    }

    public CloudDao getCloudDao() {
        return this.cloudDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public BluVaultDao getBluVaultDao() {
        return this.bluVaultDao;
    }

    public void setBluVaultDao(BluVaultDao bluVaultDao) {
        this.bluVaultDao = bluVaultDao;
    }

    @Override
    public boolean saveProxy(int cloudId, Proxy proxy, boolean isUpdate) {
        return this.settingsDao.saveProxy(cloudId, proxy, isUpdate);
    }

    @Override
    public Proxy getProxy(int cloudId) {
        return this.settingsDao.getProxy(cloudId);
    }

    @Override
    public void saveODBFolderName(int cloudId, String folderName) {
        this.settingsDao.saveODBFolderName(cloudId, folderName);
    }

    @Override
    public int removeProxy(int cloudId, String proxyHost) {
        return this.settingsDao.removeProxy(cloudId, proxyHost);
    }

    @Override
    public boolean editProxy(int cloudId, Proxy proxy) {
        return this.settingsDao.editProxy(cloudId, proxy);
    }

    @Override
    public List<Proxy> getAllProxy(int cloudId) {
        return this.settingsDao.getAllProxy(cloudId);
    }

    @Override
    public Proxy getSpecificProxy(int cloudId, String proxyHost) {
        return this.settingsDao.getSpecificProxy(cloudId, proxyHost);
    }

    @Override
    public void saveDedupStartTime(int cloudId, long dedupStartTime) {
        this.settingsDao.saveDedupStartTime(cloudId, dedupStartTime);
    }

    @Override
    public List<GlobalExcludedFolders> getAllGlobalExclusions(int cloudId) {
        return this.excludedFoldersDao.getAllGlobalExcludedFolders(cloudId);
    }

    @Override
    public List<LicenseKeyFileElement> getListofLicenseKey() {
        try {
            String licenseKeyfolder = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "LicenseKey";
            ArrayList<LicenseKeyFileElement> fileElementList = new ArrayList<LicenseKeyFileElement>();
            String pathTogetEncryptedFiles = licenseKeyfolder + "/encryptedFiles";
            logger.debug(pathTogetEncryptedFiles);
            File f = new File(pathTogetEncryptedFiles);
            File[] files = f.listFiles();
            if (f.exists()) {
                logger.debug("exist..");
            }
            ArrayList listofFiles = new ArrayList();
            for (File f1 : files) {
                LicenseKeyFileElement licenseKeyFileElement = new LicenseKeyFileElement();
                licenseKeyFileElement.setFileName(f1.getName());
                licenseKeyFileElement.setLastModifiedTime(f1.lastModified());
                fileElementList.add(licenseKeyFileElement);
            }
            logger.debug("files size..." + listofFiles.size());
            return fileElementList;
        }
        catch (Exception e) {
            logger.error("error to get licekey list" + e.getMessage());
            return null;
        }
    }

    public boolean checkPublicExist(String publickeyPath) {
        boolean result = false;
        try {
            File f = new File(publickeyPath);
            if (f.exists()) {
                result = true;
            }
            logger.debug("public key exist " + result);
        }
        catch (Exception e) {
            logger.error("error to check public .." + e.getMessage());
        }
        return result;
    }

    public boolean checkdecryption(File encryptedFile, File decryptedFile, String publickeyPath) {
        boolean result = false;
        try {
            ObjectInputStream inputStream = null;
            String licenseKeyfolder = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "LicenseKey";
            inputStream = new ObjectInputStream(new FileInputStream(publickeyPath));
            PublicKey publicKey = (PublicKey)inputStream.readObject();
            if (Encryption.decrypt((File)encryptedFile, (PublicKey)publicKey, (File)decryptedFile)) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error("error" + e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLicense(String encryptedFileName, String operation, HttpServletResponse response, String cloudfromserver, String userName, AuditHistoryService auditHistoryService, Cloud existingClud, int cloudId) {
        File decryptedFile = null;
        File encryptedFile = null;
        try {
            Update update = new Update();
            String licenseKeyfolder = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "LicenseKey";
            String publickeyPath = licenseKeyfolder + "/parablu_public.key";
            decryptedFile = new File(licenseKeyfolder + "/decFile");
            String encryptedFilePath = licenseKeyfolder + "/" + encryptedFileName;
            if (!this.getLicenseKeyFileFromDb(licenseKeyfolder, encryptedFileName)) {
                if (response != null) {
                    response.setStatus(508);
                }
                this.addTamperDetection(encryptedFileName, "License key not found on the server", true);
                logger.debug("after add TamperDetection......");
                this.updateCloud(cloudfromserver);
                auditHistoryService.saveStatisticToDatabase(1, cloudfromserver, "Tampering detected-License key not found on the server", "", "", "Portal", System.currentTimeMillis(), PCActionTypes.LICENSE_KEY.getActionTypeValue());
                this.saveBrandingPropertyToRestartServices(cloudId);
                boolean bl = false;
                return bl;
            }
            encryptedFile = new File(encryptedFilePath);
            logger.debug("..........." + publickeyPath);
            logger.debug("............" + encryptedFilePath);
            logger.debug("............." + encryptedFile.getAbsolutePath());
            if (!this.checkPublicExist(publickeyPath)) {
                logger.debug("public is doesnot exist..");
                response.setStatus(507);
                boolean bl = false;
                return bl;
            }
            if (!this.checkdecryption(encryptedFile, decryptedFile, publickeyPath)) {
                logger.debug("unable to decrypt the file ..");
                response.setStatus(508);
                boolean bl = false;
                return bl;
            }
            PropertiesConfiguration decryptedFileToRead = new PropertiesConfiguration(decryptedFile);
            String cloudnameFromConfig = decryptedFileToRead.getString("cloudName");
            logger.debug("cloud from config" + cloudnameFromConfig + " cloudfromserver " + cloudfromserver);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cloudfromserver) || !cloudfromserver.equals(cloudnameFromConfig)) {
                logger.debug("cloud value is not matching");
                response.setStatus(509);
                boolean bl = false;
                return bl;
            }
            String noOfUsersAllowed = decryptedFileToRead.getString("noOfUsersAllowed");
            String noOfBackupUsersAllowed = decryptedFileToRead.getString("noOfBackupUsersAllowed");
            String noOfSyncUsersAllowed = decryptedFileToRead.getString("noOfSyncUsersAllowed");
            long validityPeriod = Long.parseLong(decryptedFileToRead.getString("validityPeriod"));
            String contentSearchEnabled = decryptedFileToRead.getString("contentSearchEnabled");
            int versioningEnabled = Integer.parseInt(decryptedFileToRead.getString("versioningEnabled"));
            String noOfMiniCloudsAllowed = decryptedFileToRead.getString("noOfMiniCloudsAllowed");
            String noOfOdbBackupUsersAllowed = decryptedFileToRead.getString("noOfOdbBackupUsersAllowed");
            String noOfExchangeBackupUsersAllowed = decryptedFileToRead.getString("noOfExchangeBackupUsersAllowed");
            String cloudSizeAllowed = decryptedFileToRead.getString("cloudSizeAllowed");
            int cloudSizeAllowedInmb = Integer.parseInt(cloudSizeAllowed);
            cloudSizeAllowed = String.valueOf(cloudSizeAllowedInmb *= 1024);
            String sqlLicenseAllowed = decryptedFileToRead.getString("sqlLicenseAllowed");
            String ClamAVLicenseAllowed = decryptedFileToRead.getString("ClamAVLicenseAllowed");
            logger.debug("cloudSizeAllowed ...." + cloudSizeAllowed);
            String noOfDevicesAllowed = decryptedFileToRead.getString("noOfDevicesAllowed");
            update = new Update();
            if (operation.equalsIgnoreCase("apply")) {
                logger.debug("inside apply...");
                boolean bl = this.applyLicenseKey(encryptedFileName, response, cloudfromserver, userName, auditHistoryService, existingClud, noOfUsersAllowed, noOfBackupUsersAllowed, noOfSyncUsersAllowed, validityPeriod, contentSearchEnabled, versioningEnabled, noOfMiniCloudsAllowed, noOfOdbBackupUsersAllowed, noOfExchangeBackupUsersAllowed, cloudSizeAllowed, noOfDevicesAllowed, sqlLicenseAllowed, ClamAVLicenseAllowed, update, cloudId);
                return bl;
            }
            if (operation.equalsIgnoreCase("tamper")) {
                logger.debug("inside tamper...");
                boolean bl = this.tamperLicenseKey(encryptedFileName, response, cloudfromserver, userName, auditHistoryService, existingClud, noOfUsersAllowed, noOfBackupUsersAllowed, noOfSyncUsersAllowed, validityPeriod, contentSearchEnabled, versioningEnabled, noOfMiniCloudsAllowed, noOfOdbBackupUsersAllowed, noOfExchangeBackupUsersAllowed, cloudSizeAllowed, noOfDevicesAllowed, sqlLicenseAllowed, ClamAVLicenseAllowed, update, cloudId);
                return bl;
            }
            if (operation.equalsIgnoreCase("view")) {
                logger.debug("Inside view ...");
                if (this.writeDataToStreamFromPg(response, decryptedFile)) {
                    auditHistoryService.saveStatisticToDatabase(1, cloudfromserver, " viewed the Licensekey file " + encryptedFileName, userName, "", "Portal", System.currentTimeMillis(), PCActionTypes.LICENSE_KEY.getActionTypeValue());
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (ConfigurationException e) {
            logger.error("errror ..." + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("errror ..." + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            logger.debug("inside finally..");
            if (decryptedFile != null && decryptedFile.exists()) {
                decryptedFile.delete();
            }
            if (encryptedFile != null && encryptedFile.exists()) {
                encryptedFile.delete();
            }
        }
        return false;
    }

    @Override
    public void updateCloud(String cloudfromserver) {
        this.cloudDao.updateCloud(cloudfromserver);
    }

    private boolean applyLicenseKey(String encryptedFileName, HttpServletResponse response, String cloudfromserver, String userName, AuditHistoryService auditHistoryService, Cloud existingClud, String noOfUsersAllowed, String noOfBackupUsersAllowed, String noOfSyncUsersAllowed, long validityPeriod, String contentSearchEnabled, int versioningEnabled, String noOfMiniCloudsAllowed, String noOfOdbBackupUsersAllowed, String noOfExchangeBackupUsersAllowed, String cloudSizeAllowed, String noOfDevicesAllowed, String sqlLicenseAllowed, String ClamAVLicenseAllowed, Update update, int cloudId) {
        try {
            Object cloudCustomisableElement;
            CloudElement existingcloudElement = new CloudElement();
            CloudElement newcloudElement = new CloudElement();
            BeanUtils.copyProperties((Object)existingClud, (Object)existingcloudElement);
            BeanUtils.copyProperties((Object)existingClud, (Object)newcloudElement);
            BeanUtils.copyProperties((Object)existingcloudElement, (Object)newcloudElement);
            List cc = existingClud.getCloudCustomisableDetails();
            cc.removeAll(Collections.singleton(null));
            ArrayList<Object> cloudCustomisableElementList = new ArrayList<Object>();
            ArrayList<CloudCustomisableElement> cloudCustomisableRemovableElementList = new ArrayList<CloudCustomisableElement>();
            ArrayList<CloudCustomisableDetails> cloudCustomisableDetailsList = new ArrayList<CloudCustomisableDetails>();
            for (CloudCustomisableDetails cloudCustomisableDetails : cc) {
                cloudCustomisableElement = new CloudCustomisableElement();
                BeanUtils.copyProperties((Object)cloudCustomisableDetails, (Object)cloudCustomisableElement);
                cloudCustomisableElementList.add(cloudCustomisableElement);
            }
            cloudCustomisableElementList.removeAll(Collections.singleton(null));
            logger.debug(newcloudElement.toString());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfUsersAllowed)) {
                update.set("noOfUsersAllowed", (Object)noOfUsersAllowed);
                newcloudElement.setNoOfUsersAllowed(Integer.parseInt(noOfUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfBackupUsersAllowed)) {
                update.set("noOfBackupUsersAllowed", (Object)noOfBackupUsersAllowed);
                newcloudElement.setNoOfBackupUsersAllowed(Integer.parseInt(noOfBackupUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfOdbBackupUsersAllowed)) {
                update.set("noOfOneDriveUsersAllowed", (Object)noOfOdbBackupUsersAllowed);
                newcloudElement.setNoOfOneDriveUsersAllowed(Integer.parseInt(noOfOdbBackupUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfExchangeBackupUsersAllowed)) {
                update.set("noOfExchangeUsersAllowed", (Object)noOfExchangeBackupUsersAllowed);
                newcloudElement.setNoOfExchangeUsersAllowed(Integer.parseInt(noOfExchangeBackupUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfMiniCloudsAllowed)) {
                update.set("noOfMiniCloudsAllowed", (Object)noOfMiniCloudsAllowed);
                newcloudElement.setNoOfMiniCloudsAllowed(Integer.parseInt(noOfMiniCloudsAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contentSearchEnabled)) {
                newcloudElement.setContentSearchEnabled(Integer.parseInt(contentSearchEnabled));
                update.set("contentSearchEnabled", (Object)contentSearchEnabled);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfSyncUsersAllowed)) {
                update.set("noOfSyncUsersAllowed", (Object)noOfSyncUsersAllowed);
                newcloudElement.setNoOfSyncUsersAllowed(Integer.parseInt(noOfSyncUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cloudSizeAllowed)) {
                update.set("cloudSizeAllowed", (Object)cloudSizeAllowed);
                newcloudElement.setCloudSizeAllowed(Integer.parseInt(cloudSizeAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfDevicesAllowed)) {
                update.set("noOfDevicesAllowed", (Object)noOfDevicesAllowed);
                newcloudElement.setNoOfDevicesAllowed(Integer.parseInt(noOfDevicesAllowed));
            }
            ObjectId sqlBackupId = this.getSqlLicenseEnabled(existingClud.getCloudId());
            ObjectId clamavId = this.getClamAVScanEnabled(existingClud.getCloudId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sqlLicenseAllowed) && sqlLicenseAllowed.equals("1")) {
                cloudCustomisableElement = new CloudCustomisableElement();
                cloudCustomisableElement.setId(sqlBackupId);
                cloudCustomisableElement.setName("SQL Backup Enabled");
                if (!cloudCustomisableElementList.contains(cloudCustomisableElement)) {
                    cloudCustomisableElementList.add(cloudCustomisableElement);
                }
                newcloudElement.setCloudCustomisableDetails(cloudCustomisableElementList);
            } else {
                cloudCustomisableElementList.removeAll(Collections.singleton(null));
                if (!CollectionUtils.isEmpty(cloudCustomisableElementList)) {
                    for (CloudCustomisableElement cloudCustomisableElement2 : cloudCustomisableElementList) {
                        if (sqlBackupId == null || !cloudCustomisableElement2.getId().equals((Object)sqlBackupId)) continue;
                        cloudCustomisableRemovableElementList.add(cloudCustomisableElement2);
                    }
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ClamAVLicenseAllowed) && ClamAVLicenseAllowed.equals("1")) {
                cloudCustomisableElement = new CloudCustomisableElement();
                cloudCustomisableElement.setId(clamavId);
                cloudCustomisableElement.setName(AV_SCAN_ENABLED);
                if (!cloudCustomisableElementList.contains(cloudCustomisableElement)) {
                    cloudCustomisableElementList.add(cloudCustomisableElement);
                }
                newcloudElement.setCloudCustomisableDetails(cloudCustomisableElementList);
            } else {
                cloudCustomisableElementList.removeAll(Collections.singleton(null));
                if (!CollectionUtils.isEmpty(cloudCustomisableElementList)) {
                    for (Object cloudCustomisableElement2 : cloudCustomisableElementList) {
                        if (clamavId == null || !cloudCustomisableElement2.getId().equals((Object)clamavId)) continue;
                        cloudCustomisableRemovableElementList.add((CloudCustomisableElement)cloudCustomisableElement2);
                    }
                }
            }
            cloudCustomisableElementList.removeAll(cloudCustomisableRemovableElementList);
            if (validityPeriod != 0L) {
                update.set("validityPeriod", (Object)validityPeriod);
                newcloudElement.setValidityPeriod(validityPeriod);
            }
            update.set("versioningEnabled", (Object)versioningEnabled);
            update.set("licenseKeyFileName", (Object)encryptedFileName);
            newcloudElement.setVersioningEnabled(versioningEnabled);
            newcloudElement.setLicenseKeyFileName(encryptedFileName);
            Cloud cloud = new Cloud();
            BeanUtils.copyProperties((Object)newcloudElement, (Object)cloud);
            cloud.setId(existingClud.getId());
            cloud.setCloudId(existingClud.getCloudId(), existingClud.getCloudName());
            cloud.setCloudCustomisableDetails(new ArrayList());
            for (CloudCustomisableElement cloudCustomisableElement3 : cloudCustomisableElementList) {
                CloudCustomisableDetails cloudCustomisableDetails = new CloudCustomisableDetails();
                BeanUtils.copyProperties((Object)cloudCustomisableElement3, (Object)cloudCustomisableDetails);
                cloudCustomisableDetailsList.add(cloudCustomisableDetails);
            }
            cloud.setCloudCustomisableDetails(cloudCustomisableDetailsList);
            String changedField = this.findCloudPropertyDiff(existingcloudElement, newcloudElement, existingcloudElement.getCloudId(), existingClud, cloud);
            logger.debug("........changedField........" + changedField);
            if (this.cloudDao.updateCloud(cloudfromserver, cloud)) {
                this.licenseService.reInitialiseCloudMappings();
                this.saveBrandingPropertyToRestartServices(cloudId);
                auditHistoryService.saveStatisticToDatabase(1, cloudfromserver, " applied the Licensekey file " + encryptedFileName, userName, "", "Portal", System.currentTimeMillis(), PCActionTypes.LICENSE_KEY.getActionTypeValue());
                logger.debug("#####spply finshed successfully");
                return true;
            }
            response.setStatus(507);
            logger.debug("#####failed to updare values in db ..");
            return false;
        }
        catch (BeansException e) {
            logger.error("error ..." + e.getMessage());
        }
        catch (NumberFormatException e) {
            logger.error("error ..." + e.getMessage());
        }
        catch (Exception e) {
            logger.error("error ..." + e.getMessage());
        }
        return false;
    }

    private boolean tamperLicenseKey(String encryptedFileName, HttpServletResponse response, String cloudfromserver, String userName, AuditHistoryService auditHistoryService, Cloud existingClud, String noOfUsersAllowed, String noOfBackupUsersAllowed, String noOfSyncUsersAllowed, long validityPeriod, String contentSearchEnabled, int versioningEnabled, String noOfMiniCloudsAllowed, String noOfOdbBackupUsersAllowed, String noOfExchangeBackupUsersAllowed, String cloudSizeAllowed, String noOfDevicesAllowed, String sqlLicenseAllowed, String ClamAVLicenseAllowed, Update update, int cloudId) {
        try {
            Object cloudCustomisableElement;
            CloudElement existingcloudElement = new CloudElement();
            CloudElement newcloudElement = new CloudElement();
            BeanUtils.copyProperties((Object)existingClud, (Object)existingcloudElement);
            BeanUtils.copyProperties((Object)existingClud, (Object)newcloudElement);
            BeanUtils.copyProperties((Object)existingcloudElement, (Object)newcloudElement);
            List cc = existingClud.getCloudCustomisableDetails();
            cc.removeAll(Collections.singleton(null));
            ArrayList<Object> cloudCustomisableElementList = new ArrayList<Object>();
            ArrayList<CloudCustomisableElement> cloudCustomisableRemovableElementList = new ArrayList<CloudCustomisableElement>();
            ArrayList<CloudCustomisableDetails> cloudCustomisableDetailsList = new ArrayList<CloudCustomisableDetails>();
            for (CloudCustomisableDetails cloudCustomisableDetails : cc) {
                cloudCustomisableElement = new CloudCustomisableElement();
                BeanUtils.copyProperties((Object)cloudCustomisableDetails, (Object)cloudCustomisableElement);
                cloudCustomisableElementList.add(cloudCustomisableElement);
            }
            cloudCustomisableElementList.removeAll(Collections.singleton(null));
            logger.debug(newcloudElement.toString());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfUsersAllowed)) {
                update.set("noOfUsersAllowed", (Object)noOfUsersAllowed);
                newcloudElement.setNoOfUsersAllowed(Integer.parseInt(noOfUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfBackupUsersAllowed)) {
                update.set("noOfBackupUsersAllowed", (Object)noOfBackupUsersAllowed);
                newcloudElement.setNoOfBackupUsersAllowed(Integer.parseInt(noOfBackupUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfOdbBackupUsersAllowed)) {
                update.set("noOfOneDriveUsersAllowed", (Object)noOfOdbBackupUsersAllowed);
                newcloudElement.setNoOfOneDriveUsersAllowed(Integer.parseInt(noOfOdbBackupUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfExchangeBackupUsersAllowed)) {
                update.set("noOfExchangeUsersAllowed", (Object)noOfExchangeBackupUsersAllowed);
                newcloudElement.setNoOfExchangeUsersAllowed(Integer.parseInt(noOfExchangeBackupUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfMiniCloudsAllowed)) {
                update.set("noOfMiniCloudsAllowed", (Object)noOfMiniCloudsAllowed);
                newcloudElement.setNoOfMiniCloudsAllowed(Integer.parseInt(noOfMiniCloudsAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contentSearchEnabled)) {
                newcloudElement.setContentSearchEnabled(Integer.parseInt(contentSearchEnabled));
                update.set("contentSearchEnabled", (Object)contentSearchEnabled);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfSyncUsersAllowed)) {
                update.set("noOfSyncUsersAllowed", (Object)noOfSyncUsersAllowed);
                newcloudElement.setNoOfSyncUsersAllowed(Integer.parseInt(noOfSyncUsersAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cloudSizeAllowed)) {
                update.set("cloudSizeAllowed", (Object)cloudSizeAllowed);
                newcloudElement.setCloudSizeAllowed(Integer.parseInt(cloudSizeAllowed));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noOfDevicesAllowed)) {
                update.set("noOfDevicesAllowed", (Object)noOfDevicesAllowed);
                newcloudElement.setNoOfDevicesAllowed(Integer.parseInt(noOfDevicesAllowed));
            }
            if (validityPeriod != 0L) {
                update.set("validityPeriod", (Object)validityPeriod);
                newcloudElement.setValidityPeriod(validityPeriod);
            }
            ObjectId sqlBackupId = this.getSqlLicenseEnabled(existingClud.getCloudId());
            ObjectId clamavId = this.getClamAVScanEnabled(existingClud.getCloudId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sqlLicenseAllowed) && sqlLicenseAllowed.equals("1")) {
                cloudCustomisableElement = new CloudCustomisableElement();
                cloudCustomisableElement.setId(sqlBackupId);
                cloudCustomisableElement.setName("SQL Backup Enabled");
                if (!cloudCustomisableElementList.contains(cloudCustomisableElement)) {
                    cloudCustomisableElementList.add(cloudCustomisableElement);
                }
                newcloudElement.setCloudCustomisableDetails(cloudCustomisableElementList);
            } else {
                cloudCustomisableElementList.removeAll(Collections.singleton(null));
                if (!CollectionUtils.isEmpty(cloudCustomisableElementList)) {
                    for (CloudCustomisableElement cloudCustomisableElement2 : cloudCustomisableElementList) {
                        if (sqlBackupId == null || !cloudCustomisableElement2.getId().equals((Object)sqlBackupId)) continue;
                        cloudCustomisableRemovableElementList.add(cloudCustomisableElement2);
                    }
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ClamAVLicenseAllowed) && ClamAVLicenseAllowed.equals("1")) {
                cloudCustomisableElement = new CloudCustomisableElement();
                cloudCustomisableElement.setId(clamavId);
                cloudCustomisableElement.setName("ClamAV Scan Enabled");
                if (!cloudCustomisableElementList.contains(cloudCustomisableElement)) {
                    cloudCustomisableElementList.add(cloudCustomisableElement);
                }
                newcloudElement.setCloudCustomisableDetails(cloudCustomisableElementList);
            } else {
                cloudCustomisableElementList.removeAll(Collections.singleton(null));
                if (!CollectionUtils.isEmpty(cloudCustomisableElementList)) {
                    for (Object cloudCustomisableElement2 : cloudCustomisableElementList) {
                        if (clamavId == null || !cloudCustomisableElement2.getId().equals((Object)clamavId)) continue;
                        cloudCustomisableRemovableElementList.add((CloudCustomisableElement)cloudCustomisableElement2);
                    }
                }
            }
            cloudCustomisableElementList.removeAll(cloudCustomisableRemovableElementList);
            update.set("versioningEnabled", (Object)versioningEnabled);
            newcloudElement.setVersioningEnabled(versioningEnabled);
            Cloud cloud = new Cloud();
            BeanUtils.copyProperties((Object)newcloudElement, (Object)cloud);
            cloud.setCloudId(existingClud.getCloudId(), existingClud.getCloudName());
            cloud.setCloudCustomisableDetails(new ArrayList());
            for (CloudCustomisableElement cloudCustomisableElement3 : cloudCustomisableElementList) {
                CloudCustomisableDetails cloudCustomisableDetails = new CloudCustomisableDetails();
                BeanUtils.copyProperties((Object)cloudCustomisableElement3, (Object)cloudCustomisableDetails);
                cloudCustomisableDetailsList.add(cloudCustomisableDetails);
            }
            cloud.setCloudCustomisableDetails(cloudCustomisableDetailsList);
            cloud.setId(existingClud.getId());
            String changedField = this.findCloudPropertyDiff(existingcloudElement, newcloudElement, cloud.getCloudId(), existingClud, cloud);
            if (StringUtils.isNotEmpty((String)changedField)) {
                logger.debug("...tamper suspected..");
                if (this.cloudDao.updateCloud(cloudfromserver, cloud)) {
                    if (changedField.trim().endsWith(",")) {
                        changedField = changedField.trim();
                        changedField = changedField.substring(0, changedField.length() - 1);
                        logger.debug(".changedField.." + changedField);
                    }
                    logger.debug("before saving tampering details.....");
                    String string = changedField.replace("\"", "");
                    long tamperDetectedTime = System.currentTimeMillis();
                    this.cloudDao.addTamperDetection(encryptedFileName, tamperDetectedTime, string, true);
                    logger.debug(tamperDetectedTime + "..." + string);
                    logger.debug("before saving branding...");
                    this.saveBrandingPropertyToRestartServices(cloudId);
                    auditHistoryService.saveStatisticToDatabase(1, cloudfromserver, "Tampering detected. " + encryptedFileName + "" + changedField, "", "", "Portal", System.currentTimeMillis(), PCActionTypes.LICENSE_KEY.getActionTypeValue());
                    logger.debug("#####tamper finshed successfully");
                    return true;
                }
                response.setStatus(507);
                logger.debug("#####failed to updare values in db ..");
                return false;
            }
            this.addTamperDetection(encryptedFileName, "", false);
            logger.debug(".... no Tamper found .......");
        }
        catch (BeansException e) {
            logger.error("error ..." + e.getMessage());
        }
        catch (NumberFormatException e) {
            logger.error("error ..." + e.getMessage());
        }
        catch (Exception e) {
            logger.error("error ..." + e.getMessage());
        }
        return false;
    }

    private boolean writeDataToStreamFromPg(HttpServletResponse response, File file) {
        boolean result = false;
        try {
            int buff;
            logger.debug("SENDING_FILE" + file.getName());
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            ((InputStream)fif).close();
            response.getOutputStream().flush();
            result = true;
            logger.debug("FINISHED_FILE" + file.getName());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
            return false;
        }
        return result;
    }

    private String findCloudPropertyDiff(CloudElement existingCloudElement, CloudElement CloudElement2, int cloudId, Cloud oldCloud, Cloud newCloud) {
        String avbackupExisting;
        StringBuilder changedFields = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder((Object)existingCloudElement, (Object)CloudElement2);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList changes = new ArrayList(objectDiffFinder.changes);
        HashMap<String, String> fieldChanges = new HashMap<String, String>();
        for (Map change : changes) {
            Set keys = change.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String key : keys) {
                if (change.get(key) != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)change.get(key).toString()) && key.contains("newValue")) {
                    newValue = change.get(key).toString();
                }
                if (key.contains("propertyName")) {
                    propertyName = change.get(key).toString();
                }
                if (change.get(key) == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)change.get(key).toString()) || !key.contains("oldValue")) continue;
                oldValue = change.get(key).toString();
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)propertyName)) {
                fieldChanges.put(propertyName, "\"" + newValue + "\" => \"" + oldValue + "\"");
                logger.debug("Actual Data" + propertyName + "\"" + newValue + "\" => \"" + oldValue + "\"");
                continue;
            }
            logger.debug("field changes is empty ");
        }
        for (String field : fieldChanges.keySet()) {
            String key = field;
            key = key.contains("cloudSizeAllowed") ? "CloudSize Allowed" : (key.contains("contentSearchEnabled") ? "ContentSearch Enabled" : (key.contains("noOfBackupUsersAllowed") ? "Number Of Backup Users Allowed" : (key.contains("noOfDevicesAllowed") ? "Number Of Devices Allowed" : (key.contains("noOfMiniCloudsAllowed") ? "Number Of MiniClouds Allowed" : (key.contains("noOfSyncUsersAllowed") ? "Number Of Sync Users Allowed" : (key.contains("noOfUsersAllowed") ? "Number Of Users Allowed" : (key.contains("validityPeriod") ? "Parablu Installation valid Until" : (key.contains("versioningEnabled") ? "Versions Enabled" : (key.contains("graphApiEnabled") ? "GraphApi Enabled" : (key.contains("noOfOneDriveUsersAllowed") ? "Number Of OneDrive Users Allowed" : (key.contains("noOfExchangeUsersAllowed") ? "Number Of Exchange Users Allowed" : (key.contains("cloudCustomisableDetails") ? "" : ""))))))))))));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)key)) {
                fieldChanges.get(field);
                changedFields.append(" (");
                changedFields.append(key);
                changedFields.append(" values ");
                changedFields.append((String)fieldChanges.get(field));
                changedFields.append(")");
                if (key.length() > 1) {
                    changedFields.append(", ");
                }
                logger.debug("changed fields *************** " + changedFields.toString());
                continue;
            }
            logger.debug("Key is empty *******************");
        }
        boolean isclamAVEnabledInexisiting = this.isClamAVScanEnabled(oldCloud);
        boolean isclamAVEnabledInKey = this.isClamAVScanEnabled(newCloud);
        boolean issqlBackupInexisiting = this.isSQLBackupEnabled(oldCloud);
        boolean issqlBackupInInKey = this.isSQLBackupEnabled(newCloud);
        String sqlbackup = Boolean.toString(issqlBackupInInKey);
        String sqlbackupExisting = Boolean.toString(issqlBackupInexisiting);
        String avbackup = Boolean.toString(isclamAVEnabledInKey);
        if (!avbackup.equals(avbackupExisting = Boolean.toString(isclamAVEnabledInexisiting))) {
            logger.debug("...tamper found for clam av license.......");
            changedFields.append("(AV Scan Enabled " + isclamAVEnabledInKey + " => " + isclamAVEnabledInexisiting + " )");
            changedFields.append(",");
        }
        if (!sqlbackup.equals(sqlbackupExisting)) {
            logger.debug("...tamper found for sql backup license.......");
            changedFields.append("(SQL Backup Enabled " + issqlBackupInInKey + " => " + issqlBackupInexisiting + " ) ");
        }
        if (changedFields.length() > 0) {
            changedFields.replace(changedFields.length() - 1, changedFields.length(), " ");
        }
        logger.debug("the changed fields are " + changedFields.toString());
        return changedFields.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveLicenseKeyFileInDb(String fileName, String filePath) {
        File f = null;
        try {
            long lastModifiedTime = this.getFileModifiedTime(fileName, filePath);
            logger.debug("before saveFileInDb...." + filePath + fileName + " .." + lastModifiedTime);
            this.cloudDao.saveFile(fileName, filePath, lastModifiedTime);
            f = new File(filePath + "/" + fileName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("error to save file .." + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    public boolean getLicenseKeyFileFromDb(String fileName, String filePath) {
        try {
            logger.debug("before get FileInDb....");
            if (this.cloudDao.getLicenseKeyFile(fileName, filePath)) {
                logger.debug("file exists..");
                return true;
            }
            logger.debug("file doesnot exists..");
            return false;
        }
        catch (Exception e) {
            logger.error("error to save file .." + e.getMessage());
            return false;
        }
    }

    @Override
    public List<LicenseKeyFileElement> getLicenseKeyListFromDb() {
        List licenseKeyFileElementList = null;
        try {
            licenseKeyFileElementList = this.cloudDao.getLicenseKeyList();
        }
        catch (Exception e) {
            logger.error("error to save file .." + e.getMessage());
        }
        return licenseKeyFileElementList;
    }

    @Override
    public void saveBrandingPropertyToRestartServices(int cloudId) {
        List allGateways = this.bluVaultDao.getAllBluVaults(cloudId, "");
        for (BluVault gateway : allGateways) {
            logger.debug(".....allGateways...." + gateway.getBluVaultName());
            Map componentsProperties = gateway.getComponentsProperties();
            if (gateway == null || CollectionUtils.isEmpty((Map)componentsProperties)) continue;
            componentsProperties.put("brandingPropertyUpdated", "true");
            gateway.setComponentsProperties(componentsProperties);
            logger.debug(".....allGateways...." + (String)gateway.getComponentsProperties().get("brandingPropertyUpdated"));
            this.bluVaultDao.saveBluVault(cloudId, "", gateway);
        }
    }

    public long getFileModifiedTime(String encryptedFileName, String encryptedFileFolderPath) {
        File decryptedFile = null;
        File encryptedFile = null;
        long lastModifiedTime = 0L;
        try {
            String licenseKeyfolder = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "LicenseKey";
            String publickeyPath = licenseKeyfolder + "/parablu_public.key";
            decryptedFile = new File(licenseKeyfolder + "/decFile");
            String encryptedFilePath = encryptedFileFolderPath + "/" + encryptedFileName;
            encryptedFile = new File(encryptedFilePath);
            logger.debug("..........." + publickeyPath);
            logger.debug("............" + encryptedFilePath);
            logger.debug("............." + encryptedFile.getAbsolutePath());
            if (!this.checkPublicExist(publickeyPath)) {
                logger.debug("public is doesnot exist..");
                return lastModifiedTime;
            }
            if (!this.checkdecryption(encryptedFile, decryptedFile, publickeyPath)) {
                logger.debug("unable to decrypt the file ..");
                return lastModifiedTime;
            }
            PropertiesConfiguration decryptedFileToRead = new PropertiesConfiguration(decryptedFile);
            String cloudnameFromConfig = decryptedFileToRead.getString("cloudName");
            String creationDate = decryptedFileToRead.getString("creationDate");
            logger.debug("cloud from config" + cloudnameFromConfig + ".." + creationDate);
            lastModifiedTime = Long.valueOf(creationDate);
            return lastModifiedTime;
        }
        catch (ConfigurationException e) {
            logger.error("error to get last modfied time" + e.getMessage());
            return lastModifiedTime;
        }
    }

    @Override
    public void addTamperDetection(String licenseKeyFile, String changedFiedls, boolean tamperDetected) {
        long tamperDetectedTime = System.currentTimeMillis();
        this.cloudDao.addTamperDetection(licenseKeyFile, tamperDetectedTime, changedFiedls, tamperDetected);
    }

    private ObjectId getClamAVScanEnabled(int cloudId) {
        List cloudCustomisableDetailsList = this.cloudDao.getCloudCustomizable(cloudId);
        cloudCustomisableDetailsList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)cloudCustomisableDetailsList)) {
            for (CloudCustomisableDetails cloudPluginDetails : cloudCustomisableDetailsList) {
                if (cloudPluginDetails == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !AV_SCAN_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                logger.debug("........." + cloudPluginDetails.getId());
                return cloudPluginDetails.getId();
            }
        }
        return null;
    }

    private ObjectId getSqlLicenseEnabled(int cloudId) {
        List cloudCustomisableDetailsList = this.cloudDao.getCloudCustomizable(cloudId);
        cloudCustomisableDetailsList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)cloudCustomisableDetailsList)) {
            for (CloudCustomisableDetails cloudPluginDetails : cloudCustomisableDetailsList) {
                if (cloudPluginDetails == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"SQL Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                logger.debug("........." + cloudPluginDetails.getId());
                return cloudPluginDetails.getId();
            }
        }
        return null;
    }

    private boolean isSQLBackupEnabled(Cloud cl) {
        boolean isSQLBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"SQL Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSQLBackupEnabled = true;
                break;
            }
        }
        logger.debug("SQL Backup Enabled" + isSQLBackupEnabled);
        return isSQLBackupEnabled;
    }

    private boolean isClamAVScanEnabled(Cloud cl) {
        boolean isClamAVScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !AV_SCAN_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isClamAVScanEnabled = true;
                break;
            }
        }
        logger.debug("is ClamAV Scan Enabled...." + isClamAVScanEnabled);
        return isClamAVScanEnabled;
    }

    @Override
    public boolean updateAllBkpPolicyModifiedTime(int cloudId) {
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        if (CollectionUtils.isEmpty((Collection)backupPolicies)) {
            logger.debug("no policies found to update..");
            return true;
        }
        for (BackupPolicy backupPolicy : backupPolicies) {
            this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            this.userDao.updateBackupPolicyModifiedTime(cloudId, backupPolicy.getPolicyName());
        }
        return true;
    }
}

