/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.service.impl;

import com.parablu.bluvault.settings.service.ODBConnectorSettingService;
import com.parablu.paracloud.element.ODBConnectorSettingElement;
import com.parablu.pcbd.dao.ODBConnectorSettingDao;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.ODBConnectorSetting;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ODBConnectorSettingServiceImpl
implements ODBConnectorSettingService {
    private static Logger logger = LogManager.getLogger(ODBConnectorSettingServiceImpl.class);
    @Autowired
    private ODBConnectorSettingDao odbConnectorSettingDao;

    public ODBConnectorSettingDao getConnectorSettingDao() {
        return this.odbConnectorSettingDao;
    }

    public void setConnectorSettingDao(ODBConnectorSettingDao odbConnectorSettingDao) {
        this.odbConnectorSettingDao = odbConnectorSettingDao;
    }

    @Override
    public ODBConnectorSettingElement saveODBConnectorSettings(int cloudId, String cloudName, ODBConnectorSettingElement odbConnectorSettingElement) {
        logger.debug(" inside saveODBConnectorSettings...... ");
        ODBConnectorSetting odbConnectorSetting = this.convertElementToDomain(odbConnectorSettingElement);
        this.odbConnectorSettingDao.saveODBConnectorSettingsToDB(cloudId, odbConnectorSetting);
        return this.convertDomainToElement(odbConnectorSetting);
    }

    @Override
    public ODBConnectorSettingElement updateODBConnectorSettingByConfigId(int cloudId, String configId, ODBConnectorSettingElement odbConnectorSettingElement) {
        ODBConnectorSetting oldODBConnectorSetting = this.odbConnectorSettingDao.getConnectorSettingByConfigId(cloudId, configId);
        if (oldODBConnectorSetting == null) {
            return null;
        }
        oldODBConnectorSetting.setClientId(odbConnectorSettingElement.getClientId());
        oldODBConnectorSetting.setClientRedirectURI(odbConnectorSettingElement.getClientRedirectURI());
        oldODBConnectorSetting.setClientResourceURL(odbConnectorSettingElement.getClientResourceURL());
        oldODBConnectorSetting.setClientSecretKey(odbConnectorSettingElement.getClientSecretKey());
        oldODBConnectorSetting.setPortalURL(odbConnectorSettingElement.getPortalURL());
        oldODBConnectorSetting.setClientTokenURL(odbConnectorSettingElement.getClientTokenURL());
        oldODBConnectorSetting.setAppName(odbConnectorSettingElement.getAppName());
        this.odbConnectorSettingDao.saveODBConnectorSettingsToDB(cloudId, oldODBConnectorSetting);
        return this.convertDomainToElement(oldODBConnectorSetting);
    }

    @Override
    public ODBConnectorSettingElement getODBConnectorSettingImage(int cloudId) {
        List odbConnectorSettings = this.odbConnectorSettingDao.getAllConnectorSettingImages(cloudId);
        if (odbConnectorSettings == null || odbConnectorSettings.isEmpty()) {
            return null;
        }
        ODBConnectorSetting odbConnectorSetting = (ODBConnectorSetting)odbConnectorSettings.get(0);
        return this.convertDomainToElement(odbConnectorSetting);
    }

    private ODBConnectorSettingElement convertDomainToElement(ODBConnectorSetting odbConnectorSetting) {
        ODBConnectorSettingElement odbConnectorSettingElement = new ODBConnectorSettingElement();
        odbConnectorSettingElement.setClientId(odbConnectorSetting.getClientId());
        odbConnectorSettingElement.setClientRedirectURI(odbConnectorSetting.getClientRedirectURI());
        odbConnectorSettingElement.setClientResourceURL(odbConnectorSetting.getClientResourceURL());
        odbConnectorSettingElement.setClientSecretKey(odbConnectorSetting.getClientSecretKey());
        odbConnectorSettingElement.setPortalURL(odbConnectorSetting.getPortalURL());
        odbConnectorSettingElement.setConfigId(odbConnectorSetting.getId().toString());
        odbConnectorSettingElement.setClientTokenURL(odbConnectorSetting.getClientTokenURL());
        odbConnectorSettingElement.setAppName(odbConnectorSetting.getAppName());
        return odbConnectorSettingElement;
    }

    private ODBConnectorSetting convertElementToDomain(ODBConnectorSettingElement odSettingElements) {
        ODBConnectorSetting connector = new ODBConnectorSetting();
        connector.setClientId(odSettingElements.getClientId());
        connector.setClientRedirectURI(odSettingElements.getClientRedirectURI());
        connector.setClientResourceURL(odSettingElements.getClientResourceURL());
        connector.setClientSecretKey(odSettingElements.getClientSecretKey());
        connector.setPortalURL(odSettingElements.getPortalURL());
        connector.setClientTokenURL(odSettingElements.getClientTokenURL());
        connector.setAppName(odSettingElements.getAppName());
        return connector;
    }

    @Override
    public ODBConnectorSettingElement getMSAppSettingsDetails(int cloudId) {
        MSAppSetting msAppSetting = this.odbConnectorSettingDao.getMSAppSettingsDetails(cloudId);
        return this.convertDomainToElement(msAppSetting);
    }

    @Override
    public ODBConnectorSettingElement updateMSAppSettingsDetailsByConfigId(int cloudId, String configId, ODBConnectorSettingElement odbConnectorSettingElement) {
        MSAppSetting msAppSetting = this.odbConnectorSettingDao.getMSAppSettingsDetailsByConfigId(cloudId, configId);
        if (msAppSetting == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)odbConnectorSettingElement, (Object)msAppSetting);
        this.odbConnectorSettingDao.saveMSAppSettingsDetails(cloudId, msAppSetting);
        return this.convertDomainToElement(msAppSetting);
    }

    private ODBConnectorSettingElement convertDomainToElement(MSAppSetting msAppSetting) {
        ODBConnectorSettingElement odbConnectorSettingElement = new ODBConnectorSettingElement();
        if (msAppSetting != null) {
            BeanUtils.copyProperties((Object)msAppSetting, (Object)odbConnectorSettingElement);
        }
        return odbConnectorSettingElement;
    }

    private ODBConnectorSettingElement convertDomainToElement(EWSAppSetting ewsAppSetting) {
        ODBConnectorSettingElement odbConnectorSettingElement = new ODBConnectorSettingElement();
        if (ewsAppSetting != null) {
            BeanUtils.copyProperties((Object)ewsAppSetting, (Object)odbConnectorSettingElement);
        }
        return odbConnectorSettingElement;
    }

    @Override
    public ODBConnectorSettingElement saveMSAppSettingsDetails(int cloudId, ODBConnectorSettingElement odbConnectorSettingElement) {
        MSAppSetting msAppSetting = new MSAppSetting();
        BeanUtils.copyProperties((Object)odbConnectorSettingElement, (Object)msAppSetting);
        this.odbConnectorSettingDao.saveMSAppSettingsDetails(cloudId, msAppSetting);
        return this.convertDomainToElement(msAppSetting);
    }

    @Override
    public ODBConnectorSettingElement getEWSAppSettingsDetails(int cloudId) {
        EWSAppSetting appSetting = this.odbConnectorSettingDao.getEwsAppSettingDetail(cloudId);
        return this.convertDomainToElement(appSetting);
    }

    @Override
    public ODBConnectorSettingElement updateEWSAppSettingsDetailsByConfigId(int cloudId, String configId, ODBConnectorSettingElement odbConnectorSettingElement) {
        EWSAppSetting msAppSetting = this.odbConnectorSettingDao.getEWAppSettingsDetailsByConfigId(cloudId, configId);
        if (msAppSetting == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)odbConnectorSettingElement, (Object)msAppSetting);
        this.odbConnectorSettingDao.saveEWSAppSettingsDetails(cloudId, msAppSetting);
        return this.convertDomainToElement(msAppSetting);
    }

    @Override
    public ODBConnectorSettingElement saveEWSAppSettingsDetails(int cloudId, ODBConnectorSettingElement odbConnectorSettingElement) {
        EWSAppSetting msAppSetting = new EWSAppSetting();
        BeanUtils.copyProperties((Object)odbConnectorSettingElement, (Object)msAppSetting);
        this.odbConnectorSettingDao.saveEWSAppSettingsDetails(cloudId, msAppSetting);
        return this.convertDomainToElement(msAppSetting);
    }
}

