/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.service.impl;

import com.parablu.bluvault.settings.exceptions.ResourceFunnelException;
import com.parablu.bluvault.settings.service.LocalFileSystemService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.httpclient.util.HttpClientUtil;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.LocalFileSystemElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.util.FileTypeHelper;
import com.parablu.pcbd.dao.ConsolidatedImageDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.LocalFileSystemDao;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.LocalFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LocalFileSystemServiceImpl
implements LocalFileSystemService {
    @Resource
    private LocalFileSystemDao localFileSystemDao;
    private static final String IO_EXCEPTION = " IOException  :";
    private static final String RESPONSE_CODE_NOT_200 = "Response Code not 200 ";
    private static Logger logger = LogManager.getLogger(LocalFileSystemServiceImpl.class);
    private static final String CONTENT_SEARCH_URL_PARAMETERS = "/search/content";
    private ConsolidatedImageDao consolidatedImageDao;
    private FileRevisionDao fileRevisionDao;

    public void setConsolidatedImageDao(ConsolidatedImageDao consolidatedImageDao) {
        this.consolidatedImageDao = consolidatedImageDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    @Override
    public void saveLocalFileSystemDetails(int cloudId, LocalFileSystemElement fileSystemElement) {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        BeanUtils.copyProperties((Object)fileSystemElement, (Object)localFileSystem);
        this.localFileSystemDao.saveLocalFileSystemDetails(cloudId, localFileSystem);
    }

    @Override
    public LocalFileSystemElement getLocalFileSystemDetails(int cloudId) {
        LocalFileSystemElement fileSystemElement = new LocalFileSystemElement();
        LocalFileSystem localFileSystem = this.localFileSystemDao.getLocalFileSystemDetails(cloudId);
        BeanUtils.copyProperties((Object)localFileSystem, (Object)fileSystemElement);
        return fileSystemElement;
    }

    @Override
    public FileListElement forwardContentSearchRequestToSearchServer(int cloudId, String cloudName, Map<String, String> headerMap, MiniCloudElementList cloudElementList, String userName) throws Exception {
        logger.debug(" Inside forwardContentSearchRequestToSearchServer content ...............");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PCHelperConstant.getPropertyFileValueSolrBaseUrl() + "cloudId/").append(cloudId).append(CONTENT_SEARCH_URL_PARAMETERS);
        if (PCHelperConstant.getPropertyFileValueSolrBaseUrl().contains("https:")) {
            return this.httpsOutput(headerMap, cloudElementList, userName, stringBuilder);
        }
        return this.httpOutput(headerMap, cloudElementList, userName, stringBuilder);
    }

    @Override
    public List<FileElement> searchForFiles(int cloudId, String cloudName, Map<String, String> headerMap, MiniCloudElementList cloudElementList, String userName) throws Exception {
        int start = Integer.parseInt(headerMap.get("start"));
        int rows = Integer.parseInt(headerMap.get("rows"));
        String fileName = headerMap.get("file-name");
        String filePath = headerMap.get("file-path");
        List consolidatedImages = this.consolidatedImageDao.getSearchResultIdsForFile(cloudId, userName, cloudName, fileName, filePath, start, rows, cloudElementList);
        List<Object> fileRevisions = new ArrayList<FileRevision>();
        if (!consolidatedImages.isEmpty()) {
            fileRevisions = this.fileRevisionDao.getLatestByRevisionsByConsoIds(cloudId, cloudName, consolidatedImages, userName);
        }
        return LocalFileSystemServiceImpl.convertFileRevisionListToFileElementList(fileRevisions);
    }

    private static List<FileElement> convertFileRevisionListToFileElementList(List<FileRevision> fileRevisions) {
        ArrayList<FileElement> elements = new ArrayList<FileElement>();
        for (FileRevision fileRevision : fileRevisions) {
            ConsolidatedImage consolidatedImage = fileRevision.getConsolidatedImage();
            String path = consolidatedImage.getDevicePath();
            long time = Long.parseLong(consolidatedImage.getModifiedTime());
            FileElement fileElement = new FileElement();
            fileElement.setFileCompletePath(path);
            fileElement.setLastModifiedTimestamp(time);
            fileElement.setFileName(consolidatedImage.getFileName());
            fileElement.setExists(consolidatedImage.isPresent());
            fileElement.setFolder(consolidatedImage.isFolder());
            fileElement.setMd5checksum(consolidatedImage.getMD5());
            fileElement.setMetaData(consolidatedImage.getMetaData());
            fileElement.setSize(String.valueOf(consolidatedImage.getSize()));
            String extension = FilenameUtils.getExtension((String)consolidatedImage.getFileName());
            if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                fileElement.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileRevision.getfSPath());
            }
            elements.add(fileElement);
        }
        return elements;
    }

    private FileListElement httpOutput(Map<String, String> headerMap, MiniCloudElementList cloudElementList, String userName, StringBuilder stringBuilder) throws ResourceFunnelException, IOException {
        FileListElement result = null;
        try {
            headerMap.put("userName", userName);
            Set<Map.Entry<String, String>> entries = headerMap.entrySet();
            HttpHeaders headers = new HttpHeaders();
            for (Map.Entry<String, String> entry : entries) {
                headers.add(entry.getKey(), entry.getValue());
            }
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new StringHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            headers.add("userName", userName);
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
            ResponseEntity resultObj = restTemplate.postForEntity(stringBuilder.toString(), (Object)entity, FileListElement.class, new Object[0]);
            result = (FileListElement)resultObj.getBody();
        }
        catch (Exception e) {
            logger.trace(IO_EXCEPTION + e);
            logger.error(IO_EXCEPTION + e.getMessage());
        }
        return result;
    }

    private FileListElement httpsOutput(Map<String, String> headerMap, MiniCloudElementList cloudElementList, String userName, StringBuilder stringBuilder) throws ResourceFunnelException, IOException {
        FileListElement result = null;
        try {
            Set<Map.Entry<String, String>> entries = headerMap.entrySet();
            HttpHeaders headers = new HttpHeaders();
            for (Map.Entry<String, String> entry : entries) {
                headers.add(entry.getKey(), entry.getValue());
            }
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new StringHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            headers.add("userName", userName);
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
            ResponseEntity resultObj = restTemplate.postForEntity(stringBuilder.toString(), (Object)entity, FileListElement.class, new Object[0]);
            result = (FileListElement)resultObj.getBody();
        }
        catch (Exception e) {
            logger.trace(IO_EXCEPTION + e);
            logger.error(IO_EXCEPTION + e.getMessage());
        }
        return result;
    }
}

