/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.service.impl;

import com.parablu.bluvault.settings.service.EncryptionKeyService;
import com.parablu.paracloud.element.EncryptionKeyElement;
import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.domain.EncryptionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EncryptionKeyServiceImpl
implements EncryptionKeyService {
    @Resource
    private EncryptionKeyDao encryptionKeyDao;

    @Override
    public void saveEncryptionKey(int cloudId, String userName, String saltKey, String productType) {
        EncryptionKey encryptionKey = new EncryptionKey(userName, saltKey, productType);
        this.encryptionKeyDao.saveEncryptionKey(cloudId, encryptionKey);
    }

    @Override
    public List<EncryptionKeyElement> getAllEncryptionKeys(int cloudId, String productType) {
        ArrayList<EncryptionKeyElement> elements = null;
        List encryptionKeys = this.encryptionKeyDao.getAllEncryptionKeys(cloudId, productType);
        if (!CollectionUtils.isEmpty((Collection)encryptionKeys)) {
            elements = new ArrayList<EncryptionKeyElement>();
            for (EncryptionKey encryptionKey : encryptionKeys) {
                EncryptionKeyElement ee = new EncryptionKeyElement();
                BeanUtils.copyProperties((Object)encryptionKey, (Object)ee);
                elements.add(ee);
            }
        }
        return elements;
    }

    @Override
    public EncryptionKeyElement getEncryptionKey(int cloudId, String productType) {
        EncryptionKeyElement element = null;
        EncryptionKey encryptionKey = this.encryptionKeyDao.getEncryptionKey(cloudId, productType);
        if (encryptionKey != null) {
            element = new EncryptionKeyElement();
            BeanUtils.copyProperties((Object)encryptionKey, (Object)element);
        }
        return element;
    }

    @Override
    public EncryptionKeyElement getKeyForDecryption(int cloudId, long timeStamp, String productType) {
        EncryptionKeyElement element = null;
        EncryptionKey encryptionKey = this.encryptionKeyDao.getKeyForDecrypt(cloudId, timeStamp, productType);
        if (encryptionKey != null) {
            element = new EncryptionKeyElement();
            BeanUtils.copyProperties((Object)encryptionKey, (Object)element);
        }
        return element;
    }

    @Override
    public List<EncryptionKeyElement> getAllEncryptionKeys(int cloudId) {
        ArrayList<EncryptionKeyElement> elements = null;
        List encryptionKeys = this.encryptionKeyDao.getAllProductEncryptionKeys(cloudId);
        if (!CollectionUtils.isEmpty((Collection)encryptionKeys)) {
            elements = new ArrayList<EncryptionKeyElement>();
            for (EncryptionKey encryptionKey : encryptionKeys) {
                EncryptionKeyElement element = new EncryptionKeyElement();
                BeanUtils.copyProperties((Object)encryptionKey, (Object)element);
                elements.add(element);
            }
        }
        return elements;
    }
}

