/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.listener;

import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.ComponentSettingService;
import com.parablu.bluvault.udc.service.JobConfigService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.domain.ComponentsElement;
import com.parablu.pcbd.domain.MSAppSetting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitiateSettings {
    private static Logger logger = LogManager.getLogger(InitiateSettings.class);
    private CloudSettingsService cloudSettingService;
    private ComponentSettingService componentSettingService;
    private JobConfigService jobConfigService;

    public void setJobConfigService(JobConfigService jobConfigService) {
        this.jobConfigService = jobConfigService;
    }

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    public void setCloudSettingService(CloudSettingsService cloudSettingService) {
        this.cloudSettingService = cloudSettingService;
    }

    public void initiateCloudSettings() {
        this.initiateCloudProperties();
    }

    private void initiateCloudProperties() {
        MSAppSetting msAppSetting;
        logger.debug("Starting up ... !");
        logger.debug("cloud settingservice is:>>");
        CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(1);
        if (cloudPropertyElement == null) {
            logger.debug("cloud property element is null at the first time so setting default values");
            cloudPropertyElement = new CloudPropertyElement();
            this.setDefaultValuesToCloudPropertyElement(cloudPropertyElement);
            logger.debug("Cloud property element vlaue adfsurl>>" + cloudPropertyElement.getAdfsUrl());
        }
        if ((msAppSetting = this.componentSettingService.getMSAppSettingsDetails(1)) != null) {
            PCHelperConstant.setMSClientId((String)msAppSetting.getClientId());
            PCHelperConstant.setMSClientSecret((String)msAppSetting.getClientSecretKey());
            PCHelperConstant.setMSTenantId((String)msAppSetting.getTenantId());
            PCHelperConstant.setMSSharePointUrl((String)msAppSetting.getClientTokenURL());
        }
        PCHelperConstant.setBrevityLogging((boolean)cloudPropertyElement.isBrevityLogging());
        PCHelperConstant.setOnlySyncFromEndpoint((boolean)cloudPropertyElement.isOnlySyncFromEndpoint());
        this.getServerVersion(cloudPropertyElement);
        logger.debug("cloud property element is not null mnt path>>>" + cloudPropertyElement.getMntParacloudPath());
        PCHelperConstant.setPropertyFileValueLocalAd((String)String.valueOf(cloudPropertyElement.getLocalAD()));
        PCHelperConstant.setPropertyFileValueAdfsUrl((String)cloudPropertyElement.getAdfsUrl());
        PCHelperConstant.setPropertyFileValueAllowAdminToRestoreAll((String)String.valueOf(cloudPropertyElement.getCanAdminRestoreAll()));
        PCHelperConstant.setPropertyFileValueBkpEmailGroupName((String)cloudPropertyElement.getEmailBkpGroupName());
        PCHelperConstant.setPropertyFileValueBkpSupportEmail((String)cloudPropertyElement.getBkpGroupEmail());
        PCHelperConstant.setPropertyFileValueBkpSyncEmailGroupName((String)cloudPropertyElement.getEmailSyncGroupName());
        PCHelperConstant.setPropertyFileValueBkpSyncSupportEmail((String)cloudPropertyElement.getSyncGroupEmail());
        PCHelperConstant.setPropertyFileValueClientDownloadPath((String)cloudPropertyElement.getBlusyncDownloadPath());
        PCHelperConstant.setPropertyFileValueClientMailName((String)cloudPropertyElement.getClientMailName());
        PCHelperConstant.setPropertyFileValueClientSupportMailName((String)cloudPropertyElement.getClientSupportMailName());
        PCHelperConstant.setPropertyFileValueDefaultBkpPolicy((String)cloudPropertyElement.getDefaultBkpPolicyName());
        PCHelperConstant.setPropertyFileValueDefaultSyncPolicy((String)cloudPropertyElement.getDefaultSyncPolicyName());
        PCHelperConstant.setPropertyFileValueDefaultO365PolicyName((String)cloudPropertyElement.getDefaultO365PolicyName());
        PCHelperConstant.setPropertyFileValueEmailDomainCheck((String)String.valueOf(cloudPropertyElement.getIsDomainCheckEnabled()));
        PCHelperConstant.setPropertyFileValueEmailsToadminsOnly((String)String.valueOf(cloudPropertyElement.getEmailToAdminOnly()));
        PCHelperConstant.setPropertyFileValueIsCrawlEnabled((String)String.valueOf(cloudPropertyElement.getIsCrawlEnabled()));
        PCHelperConstant.setPropertyFileValueIsShareFileNameEnabled((String)String.valueOf(cloudPropertyElement.getIsShareFileNameEnabled()));
        PCHelperConstant.setPropertyFileValueMaxCrawlHit((String)String.valueOf(cloudPropertyElement.getMaxCrawlHit()));
        PCHelperConstant.setPropertyFileValueMaxRetryChunkUpdate((String)String.valueOf(cloudPropertyElement.getChunkUpdateMaxRetry()));
        PCHelperConstant.setPropertyFileValueMigrationOu((String)cloudPropertyElement.getAdGroupName());
        PCHelperConstant.setPropertyFileValueParacloudCloudnameFile((String)cloudPropertyElement.getCloudFileName());
        PCHelperConstant.setPropertyFileValueParacloudMountPoint((String)cloudPropertyElement.getMntParacloudPath());
        PCHelperConstant.setPropertyFileValueParacloudType((String)cloudPropertyElement.getCloudType());
        PCHelperConstant.setPropertyFileValuePgWriteDelayLimit((String)String.valueOf(cloudPropertyElement.getEbmsWriteDelayLimit()));
        PCHelperConstant.setPropertyFileValueReadPreference((String)String.valueOf(cloudPropertyElement.getMongoReadPreference()));
        PCHelperConstant.setPropertyFileValueReplicaSafeLimit((String)String.valueOf(cloudPropertyElement.getWriteConcernLimit()));
        PCHelperConstant.setPropertyFileValueReportDisplayRecords((String)String.valueOf(cloudPropertyElement.getReportRows()));
        PCHelperConstant.setPropertyFileValueScriptsBinDir((String)cloudPropertyElement.getScriptsBinDir());
        PCHelperConstant.setPropertyFileValueSolrBaseUrl((String)cloudPropertyElement.getSolrUrl());
        PCHelperConstant.setSolrServerUrl((String)cloudPropertyElement.getSolrServerUrl());
        PCHelperConstant.setLocalSolr((boolean)cloudPropertyElement.isLocalSolr());
        PCHelperConstant.setPropertyFileValueSslAuthEnabled((String)String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
        PCHelperConstant.setPropertyFileValueSupportMail((String)cloudPropertyElement.getSupportMail());
        PCHelperConstant.setPropertyFileValueSyncEmailGroupName((String)cloudPropertyElement.getEmailSyncGroupName());
        PCHelperConstant.setPropertyFileValueVideoThumbnailScript((String)cloudPropertyElement.getScriptsVideoThumbnail());
        PCHelperConstant.setBulkEmailDelay((int)cloudPropertyElement.getBulkEmailDelay());
        PCHelperConstant.setPropertyFileValueDefaultGuestBkpPolicy((String)cloudPropertyElement.getDefaultGuestBkpPolicyName());
        PCHelperConstant.setPropertyFileValueDefaultGuestSyncPolicy((String)cloudPropertyElement.getDefaultGuestSyncPolicyName());
        PCHelperConstant.setDaysToWaitForNextBackup((int)cloudPropertyElement.getDaysToWaitForNextBackup());
        PCHelperConstant.setPropertyFileValueParacloudScriptFolder((String)cloudPropertyElement.getCloudScriptsFolder());
        PCHelperConstant.setPropertyFileValueGeneralThumbnailScript((String)cloudPropertyElement.getScriptsGeneralThumbnail());
        PCHelperConstant.setCanUserChangePassword((boolean)cloudPropertyElement.isCanUserChangePassword());
        PCHelperConstant.setCanAdminChangeUserPassword((boolean)cloudPropertyElement.isCanAdminChangeUserPassword());
        PCHelperConstant.setPasswordChangeEnforce((boolean)cloudPropertyElement.isPasswordChangeEnforce());
        PCHelperConstant.setHideStorageSizeInCloud((boolean)cloudPropertyElement.isHideStorageSizeInCloud());
        PCHelperConstant.setWinDeviceDisplayNameUpdate((boolean)cloudPropertyElement.isWinDeviceDisplayNameUpdate());
        PCHelperConstant.setMacDeviceDisplayNameUpdate((boolean)cloudPropertyElement.isMacDeviceDisplayNameUpdate());
        PCHelperConstant.setMuxedEnabled((boolean)cloudPropertyElement.isMuxedEnabled());
        PCHelperConstant.setNoBackupPolicyName((String)(cloudPropertyElement.getNoBackupPolicyName() == null ? "STATISTICS_COLLECTOR" : cloudPropertyElement.getNoBackupPolicyName()));
        logger.debug("..........mux........" + PCHelperConstant.isMuxedEnabled());
        logger.debug(".... setMacDeviceDisplayNameUpdate .... " + PCHelperConstant.isMacDeviceDisplayNameUpdate());
        logger.debug(".... isWinDeviceDisplayNameUpdate .... " + PCHelperConstant.isWinDeviceDisplayNameUpdate());
        PCHelperConstant.setDnsUserName((String)cloudPropertyElement.getDnsUserName());
        PCHelperConstant.setDnsPassword((String)cloudPropertyElement.getDnsPassword());
        PCHelperConstant.setAdEmailConfig((String)cloudPropertyElement.getAdEmailConfig());
        PCHelperConstant.setExtensionsToPdfView((String)cloudPropertyElement.getExtensionsToPdfView());
        PCHelperConstant.setDaysToKeepAuditLog((int)cloudPropertyElement.getDaysToKeepAuditLog());
        PCHelperConstant.setShowMultipleLoginWarning((boolean)cloudPropertyElement.isShowMultipleLoginWarning());
        PCHelperConstant.setAllowUserLevelFolderExclusions((boolean)cloudPropertyElement.isAllowUserLevelFolderExclusions());
        logger.debug(".... component name .... " + PCHelperConstant.getPropertyValueComponentName());
        ComponentsElement componentsElement = this.componentSettingService.getComponents(PCHelperConstant.getPropertyValueComponentName(), 1);
        Map componentProperties = componentsElement.getComponentsProperties();
        if (componentProperties.containsKey("chunkTotalBuckets")) {
            PCHelperConstant.setChunkTotalBuckets((String)((String)componentProperties.get("chunkTotalBuckets")));
        }
        if (componentProperties.containsKey("superUserName")) {
            PCHelperConstant.setPropertyFileValueParabluSuperUserName((String)((String)componentProperties.get("superUserName")));
        }
        if (componentProperties.containsKey("chunkTotalBuckets")) {
            PCHelperConstant.setChunkTotalBuckets((String)((String)componentProperties.get("chunkTotalBuckets")));
        }
        if (componentProperties.containsKey("keyForLoad")) {
            PCHelperConstant.setPropertyFileValueReloadKey((String)((String)componentProperties.get("keyForLoad")));
        }
        if (componentProperties.containsKey("devAllowPerCollection")) {
            PCHelperConstant.setDevicesAllowedPerCollection((String)((String)componentProperties.get("devAllowPerCollection")));
        }
        if (componentProperties.containsKey("bkpColQueryRequired")) {
            PCHelperConstant.setBackupCollectionQueryRequired((String)((String)componentProperties.get("bkpColQueryRequired")));
        }
        if (componentProperties.containsKey("chunkColQueryRequired")) {
            PCHelperConstant.setChunkCollectionQueryRequired((String)((String)componentProperties.get("chunkColQueryRequired")));
        }
        if (componentProperties.containsKey("showAddADAttributeEnabled")) {
            PCHelperConstant.setShowAdditionalAdAttrbs((String)((String)componentProperties.get("showAddADAttributeEnabled")));
        }
        if (componentProperties.containsKey("showAddReportAttributeEnabled")) {
            PCHelperConstant.setshowAddReportAttr((String)((String)componentProperties.get("showAddReportAttributeEnabled")));
        }
        if (componentProperties.containsKey("paracloudUrl")) {
            PCHelperConstant.setPropertyFileValueParacloudUrl((String)((String)componentProperties.get("paracloudUrl")));
        }
        if (componentProperties.containsKey("noOfMonthsOldRecordToDeleteForSyncOverview")) {
            PCHelperConstant.setNoOfMonthsOldRecordToDelete((String)((String)componentProperties.get("noOfMonthsOldRecordToDeleteForSyncOverview")));
        }
        if (componentProperties.containsKey("impUsersPolicyNames")) {
            PCHelperConstant.setPropertyFileValueImpUsersPolicyNames((String)((String)componentProperties.get("impUsersPolicyNames")));
        }
        if (componentProperties.containsKey("azureVM")) {
            PCHelperConstant.setPropertyFileValueAzureVm((String)((String)componentProperties.get("azureVM")));
        }
        if (this.jobConfigService.getJobConfigByServerName(1, componentsElement.getComponentName()) != null) {
            PCHelperConstant.setJobConfig((Map)this.jobConfigService.getJobConfigByServerName(1, componentsElement.getComponentName()));
        }
        if (componentProperties.containsKey("proxyHost")) {
            PCHelperConstant.setProxyHost((String)((String)componentProperties.get("proxyHost")));
        }
        if (componentProperties.containsKey("proxyPort")) {
            PCHelperConstant.setProxyPort((String)((String)componentProperties.get("proxyPort")));
        }
        if (componentProperties.containsKey("proxyUserName")) {
            PCHelperConstant.setProxyUserName((String)((String)componentProperties.get("proxyUserName")));
        }
        if (componentProperties.containsKey("proxyPassword")) {
            PCHelperConstant.setProxyPassword((String)((String)componentProperties.get("proxyPassword")));
        }
        if (componentProperties.containsKey("enableCloudSizeLogic")) {
            PCHelperConstant.setEnableCloudSizeLogic((boolean)Boolean.parseBoolean((String)componentProperties.get("enableCloudSizeLogic")));
            logger.debug("initiating properties...ENABLED_CLOUD_SIZE_LOGIC :" + PCHelperConstant.getEnableCloudSizeLogic());
        }
        logger.debug("end of initiating properties... !" + PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)"test"));
        logger.debug("end of initiating properties... !" + PCHelperConstant.getPropertyFileValueParacloudMountPoint());
    }

    private void setDefaultValuesToCloudPropertyElement(CloudPropertyElement cloudProperty2Element) {
        CloudPropertyElement cloudPropertyElement = cloudProperty2Element;
        cloudPropertyElement.setAdfsUrl("https:443//IP/springsam/saml/login");
        cloudPropertyElement.setAdGroupName("");
        cloudPropertyElement.setAzureVM(false);
        cloudPropertyElement.setBkpGroupEmail("MySecureBackup@parablu.com");
        cloudPropertyElement.setBlusyncDownloadPath("var/lib/parablusys/upgrade/");
        cloudPropertyElement.setCanAdminRestoreAll(true);
        cloudPropertyElement.setChunkUpdateMaxRetry(3);
        cloudPropertyElement.setClientMailName("Parablu");
        cloudPropertyElement.setClientSupportMailName("support@parablu.com");
        cloudPropertyElement.setCloudFileName("cloudName");
        cloudPropertyElement.setCloudScriptsFolder("/var/lib/parablusys/bin/");
        cloudPropertyElement.setCloudType("enterprise");
        cloudPropertyElement.setDefaultBkpPolicyName("STATISTICS_COLLECTOR");
        cloudPropertyElement.setDefaultSyncPolicyName("STATISTICS_SYNC_COLLECTOR");
        cloudPropertyElement.setEbmsWriteDelayLimit(10);
        cloudPropertyElement.setEmailBkpGroupName("MySecureBackup");
        cloudPropertyElement.setEmailSyncGroupName("MySecureSync");
        cloudPropertyElement.setEmailToAdminOnly(true);
        cloudPropertyElement.setIsCrawlEnabled(false);
        cloudPropertyElement.setIsDomainCheckEnabled(false);
        cloudPropertyElement.setIsShareFileNameEnabled(true);
        cloudPropertyElement.setLocalAD(true);
        cloudPropertyElement.setMaxCrawlHit(100);
        cloudPropertyElement.setMntParacloudPath("/mnt/");
        cloudPropertyElement.setMongoReadPreference(false);
        cloudPropertyElement.setNoOfMultiADConfig(1);
        cloudPropertyElement.setReportRows(50);
        cloudPropertyElement.setScriptsBinDir("/var/lib/parablusys/bin/");
        cloudPropertyElement.setScriptsGeneralThumbnail("generateThumbnails.sh");
        cloudPropertyElement.setScriptsVideoThumbnail("generateVideoThumbnails.sh");
        cloudPropertyElement.setSolrUrl("http://IP/");
        cloudPropertyElement.setSslAuthEnabled(false);
        cloudPropertyElement.setSupportMail("support@parablu.com");
        cloudPropertyElement.setSyncGroupEmail("MySecureSync@parablu.com");
        cloudPropertyElement.setWriteConcernLimit(1000);
        cloudPropertyElement.setBulkEmailDelay(0);
        cloudPropertyElement.setDnsUserName("rsuresh");
        cloudPropertyElement.setDnsPassword("suresh");
        cloudPropertyElement.setBrevityLogging(true);
        cloudPropertyElement.setGlobalCheckForLocalStorage(false);
        cloudPropertyElement.setOnlySyncFromEndpoint(false);
        cloudPropertyElement.setNoBackupPolicyName("STATISTICS_COLLECTOR");
    }

    private void getServerVersion(CloudPropertyElement cloudPropertyElement) {
        try (Stream<String> stream = Files.lines(Paths.get(cloudPropertyElement.getMntParacloudPath() + "installed_version", new String[0]));){
            logger.debug("The Product Version of Server :" + stream.findFirst().orElse("<N/A>"));
        }
        catch (IOException e) {
            logger.trace("Exception for failed to get Server Version..." + e);
            logger.error("error failed to get server version");
        }
    }
}

