/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import com.parablu.psm.service.StorageService;
import com.parablu.psm.to.StorageStatusTo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class StorageManagementController
extends BaseController {
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private StorageService storageService;
    private static Logger logger = LogManager.getLogger(StorageManagementController.class);
    private static final String IO_EXCEPTION = "IOException";
    private static final String INTERRUPTED_EXCEPTION = "InterruptedException";
    private static final String BASE_EXCEPTION = "BaseException";

    public void toggleServer() {
        logger.trace("Enter MediaManagementController. toggleServer");
    }

    @RequestMapping(value={"cloud/{cloudName}/storage/status"}, method={RequestMethod.GET})
    public ModelAndView checkStorageStatus(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        CloudLicenseTo cl;
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        boolean step = Boolean.parseBoolean(request.getHeader("step"));
        if (cloudName == null) {
            response.setStatus(400);
        }
        if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        try {
            StorageStatusTo storageStatus = this.storageService.detectIfStorageIsAttached(cloudName, step);
            response.setStatus(200);
            modelAndView.addObject((Object)storageStatus);
            return modelAndView;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.debug(IO_EXCEPTION, (Throwable)e);
        }
        catch (InterruptedException e) {
            response.setStatus(500);
            logger.debug(INTERRUPTED_EXCEPTION, (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"cloud/{cloudName}/storage/locate"}, method={RequestMethod.GET})
    public ModelAndView locateExternalStorage(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        CloudLicenseTo cl;
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        if (cloudName == null) {
            response.setStatus(400);
        }
        if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        try {
            List storageStatus = this.storageService.locateExternalStorage(cloudName);
            response.setStatus(200);
            modelAndView.addObject((Object)storageStatus);
            return modelAndView;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.debug(IO_EXCEPTION, (Throwable)e);
        }
        catch (InterruptedException e) {
            response.setStatus(500);
            logger.debug(INTERRUPTED_EXCEPTION, (Throwable)e);
        }
        catch (BaseException e) {
            response.setStatus(e.getErrorStatus());
            logger.debug(BASE_EXCEPTION, (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"cloud/{cloudName}/storage/mount"}, method={RequestMethod.GET})
    public void mountExternalStorage(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        User currentUser = new User();
        boolean encrypted = Boolean.parseBoolean(request.getHeader("encrypted"));
        String token = request.getHeader("token");
        String password = request.getHeader("password");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        if (!this.performAuthorization(cl.getCloud().getCloudId(), cloudName, token, currentUser, response)) {
            return;
        }
        try {
            String storageStatus;
            String curStorageStatus = this.storageService.detectIfStorageIsAttached(cloudName, false).getStatus();
            if ("Internal".equals(curStorageStatus) || curStorageStatus.startsWith("busy")) {
                response.setStatus(409);
                return;
            }
            if (encrypted) {
                if (password == null) {
                    response.setStatus(400);
                }
                storageStatus = this.storageService.mountEncryptedExternalStorage(cloudName, password, false);
            } else {
                storageStatus = this.storageService.mountExternalDrive(cloudName, false);
            }
            response.setStatus(200);
            response.getOutputStream().write(storageStatus.getBytes());
            response.getOutputStream().flush();
            IOUtils.closeQuietly((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.debug(IO_EXCEPTION, (Throwable)e);
        }
        catch (InterruptedException e) {
            response.setStatus(500);
            logger.debug(INTERRUPTED_EXCEPTION, (Throwable)e);
        }
        catch (BaseException e) {
            response.setStatus(e.getErrorStatus());
            logger.debug(BASE_EXCEPTION, (Throwable)e);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/storage/install"}, method={RequestMethod.GET})
    public void installExternalStorage(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        User currentUser = new User();
        boolean encrypted = Boolean.parseBoolean(request.getHeader("encrypted"));
        String token = request.getHeader("token");
        String devID = request.getHeader("device");
        String password = request.getHeader("password");
        if (devID == null) {
            response.setStatus(400);
            return;
        }
        if (encrypted && password == null) {
            response.setStatus(400);
            return;
        }
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        if (!this.performAuthorization(cl.getCloud().getCloudId(), cloudName, token, currentUser, response)) {
            return;
        }
        if (!currentUser.isAdmin()) {
            response.setStatus(401);
            return;
        }
        try {
            if (!"Internal".equals(this.storageService.detectIfStorageIsAttached(cloudName, false).getStatus())) {
                response.setStatus(400);
                return;
            }
        }
        catch (IOException e2) {
            logger.debug(IO_EXCEPTION, (Throwable)e2);
            response.setStatus(500);
            return;
        }
        catch (InterruptedException e2) {
            logger.debug("InterruptedException  ", (Throwable)e2);
            response.setStatus(500);
            return;
        }
        response.setStatus(200);
        try {
            IOUtils.closeQuietly((OutputStream)response.getOutputStream());
        }
        catch (IOException e1) {
            logger.debug(IO_EXCEPTION, (Throwable)e1);
        }
        try {
            String storageStatus;
            if (encrypted ? (storageStatus = this.storageService.formatAndMountExternalDriveEncrypted(cloudName, devID, password)).startsWith("error") : (storageStatus = this.storageService.formatExternalDrivePlain(cloudName, devID)).startsWith("error")) {
                throw new BaseException("failed", 500);
            }
            List clouds = this.licenseService.getClouds();
            for (Cloud cloud : clouds) {
                cloud.setCloudSizeAllowed((int)new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint()).getTotalSpace());
                this.licenseService.updateCloudLicense(cloud);
            }
        }
        catch (IOException e) {
            logger.trace(" IOException  :" + e);
            logger.error(" IOException  :" + e.getMessage());
            this.storageService.revertProcess();
        }
        catch (InterruptedException e) {
            logger.trace(INTERRUPTED_EXCEPTION + e);
            logger.error(INTERRUPTED_EXCEPTION + e.getMessage());
            this.storageService.revertProcess();
        }
        catch (BaseException e) {
            logger.trace(INTERRUPTED_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            this.storageService.revertProcess();
        }
        catch (Exception e) {
            logger.trace(" Exception  :" + e);
            logger.error(" Exception" + e.getMessage());
            this.storageService.revertProcess();
        }
    }
}

