/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.settings.service.SettingsService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.LicenseKeyFileElement;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SettingsController
extends BaseController {
    private static Logger logger = LogManager.getLogger(SettingsController.class);
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuthorizationService authorizationServices;
    @Autowired
    private AuditHistoryService auditHistoryService;

    @RequestMapping(value={"/cloud/{cloudName}/save/odbFolderName/"}, method={RequestMethod.POST})
    public void saveODBFolderInfo(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering saveODBFolderInfo ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during saveODBFolderInfo ......");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String folderName = request.getHeader("folderName");
            this.settingsService.saveODBFolderName(cloudId, folderName);
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.debug("exception trying to saveODBFolderInfo ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of saveODBFolderInfo ..... ");
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/dedupStartTime/"}, method={RequestMethod.POST})
    public void saveDedupStartTime(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering save dedupStartTime ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save dedupStartTime ......");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            long dedupStartTime = System.currentTimeMillis();
            String dedupStartTimeStr = request.getHeader("dedupStartTime");
            if (StringUtils.isEmpty((String)dedupStartTimeStr)) {
                response.setStatus(400);
                return;
            }
            if (!StringUtils.isEmpty((String)dedupStartTimeStr)) {
                dedupStartTime = Long.parseLong(dedupStartTimeStr);
            }
            this.settingsService.saveDedupStartTime(cloudId, dedupStartTime);
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.debug("exception trying to save dedupStartTime ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of save dedupStartTime ..... ");
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/licenseKey/"}, method={RequestMethod.POST})
    public void saveLicenseKeyToServer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Inside save LicenseKey .....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save LicenseKey ....");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            String fileName = request.getHeader("fileName");
            String filePath = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "LicenseKey/encryptedFiles";
            if (StringUtils.isEmpty((String)fileName)) {
                response.setStatus(400);
                return;
            }
            User currentUser = this.authorizationServices.getTokenDetailsForToken(cloudId, cloudName, token).getUser();
            logger.debug(currentUser.getUserName() + "  username..");
            if (!currentUser.isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            if (this.settingsService.saveLicenseKeyFileInDb(fileName, filePath)) {
                this.auditHistoryService.saveStatisticToDatabase(1, cloudName, " uploaded the Licensekey file " + fileName, currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.LICENSE_KEY.getActionTypeValue());
                response.setStatus(200);
            } else {
                logger.debug("failed to save file in db");
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("error .." + e.getMessage());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/licenseKey/all"}, method={RequestMethod.GET})
    public ModelAndView getLicenseKeyFromServer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Inside save LicenseKey .....");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save LicenseKey ....");
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            User currentUser = this.authorizationServices.getTokenDetailsForToken(cloudId, cloudName, token).getUser();
            logger.debug(currentUser.getUserName() + "  username..");
            if (!currentUser.isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return null;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            List<LicenseKeyFileElement> licenseKeyFileElement = this.settingsService.getLicenseKeyListFromDb();
            if (licenseKeyFileElement == null) {
                logger.debug("No license key files exist..");
                response.setStatus(507);
                return null;
            }
            modelAndView.addObject(licenseKeyFileElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("error to get licekey list" + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/licenseKey/"}, method={RequestMethod.POST})
    public void opertaionToLicenseKey(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Inside do operation to  LicenseKey .....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save LicenseKey ....");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            Cloud existingcloud = cl.getCloud();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            String fileName = request.getHeader("fileName");
            String operation = request.getHeader("operation");
            if (StringUtils.isEmpty((String)fileName) || StringUtils.isEmpty((String)operation)) {
                response.setStatus(400);
                return;
            }
            User currentUser = this.authorizationServices.getTokenDetailsForToken(cloudId, cloudName, token).getUser();
            logger.debug(currentUser.getUserName() + "  username..");
            if (!currentUser.isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            logger.debug("fileName" + fileName + "operation" + operation + " cloudName" + cloudName);
            logger.debug("................" + existingcloud.getCloudId());
            if (!this.settingsService.updateLicense(fileName, operation, response, cloudName, currentUser.getUserName(), this.auditHistoryService, existingcloud, cloudId)) {
                logger.debug("in else....");
                return;
            }
            this.settingsService.updateAllBkpPolicyModifiedTime(cloudId);
            response.setStatus(200);
            logger.debug(response.getStatus() + "status...");
        }
        catch (Exception e) {
            logger.error("error .." + e.getMessage());
            response.setStatus(500);
            logger.error("error to do operation to licekey" + e.getMessage());
        }
    }
}

