/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.ah.controller.BaseController;
import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.settings.service.ODBConnectorSettingService;
import com.parablu.bluvault.settings.service.SettingsService;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.GlobalExcludedFoldersElement;
import com.parablu.paracloud.element.ODBConnectorSettingElement;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.domain.AADAuthorizationToken;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.GlobalExcludedFolders;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SettingController
extends BaseController {
    private static Logger logger = LogManager.getLogger(SettingController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private ODBConnectorSettingService odbConnectorService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private CloudDao cloudDao;

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    @ResponseBody
    @RequestMapping(value={"/cloud/{cloudName}/connector/settings"}, method={RequestMethod.GET})
    public ODBConnectorSettingElement getAllConnectorDetails(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String tCloudName = cloudName;
        ODBConnectorSettingElement odbConnectorSettingElement = null;
        try {
            logger.debug(">>>calling //connector/settings>>>");
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(tCloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            tCloudName = cl.getCloud().getCloudName();
            logger.debug(">>>cloudId>>>" + cloudId);
            String isInternalCall = request.getHeader("isInternalCall");
            if (StringUtils.isEmpty((String)isInternalCall)) {
                if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                    logger.debug("not a admin user so return");
                    response.setStatus(403);
                    return null;
                }
                if (!this.performAuthorization(cloudId, tCloudName, token, response)) {
                    return null;
                }
            }
            logger.debug(">>>cloud name>>>" + tCloudName);
            odbConnectorSettingElement = this.odbConnectorService.getODBConnectorSettingImage(cloudId);
            List allPciAuthorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, tCloudName);
            if (!CollectionUtils.isEmpty((Collection)allPciAuthorizationTokens) && allPciAuthorizationTokens.get(0) != null) {
                odbConnectorSettingElement.setAccountId(((PciAuthorizationTokens)allPciAuthorizationTokens.get(0)).getAccountId());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Unable to get settings details " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return odbConnectorSettingElement;
    }

    @ResponseBody
    @RequestMapping(value={"/cloud/{cloudName}/save/connector/settings"}, method={RequestMethod.POST})
    public ODBConnectorSettingElement saveConnectorDetails(@PathVariable(value="cloudName") String cloudName, @RequestBody ODBConnectorSettingElement odbConnectorSettingElement, HttpServletRequest request, HttpServletResponse response) {
        String tCloudName = cloudName;
        ODBConnectorSettingElement responseODBConnectorSettingElmnt = null;
        try {
            logger.debug(">>>calling /save/connector/settings>>>");
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(tCloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            tCloudName = cl.getCloud().getCloudName();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                return null;
            }
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, tCloudName, token).getUser().isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return null;
            }
            String configId = odbConnectorSettingElement.getConfigId();
            if (!StringUtils.isEmpty((String)configId)) {
                responseODBConnectorSettingElmnt = this.odbConnectorService.updateODBConnectorSettingByConfigId(cloudId, configId, odbConnectorSettingElement);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "edited cloud ", authorizationTokens.getUser().getUserName(), "ODB", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
            } else {
                logger.debug(">>>before saving to database>>>");
                responseODBConnectorSettingElmnt = this.odbConnectorService.saveODBConnectorSettings(cloudId, cloudName, odbConnectorSettingElement);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created cloud ", authorizationTokens.getUser().getUserName(), "ODB", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_CREATE.getActionTypeValue());
                logger.debug(">>>after saving to database>>>");
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Unable to save settings details " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return responseODBConnectorSettingElmnt;
    }

    @RequestMapping(value={"cloud/{cloudName}/globalExclusion/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllGlobalExclusions(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load all globalExclusion ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            List<GlobalExcludedFolders> backupPolicyElements = this.settingsService.getAllGlobalExclusions(cloudId);
            if (backupPolicyElements.isEmpty()) {
                backupPolicyElements = new ArrayList<GlobalExcludedFolders>();
            }
            GlobalExcludedFoldersElement globalExcludedFoldersElement = new GlobalExcludedFoldersElement();
            List macPaths = backupPolicyElements.stream().filter(folder -> Objects.nonNull(folder.getOsType()) && "mac".equalsIgnoreCase(folder.getOsType())).map(line -> line.getFolderPath()).collect(Collectors.toList());
            List winPaths = backupPolicyElements.stream().filter(folder -> Objects.nonNull(folder.getOsType()) && "win".equalsIgnoreCase(folder.getOsType())).map(line -> line.getFolderPath()).collect(Collectors.toList());
            List exchangePaths = backupPolicyElements.stream().filter(folder -> Objects.nonNull(folder.getOsType()) && "exchange".equalsIgnoreCase(folder.getOsType())).map(line -> line.getFolderPath()).collect(Collectors.toList());
            HashMap globalExcludedFoldersList = new HashMap();
            globalExcludedFoldersList.put("mac", macPaths);
            globalExcludedFoldersList.put("win", winPaths);
            globalExcludedFoldersList.put("exchange", exchangePaths);
            globalExcludedFoldersElement.setGlobalExcludedFoldersList(globalExcludedFoldersList);
            modelAndView.addObject((Object)globalExcludedFoldersElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all globalExclusion  ..." + (Object)((Object)e));
            logger.error("Error failed to load all globalExclusion  ..." + e.getMessage());
        }
        logger.debug("end of load all globalExclusion ...");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/odb/isPasswordExpired"}, method={RequestMethod.GET})
    public void isODBpasswordExpired(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/odb/isPasswordExpired...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            boolean isODBEnabled = this.isODBEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (isODBEnabled) {
                List allAdmins = this.userManagementService.getAllAdmins(cloudId, cloudName);
                for (User user : allAdmins) {
                    PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
                    if (pciAuthorizationTokens == null) continue;
                    logger.debug("@@@TOKEN EXPIRY for USER ..." + user.getUserName());
                    boolean result = this.pciAuthorizationTokensService.checkOneDriveConn();
                    if (!result) {
                        logger.debug("checkOneDriveConn failed .....");
                        response.setStatus(417);
                        return;
                    }
                    List allPciAuthorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                    if (CollectionUtils.isEmpty((Collection)allPciAuthorizationTokens)) {
                        logger.debug("..............pci authorization not configure....");
                        response.setStatus(317);
                        return;
                    }
                    String isAADTokenExpired = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloudId);
                    if (StringUtils.isEmpty((String)isAADTokenExpired)) continue;
                    logger.debug("Access token in expired .....");
                    response.setStatus(200);
                    return;
                }
                logger.debug("Odb password not expired........");
                response.setStatus(100);
                return;
            }
            logger.debug("Odb not enabled in this cloud.........");
            response.setStatus(204);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION " + e);
            logger.error("EXCEPTION " + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aad/isPasswordExpired"}, method={RequestMethod.GET})
    public void isAADPasswordExpired(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/aad/isPasswordExpired...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            boolean isAADEnabled = this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (isAADEnabled) {
                boolean result = this.pciAuthorizationTokensService.checkOneDriveConn();
                if (!result) {
                    logger.debug("aadConectionFailed failed .....");
                    response.setStatus(417);
                    logger.info("I am in line 311 of the isAADEnabled");
                }
                if (cl.getCloud().getGraphAADEnabled() == 0) {
                    AADAuthorizationToken aadAuthorizationToken = this.aadManagementService.getAADAuthorizationToken(cloudId);
                    if (aadAuthorizationToken == null) {
                        logger.debug(".............AADAuthorizationToken configure....");
                        response.setStatus(317);
                        logger.info("I am in line 321 of the isAADEnabled");
                    } else {
                        boolean isAADTokenExpired = this.aadManagementService.checkTokenExpired(cloudId);
                        if (!isAADTokenExpired) {
                            logger.debug("Odb password not expired........");
                            response.setStatus(100);
                            logger.info("I am in line 329 of the isAADEnabled");
                        } else {
                            logger.debug("Access token is expired .....");
                            response.setStatus(200);
                            logger.info("I am in line 324 of the isAADEnabled");
                        }
                    }
                } else {
                    logger.debug("Odb password not expired........");
                    response.setStatus(100);
                    logger.info("I am in line 341 of the isAADEnabled");
                }
            } else {
                logger.debug("isAADEnabled is false this cloud.........");
                response.setStatus(204);
                logger.info("I am in line 348 of the isAADEnabled");
            }
        }
        catch (Exception e) {
            logger.trace("EXCEPTION " + e);
            logger.error("EXCEPTION " + e.getMessage());
            logger.info("I am in line 354 of the isAADEnabled");
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/oneDrive/isPasswordExpired"}, method={RequestMethod.GET})
    public void isoneDrivePasswordExpired(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/oneDrive/isPasswordExpired...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            boolean isOneDriveEnabled = this.isOneDriveEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (isOneDriveEnabled) {
                boolean result = this.pciAuthorizationTokensService.checkOneDriveConn();
                if (!result) {
                    logger.debug("aadConectionFailed failed .....");
                    response.setStatus(417);
                    return;
                }
                List authorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                if (CollectionUtils.isEmpty((Collection)authorizationTokens)) {
                    logger.debug(".............authorizationTokens not configure....");
                    response.setStatus(317);
                    return;
                }
                List users = this.userManagementService.getAllAdmins(cloudId, cloudName);
                boolean isTokenExpired = false;
                for (User user : users) {
                    PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
                    if (pciAuthorizationTokens == null) continue;
                    logger.debug(this.pciAuthorizationTokensService + "@@@TOKEN EXPIRY for USER ..." + user.getUserName());
                    String accessToken = this.pciAuthorizationTokensService.getAccessTokenForOffice365(cloudId, cloudName, pciAuthorizationTokens);
                    if (StringUtils.isEmpty((String)accessToken)) continue;
                    isTokenExpired = true;
                    break;
                }
                if (!isTokenExpired) {
                    logger.debug("oneDrive password not expired........");
                    response.setStatus(100);
                    return;
                }
                logger.debug("Access token in expired .....");
                response.setStatus(200);
            } else {
                logger.debug("isOneDriveEnabled is false this cloud.........");
                response.setStatus(204);
            }
        }
        catch (Exception e) {
            logger.trace("EXCEPTION " + e);
            logger.error("EXCEPTION " + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/graph/isPasswordExpired"}, method={RequestMethod.GET})
    public void isGraphExpired(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/oneDrive/isPasswordExpired...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            boolean isGraphApiEnabled = false;
            if (cl.getCloud().getGraphApiEnabled() == 1) {
                isGraphApiEnabled = true;
            }
            if (isGraphApiEnabled) {
                boolean result = this.pciAuthorizationTokensService.checkOneDriveConn();
                if (!result) {
                    logger.debug("aadConectionFailed failed .....");
                    response.setStatus(417);
                    return;
                }
                MSGTokens msgTokens = this.pciAuthorizationTokensService.getMSGTokens(cloudId);
                if (msgTokens == null) {
                    logger.debug(".............MSGTokens configure....");
                    response.setStatus(317);
                    return;
                }
                boolean tokenUpdated = this.pciAuthorizationTokensService.updateTokenForODBBackup(cloudId);
                if (tokenUpdated) {
                    logger.debug("oneDrive password not expired........");
                    response.setStatus(100);
                    return;
                }
                logger.debug("Access token in expired .....");
                response.setStatus(200);
            } else {
                logger.debug("isOneDriveEnabled is false this cloud.........");
                response.setStatus(204);
            }
        }
        catch (Exception e) {
            logger.trace("EXCEPTION " + e);
            logger.error("EXCEPTION " + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private boolean isOneDriveEnabled(List<CloudCustomisableDetails> list) {
        boolean isOneDriveEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            isOneDriveEnabled = true;
            break;
        }
        return isOneDriveEnabled;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    @ResponseBody
    @RequestMapping(value={"/cloud/{cloudName}/msapp/settings/"}, method={RequestMethod.GET})
    public ODBConnectorSettingElement getMSAppSettingsDetails(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String tCloudName = cloudName;
        ODBConnectorSettingElement odbConnectorSettingElement = null;
        try {
            logger.debug(">>>calling /msapp/settings/ >>>" + request.getHeader("userEditProfile"));
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(tCloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            tCloudName = cl.getCloud().getCloudName();
            String isInternalCall = request.getHeader("isInternalCall");
            AuthorizationTokens current = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = new User();
            if (StringUtils.isEmpty((String)isInternalCall)) {
                if (!current.getUser().isAdmin()) {
                    logger.debug("not a admin user so return");
                    response.setStatus(403);
                    return null;
                }
                if (!this.performAuthorization(cloudId, tCloudName, token, response)) {
                    return null;
                }
            }
            currentUser = current.getUser();
            logger.debug(">>>cloud name>>>" + tCloudName);
            String msgtoken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloudId);
            boolean tokenAlreadyMapped = false;
            if (!StringUtils.isEmpty((String)msgtoken)) {
                tokenAlreadyMapped = true;
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            response.setHeader("tokenMapped", "" + tokenAlreadyMapped);
            logger.debug("....is token mapped.... " + tokenAlreadyMapped);
            odbConnectorSettingElement = this.odbConnectorService.getMSAppSettingsDetails(cloudId);
            MSGTokens msgTokens = this.pciAuthorizationTokensService.getMSGTokens(cloudId);
            if (msgTokens != null && !StringUtils.isEmpty((String)msgTokens.getAccountId())) {
                odbConnectorSettingElement.setAccountId(msgTokens.getAccountId());
            }
            logger.debug(".... 4...." + odbConnectorSettingElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Unable to get settings details " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return odbConnectorSettingElement;
    }

    @ResponseBody
    @RequestMapping(value={"/cloud/{cloudName}/save/msapp/settings/"}, method={RequestMethod.POST})
    public ODBConnectorSettingElement saveMSAppSettingsDetails(@PathVariable(value="cloudName") String cloudName, @RequestBody ODBConnectorSettingElement odbConnectorSettingElement, HttpServletRequest request, HttpServletResponse response) {
        String tCloudName = cloudName;
        ODBConnectorSettingElement responseODBConnectorSettingElmnt = null;
        try {
            logger.debug(">>>calling /save/msapp/settings/>>>");
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(tCloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            tCloudName = cl.getCloud().getCloudName();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                return null;
            }
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, tCloudName, token).getUser().isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return null;
            }
            String configId = odbConnectorSettingElement.getConfigId();
            if (!StringUtils.isEmpty((String)configId)) {
                responseODBConnectorSettingElmnt = this.odbConnectorService.updateMSAppSettingsDetailsByConfigId(cloudId, configId, odbConnectorSettingElement);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "edited msapp settings ", authorizationTokens.getUser().getUserName(), "ODB", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
            } else {
                logger.debug(">>>before saving to database>>>");
                responseODBConnectorSettingElmnt = this.odbConnectorService.saveMSAppSettingsDetails(cloudId, odbConnectorSettingElement);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created msapp settings ", authorizationTokens.getUser().getUserName(), "ODB", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_CREATE.getActionTypeValue());
                logger.debug(">>>after saving to database>>>");
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Unable to save /save/msapp/settings/" + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return responseODBConnectorSettingElmnt;
    }

    @ResponseBody
    @RequestMapping(value={"/cloud/{cloudName}/ewsapp/settings/"}, method={RequestMethod.GET})
    public ODBConnectorSettingElement getEWSAppSettingsDetails(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String tCloudName = cloudName;
        ODBConnectorSettingElement odbConnectorSettingElement = null;
        try {
            logger.debug(">>>calling /cloud/{cloudName}/ewsapp/settings/>>>" + request.getHeader("userEditProfile"));
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(tCloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            tCloudName = cl.getCloud().getCloudName();
            String isInternalCall = request.getHeader("isInternalCall");
            AuthorizationTokens current = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = new User();
            if (StringUtils.isEmpty((String)isInternalCall)) {
                if (!current.getUser().isAdmin()) {
                    logger.debug("not a admin user so return");
                    response.setStatus(403);
                    return null;
                }
                if (!this.performAuthorization(cloudId, tCloudName, token, response)) {
                    return null;
                }
            }
            currentUser = current.getUser();
            logger.debug(">>>cloud name>>>" + tCloudName);
            String msgtoken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloudId);
            boolean tokenAlreadyMapped = false;
            if (!StringUtils.isEmpty((String)msgtoken)) {
                tokenAlreadyMapped = true;
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            response.setHeader("tokenMapped", "" + tokenAlreadyMapped);
            logger.debug("....is token mapped.... " + tokenAlreadyMapped);
            odbConnectorSettingElement = this.odbConnectorService.getEWSAppSettingsDetails(cloudId);
            MSGTokens msgTokens = this.pciAuthorizationTokensService.getMSGTokens(cloudId);
            if (msgTokens != null && !StringUtils.isEmpty((String)msgTokens.getAccountId())) {
                odbConnectorSettingElement.setAccountId(msgTokens.getAccountId());
            }
            logger.debug("........" + odbConnectorSettingElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Unable to get settings details " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return odbConnectorSettingElement;
    }

    @ResponseBody
    @RequestMapping(value={"/cloud/{cloudName}/save/ewsapp/settings/"}, method={RequestMethod.POST})
    public ODBConnectorSettingElement saveEWSAppSettingsDetails(@PathVariable(value="cloudName") String cloudName, @RequestBody ODBConnectorSettingElement odbConnectorSettingElement, HttpServletRequest request, HttpServletResponse response) {
        String tCloudName = cloudName;
        ODBConnectorSettingElement responseODBConnectorSettingElmnt = null;
        try {
            logger.debug(">>>calling /save/ewsapp/settings/>>>");
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(tCloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            tCloudName = cl.getCloud().getCloudName();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                return null;
            }
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, tCloudName, token).getUser().isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return null;
            }
            String configId = odbConnectorSettingElement.getConfigId();
            if (!StringUtils.isEmpty((String)configId)) {
                responseODBConnectorSettingElmnt = this.odbConnectorService.updateEWSAppSettingsDetailsByConfigId(cloudId, configId, odbConnectorSettingElement);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "edited ewsapp settings ", authorizationTokens.getUser().getUserName(), "EXCHANGE", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
            } else {
                logger.debug(">>>before saving to database>>>");
                responseODBConnectorSettingElmnt = this.odbConnectorService.saveEWSAppSettingsDetails(cloudId, odbConnectorSettingElement);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created ewsapp settings ", authorizationTokens.getUser().getUserName(), "EXCHANGE", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_CREATE.getActionTypeValue());
                logger.debug(">>>after saving to database>>>");
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Unable to save /save/ewsapp/settings/" + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return responseODBConnectorSettingElmnt;
    }

    @ResponseBody
    @RequestMapping(value={"/connector/pci"}, method={RequestMethod.GET})
    public PciAuthorizationTokens getAllConnectorDetailsForUstility(HttpServletRequest request, HttpServletResponse response) {
        PciAuthorizationTokens pciAuthorizationTokenElement = null;
        List clouds = this.cloudDao.getAllClouds();
        if (clouds == null || clouds.isEmpty()) {
            logger.debug("no clouds found so return ");
            return null;
        }
        String cloudName = ((Cloud)clouds.get(0)).getCloudName();
        logger.debug(":::::::::::::::" + cloudName);
        try {
            logger.debug(">>>calling //connector/settings>>>");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            logger.debug(">>>cloudId>>>" + cloudId);
            logger.debug(">>>cloud name>>>" + cloudName);
            List authorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
            if (!CollectionUtils.isEmpty((Collection)authorizationTokens)) {
                pciAuthorizationTokenElement = (PciAuthorizationTokens)authorizationTokens.get(0);
                logger.debug(">>>Pb admin name>>>" + pciAuthorizationTokenElement.getAccountId());
                logger.debug(">>>sharepoint Url>>>" + pciAuthorizationTokenElement.getSharePointUrl());
                logger.debug(">>>cloud name>>>" + pciAuthorizationTokenElement.getCloudName());
                response.setStatus(200);
                response.setHeader("sharePiontUrl", pciAuthorizationTokenElement.getSharePointUrl());
                response.setHeader("cloudName", pciAuthorizationTokenElement.getCloudName());
                response.setHeader("pbAdminName", pciAuthorizationTokenElement.getAccountId());
            } else {
                MSGTokens odbConnectorSettingElement = this.pciAuthorizationTokensService.getMSGTokens(cloudId);
                if (odbConnectorSettingElement != null) {
                    pciAuthorizationTokenElement = new PciAuthorizationTokens();
                    pciAuthorizationTokenElement.setAccountId(odbConnectorSettingElement.getAccountId());
                    pciAuthorizationTokenElement.setSharePointUrl(odbConnectorSettingElement.getSharePointUrl());
                    pciAuthorizationTokenElement.setCloudName(odbConnectorSettingElement.getCloudName());
                    pciAuthorizationTokenElement.setClientId(odbConnectorSettingElement.getClientId());
                    pciAuthorizationTokenElement.setClientSecret(odbConnectorSettingElement.getClientSecret());
                    logger.debug(">>>Pb admin name>>>" + pciAuthorizationTokenElement.getAccountId());
                    logger.debug(">>>sharepoint Url>>>" + pciAuthorizationTokenElement.getSharePointUrl());
                    logger.debug(">>>cloud name>>>" + pciAuthorizationTokenElement.getCloudName());
                    response.setStatus(200);
                    response.setHeader("sharePiontUrl", odbConnectorSettingElement.getSharePointUrl());
                    response.setHeader("cloudName", odbConnectorSettingElement.getCloudName());
                    response.setHeader("pbAdminName", odbConnectorSettingElement.getAccountId());
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to get settings details ", (Throwable)e);
            logger.trace("" + e);
            response.setStatus(500);
        }
        return pciAuthorizationTokenElement;
    }

    @ResponseBody
    @RequestMapping(value={"/msapp/settings/sharepointApp"}, method={RequestMethod.GET})
    public MSGTokens getMSAppSettingsDetailsForSharePoint(HttpServletRequest request, HttpServletResponse response) {
        MSGTokens odbConnectorSettingElement = null;
        List clouds = this.cloudDao.getAllClouds();
        if (clouds == null || clouds.isEmpty()) {
            logger.debug("no clouds found so return ");
            return null;
        }
        String cloudName = ((Cloud)clouds.get(0)).getCloudName();
        logger.debug(":::::::::::::::" + cloudName);
        try {
            logger.debug(">>>calling /msapp/settings/ >>>");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            logger.debug(">>>cloud name>>>" + cloudName);
            odbConnectorSettingElement = this.pciAuthorizationTokensService.getMSGTokens(cloudId);
            logger.debug("<<<msgAdminName>>>" + odbConnectorSettingElement.getAccountId());
            logger.debug("<<<sharepoint Url>>>" + odbConnectorSettingElement.getSharePointUrl());
            logger.debug("<<<cloud name>>>" + odbConnectorSettingElement.getCloudName());
            response.setStatus(200);
            response.setHeader("sharePiontUrl", odbConnectorSettingElement.getSharePointUrl());
            response.setHeader("cloudName", odbConnectorSettingElement.getCloudName());
            response.setHeader("msgAdminName", odbConnectorSettingElement.getAccountId());
        }
        catch (Exception e) {
            logger.error("Unable to get settings details " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(500);
        }
        return odbConnectorSettingElement;
    }
}

