/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.service.OAuthService;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.LicenseElement;
import com.parablu.pcbd.domain.Cloud;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SecurityController
extends BaseController {
    private static Logger logger = LogManager.getLogger(SecurityController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private OAuthService authService;
    @Autowired
    private UserManagementService managementService;

    public void getOauth2Token() {
    }

    public void refreshOauth2Token() {
    }

    @RequestMapping(value={"cloud/{cloudName}/license/update"}, method={RequestMethod.GET})
    @Deprecated
    public void updateLicense(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(501);
    }

    @RequestMapping(value={"cloud/{cloudName}/licence/details"}, method={RequestMethod.GET})
    public ModelAndView getLicenceDetailsForCloud(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String cloudName = cloudName1;
        modelAndView.setViewName("xmlview");
        Cloud cloud = this.licenseService.getCloudDetails(cloudName);
        this.validateCloud(response, modelAndView, cloud);
        cloudName = cloud.getCloudName();
        String token = request.getHeader("token");
        try {
            if (!this.performAuthorization(cloud.getCloudId(), cloudName, token, response)) {
                this.errorElement.setMessage("Invalid token value.");
                modelAndView.addObject((Object)this.errorElement);
                return modelAndView;
            }
            LicenseElement licenseElement = this.licenseService.getLicenceElementForCloud(cloudName);
            modelAndView.addObject((Object)licenseElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(e.getErrorStatus());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            logger.debug("BaseException", (Throwable)e);
        }
        catch (Exception e) {
            response.setStatus(500);
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            logger.debug("Exception", (Throwable)e);
        }
        return modelAndView;
    }

    private ModelAndView validateCloud(HttpServletResponse response, ModelAndView modelAndView, Cloud cloud) {
        if (cloud == null || cloud.getCloudName() == null) {
            response.setStatus(400);
            this.errorElement.setMessage("Invalid cloud name.");
            modelAndView.addObject((Object)this.errorElement);
        }
        return modelAndView;
    }
}

