/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.settings.service.LocalFileSystemService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.PstBatchDetailElement;
import com.parablu.paracloud.element.SearchElementList;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PstBatch;
import com.parablu.pcbd.domain.PstBatchDetail;
import com.parablu.pcbd.domain.User;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SearchController
extends BaseController {
    private static Logger logger = LogManager.getLogger(SearchController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    private LocalFileSystemService localFileSystemService;

    @RequestMapping(value={"/cloud/{cloudName}/search/file"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Object searchForFiles(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, @RequestParam(value="recordsPerPage", required=false) Integer recordsCountInteger, HttpServletRequest request, HttpServletResponse response) {
        OfficeBackupPolicy officeBackupPolicy;
        BackupPolicy backupPolicy;
        String cloudName = cloudName1;
        String productType = request.getHeader("productType");
        logger.debug("SearchController1 new> ..... /search/file.." + productType);
        int recordsCount = 0;
        int pageNumber = pageNumberInteger;
        if (recordsCountInteger != null) {
            recordsCount = recordsCountInteger;
        }
        recordsCount = PCHelperConstant.getReportDisplayRecords();
        logger.debug(request.getHeader("downloadAsPst") + ".....pageNumberInteger skip and record count1 .." + pageNumberInteger + ".." + recordsCount);
        String fileName = request.getHeader("file-name");
        logger.debug("...search......" + fileName);
        String isMail = request.getHeader("isMail");
        if (StringUtils.isEmpty((String)isMail)) {
            isMail = "false";
        }
        String mailToDate = request.getHeader("mailToDate");
        String mailFromDate = request.getHeader("mailFromDate");
        logger.debug("SearchController1 dates> ..... /search/file.." + mailFromDate + "...." + mailToDate);
        String downloadAsPst = request.getHeader("downloadAsPst");
        downloadAsPst = StringUtils.isEmpty((String)downloadAsPst) ? "false" : "true";
        String start = request.getHeader("start");
        String rows = request.getHeader("rows");
        String miniCloudName = request.getHeader("file-path");
        HashMap<String, String> customHeaderMap = new HashMap<String, String>();
        customHeaderMap.put("file-name", fileName);
        customHeaderMap.put("start", start);
        customHeaderMap.put("rows", rows);
        customHeaderMap.put("file-path", miniCloudName);
        customHeaderMap.put("isMail", isMail);
        customHeaderMap.put("downloadAsPst", downloadAsPst);
        customHeaderMap.put("productType", productType);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        customHeaderMap.put("cloudName", cloudName);
        String token = request.getHeader("token");
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token, response)) {
            return null;
        }
        AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
        User user = authorizationTokens.getUser();
        MiniCloudElementList cloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudName);
        cloudElementList.getMiniClouds().removeAll(this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudName, user.getUserId()).getMiniClouds());
        String deviceId = request.getHeader("deviceId");
        CloudProperties cloudProperties = this.licenseService.getCloudProperties(cloudId);
        boolean adminSearchEnable = false;
        if (cloudProperties.getCanAdminRestoreAll()) {
            adminSearchEnable = true;
        }
        if ("backup".equalsIgnoreCase(productType) && user.isBackupEnabled() && (backupPolicy = this.miniCloudAccessControlService.getBackupPolicy(cloudId, user.getPolicyName())) != null && !backupPolicy.isCanAdminRestore()) {
            adminSearchEnable = false;
        }
        logger.debug("....product type...." + productType);
        if (("mail".equalsIgnoreCase(productType) || "onedrive".equalsIgnoreCase(productType)) && (officeBackupPolicy = this.miniCloudAccessControlService.getOfficeBackupPolicy(cloudId, user.getOdbPolicyName())) != null && !officeBackupPolicy.isCanAdminRestore()) {
            adminSearchEnable = false;
        }
        logger.debug(cloudProperties.getCanAdminRestoreAll() + "...val.." + adminSearchEnable + ".. enable search for adminss .... " + adminSearchEnable);
        if (user.isAdmin()) {
            customHeaderMap.put("isAdmin", "" + adminSearchEnable);
        }
        if (!StringUtils.isEmpty((String)deviceId)) {
            logger.debug(".....search for deviceid ..." + deviceId);
            customHeaderMap.put("deviceId", deviceId);
        } else {
            logger.debug("... deviceid is not coming.... ");
        }
        customHeaderMap.put("skipValue", "" + pageNumberInteger);
        customHeaderMap.put("recordsCount", "" + recordsCount);
        try {
            FileListElement fileList;
            if (cl.getCloud().getContentSearchEnabled() == 1) {
                logger.debug("####SearchController . searchForContent lat.... " + user.getUserName());
                fileList = new FileListElement();
                fileList = this.localFileSystemService.forwardContentSearchRequestToSearchServer(cl.getCloud().getCloudId(), cloudName, customHeaderMap, cloudElementList, user.getUserName());
                ModelAndView modelAndView = new ModelAndView();
                modelAndView.setViewName("xmlview");
                modelAndView.addObject((Object)fileList);
                logger.debug(".... total files ...." + fileList.getTotalNoofFiles());
                response.setHeader("totalFilesCount", fileList.getTotalNoofFiles());
                Map paramSet = request.getParameterMap();
                int totalRecordsCount = Integer.parseInt(fileList.getTotalNoofFiles());
                return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), fileList);
            }
            logger.debug("@@@@SearchController . searchfiles.... ");
            fileList = new FileListElement();
            List<FileElement> fileElements = this.localFileSystemService.searchForFiles(cloudId, cloudName, customHeaderMap, cloudElementList, user.getUserName());
            fileList.setFileElementList(fileElements);
            Map paramSet = request.getParameterMap();
            int totalRecordsCount = Integer.parseInt(fileList.getTotalNoofFiles());
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), fileList);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(" Exception new :" + e);
            logger.error(" Exception  new:" + e.getMessage());
            response.setStatus(500);
            return this.toJSON(1203);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/search/selectedFles"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void searchForFiles(@PathVariable(value="cloudName") String cloudName1, @RequestBody SearchElementList searchElementList, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("...start of calling /cloud/{cloudName}/search/selectedFles....");
        String pstName = request.getHeader("pstName");
        logger.debug(pstName + "....searchelementlist....." + searchElementList.getPstName() + "....." + searchElementList.isDownloadAsPst() + "...." + searchElementList.getPstBatchDetailElements());
        try {
            String token = request.getHeader("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName1, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName1, token);
            User user = authorizationTokens.getUser();
            String batchId = "";
            if (!CollectionUtils.isEmpty((Collection)searchElementList.getPstBatchDetailElements())) {
                PstBatch pstBatch = new PstBatch();
                if (pstBatch.getId() == null) {
                    pstBatch.setPstName(pstName);
                    pstBatch.setUserName(user.getUserName());
                    batchId = this.miniCloudAccessControlService.savePstBatch(pstBatch);
                    pstBatch.setId(new ObjectId(batchId));
                }
                for (PstBatchDetailElement pstBatchDetailElement : searchElementList.getPstBatchDetailElements()) {
                    logger.debug("....ids....." + pstBatchDetailElement.getBackupId() + "...." + pstBatchDetailElement.getDeviceUUID());
                    PstBatchDetail pstBatchDetail = new PstBatchDetail();
                    pstBatchDetail.setPstBatchId(batchId);
                    pstBatchDetail.setBackupId(pstBatchDetailElement.getBackupId());
                    pstBatchDetail.setDeviceUUID(pstBatchDetailElement.getDeviceUUID());
                    this.miniCloudAccessControlService.savePstBatchDetail(pstBatchDetail);
                }
                response.setHeader("batchId", batchId);
                response.setStatus(200);
            }
            logger.debug("...end of calling /cloud/{cloudName}/search/selectedFles...." + batchId);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("...exception..." + e.getMessage());
        }
    }
}

