/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.settings.service.SettingsService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProxyController
extends BaseController {
    private static Logger logger = LogManager.getLogger(ProxyController.class);
    private static final String EXCEPTION = " Exception  :";
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;

    @Deprecated
    @RequestMapping(value={"/cloud/{cloudName}/save/proxy/"}, method={RequestMethod.POST})
    public void saveEncryptionKey(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Entering saveProxy ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during saveProxy ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                logger.error("Error performAuthorization during saveProxy ......");
                return;
            }
            Proxy proxy = new Proxy();
            proxy.setUserName(request.getHeader("userName"));
            proxy.setPassword(request.getHeader("password"));
            proxy.setHost(request.getHeader("proxyhost"));
            proxy.setPort(request.getHeader("port"));
            this.settingsService.saveProxy(cloudId, proxy, true);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created a new proxy configuration ", currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.PROXY_CREATE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.trace("exception trying to save proxy ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of saveproxy ..... ");
    }

    @Deprecated
    @RequestMapping(value={"/cloud/{cloudName}/load/proxy/"}, method={RequestMethod.GET})
    public ModelAndView loadEncryptionKey(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        int cloudId = cl.getCloud().getCloudId();
        try {
            Proxy proxy = this.settingsService.getProxy(cloudId);
            response.setStatus(200);
            modelAndView.addObject((Object)proxy);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/settings/proxies/"}, method={RequestMethod.POST})
    public void createEncryptionKey(@PathVariable(value="version") String version, @PathVariable(value="cloudName") String cloudName1, @RequestBody Proxy proxy1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        Proxy proxy = proxy1;
        logger.debug("Entering saveProxy ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during saveProxy ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not a  admin user so return");
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                logger.error("Error performAuthorization during saveProxy ......");
                return;
            }
            if (!this.settingsService.saveProxy(cloudId, proxy, false)) {
                response.setStatus(406);
            } else {
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created a new proxy configuration ", currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.PROXY_CREATE.getActionTypeValue());
            }
        }
        catch (Exception exception) {
            logger.trace("exception trying to save proxy ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of saveproxy ..... ");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/settings/proxies/"}, method={RequestMethod.PUT})
    public void editEncryptionKey(@PathVariable(value="version") String versionn, @PathVariable(value="cloudName") String cloudName1, @RequestBody Proxy proxy, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Entering editProxy ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during editProxy ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not an admin user so return");
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                logger.error("Error performAuthorization during editProxy ......");
                return;
            }
            if (!this.settingsService.editProxy(cloudId, proxy)) {
                response.setStatus(406);
            } else {
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "edited proxy configuration ", currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.PROXY_UPDATE.getActionTypeValue());
            }
        }
        catch (Exception exception) {
            logger.trace("exception trying to edit proxy ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of editproxy ..... ");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/settings/proxies/"}, method={RequestMethod.DELETE})
    public void deleteEncryptionKey(@PathVariable(value="version") String version, @PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String proxyHost = request.getHeader("proxyHost");
        logger.debug("Entering removeProxy ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during deleteProxy ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                logger.error("Error performAuthorization during deleteProxy ......");
                return;
            }
            if (!StringUtils.isEmpty((String)proxyHost) && 0 < this.settingsService.removeProxy(cloudId, proxyHost)) {
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "deleted proxy configuration ", currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.PROXY_DELETE.getActionTypeValue());
            } else {
                response.setStatus(404);
            }
        }
        catch (Exception exception) {
            logger.trace("exception trying to delete proxy ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of proxy ..... ");
    }

    @GetMapping(value={"{version}/cloud/{cloudName}/settings/proxies/"})
    public ModelAndView getEncryptionKeyForproxyHost(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String token;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        String proxyHost = request.getHeader("proxyHost");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token = request.getHeader("token")).getUser().isAdmin()) {
            logger.debug("not a admin user so return");
            response.setStatus(403);
            return null;
        }
        if (!this.performAuthorization(cloudId, cloudName, token, response)) {
            logger.error("Error performAuthorization during getProxy ......");
            return null;
        }
        try {
            Proxy proxy = this.settingsService.getSpecificProxy(cloudId, proxyHost);
            if (proxy != null) {
                response.setStatus(200);
                modelAndView.addObject((Object)proxy);
            } else {
                response.setStatus(404);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }
}

