/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.service.NetworkManagementService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.UpnpNetworkStatisticTo;
import com.parablu.pcbd.domain.User;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class NetworkManagementController
extends BaseController {
    private static Logger logger = LogManager.getLogger(NetworkManagementController.class);
    @Autowired
    private NetworkManagementService networkManagementService;
    @Autowired
    private LicenseService licenseService;

    @RequestMapping(value={"cloud/{cloudName}/network/upnp/status"}, method={RequestMethod.GET})
    public ModelAndView checkUpnpStatus(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        if (cloudName == null) {
            response.setStatus(400);
        }
        User currentUser = new User();
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        if (!this.performAuthorization(cl.getCloud().getCloudId(), cloudName, token, currentUser, response)) {
            return null;
        }
        if (!currentUser.isAdmin()) {
            response.setStatus(401);
            return null;
        }
        try {
            UpnpNetworkStatisticTo upnpDetailTo = this.networkManagementService.checkUpnpStatus();
            response.setStatus(200);
            if (upnpDetailTo == null) {
                modelAndView.addObject((Object)new UpnpNetworkStatisticTo(false, null));
            } else {
                modelAndView.addObject((Object)upnpDetailTo);
            }
            return modelAndView;
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.debug("Exception", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/network/upnp/configure"}, method={RequestMethod.GET})
    public void changeUpnpSettings(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        if (cloudName == null) {
            response.setStatus(400);
        }
        User currentUser = new User();
        String token = request.getHeader("token");
        boolean enable = Boolean.parseBoolean(request.getHeader("enable"));
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        if (!this.performAuthorization(cl.getCloud().getCloudId(), cloudName, token, currentUser, response)) {
            return;
        }
        if (!currentUser.isAdmin()) {
            response.setStatus(401);
            return;
        }
        try {
            this.networkManagementService.configureUpnp(enable);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.debug("Exception", (Throwable)e);
        }
    }
}

