/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.settings.service.LocalFileSystemService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.element.LocalFileSystemElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LocalFileSystemController
extends BaseController {
    private static Logger logger = LogManager.getLogger(LocalFileSystemController.class);
    @Autowired
    private LocalFileSystemService localFileSystemService;
    @Autowired
    private LicenseService licenseService;
    private static final String ERROR_CHECKLICENSE_DURING_SAVE_ENCRYPTION_KEY = "Error checkLicense during save encryptionkey ......";
    private static final String EXCEPTION_TRYING_TO_SAVE_LOCAL_FILE_SYSTEM_DETAILS = "exception trying to save local file system details ... ";

    @RequestMapping(value={"/cloud/{cloudName}/save/localfs/"}, method={RequestMethod.POST})
    public void saveLocalFileSystem(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody LocalFileSystemElement localFileSystemElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Entering local File System ..... ");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error(ERROR_CHECKLICENSE_DURING_SAVE_ENCRYPTION_KEY);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                logger.error("Error performAuthorization during save encryptionkey ......");
                return;
            }
            this.localFileSystemService.saveLocalFileSystemDetails(cloudId, localFileSystemElement);
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.debug(EXCEPTION_TRYING_TO_SAVE_LOCAL_FILE_SYSTEM_DETAILS, (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of save local file system ..... ");
    }

    @RequestMapping(value={"/cloud/{cloudName}/get/localfs/"}, method={RequestMethod.GET})
    public ModelAndView getLocalFileSystem(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Entering get local File System ..... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error(ERROR_CHECKLICENSE_DURING_SAVE_ENCRYPTION_KEY);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                logger.error("Error performAuthorization during save encryptionkey ......");
                return null;
            }
            LocalFileSystemElement fileSystemElement = this.localFileSystemService.getLocalFileSystemDetails(cloudId);
            response.setStatus(200);
            modelAndView.addObject((Object)fileSystemElement);
        }
        catch (Exception exception) {
            logger.debug(EXCEPTION_TRYING_TO_SAVE_LOCAL_FILE_SYSTEM_DETAILS, (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of get local file system ..... ");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/get/localfs/details"}, method={RequestMethod.GET})
    public ResponseEntity<LocalFileSystemElement> getLocalFileSystemDetails(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering get local File System ..... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        LocalFileSystemElement fileSystemElement = null;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error(ERROR_CHECKLICENSE_DURING_SAVE_ENCRYPTION_KEY);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            fileSystemElement = this.localFileSystemService.getLocalFileSystemDetails(cloudId);
            response.setStatus(200);
            modelAndView.addObject((Object)fileSystemElement);
        }
        catch (Exception exception) {
            logger.debug(EXCEPTION_TRYING_TO_SAVE_LOCAL_FILE_SYSTEM_DETAILS, (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of get local file system ..... ");
        return new ResponseEntity(fileSystemElement, HttpStatus.OK);
    }
}

